/*
 * Decompiled with CFR 0.152.
 */
package com.imagero.uio.bio.content;

import com.imagero.uio.bio.content.HTTPContent;
import com.imagero.uio.bio.content.Range;
import com.imagero.uio.impl.TmpRandomAccessFile;
import com.imagero.util.Vector;
import java.io.File;
import java.io.IOException;
import java.net.URL;

public class FileCachedHTTPContent
extends HTTPContent {
    File tmp;
    TmpRandomAccessFile tmpRaf;
    Vector ranges = new Vector();

    public FileCachedHTTPContent(URL url, File tmp) throws IOException {
        super(url);
        this.tmp = tmp;
        this.tmpRaf = new TmpRandomAccessFile(tmp, "rw");
    }

    public int load(long offset, int bpos, byte[] buffer) throws IOException {
        if (this.contains(offset, buffer.length - bpos)) {
            this.tmpRaf.seek(offset);
            this.tmpRaf.readFully(buffer, bpos, buffer.length - bpos);
            return buffer.length - bpos;
        }
        int k2 = super.load(offset, bpos, buffer);
        if (k2 > 0) {
            this.tmpRaf.seek(offset);
            this.tmpRaf.write(buffer, bpos, k2);
            this.addRange(offset, k2);
        }
        return k2;
    }

    boolean contains(long offset, int length) {
        Range r0 = new Range(offset, offset + (long)length);
        int i2 = 0;
        while (i2 < this.ranges.size()) {
            Range r2 = (Range)this.ranges.elementAt(i2);
            if (r2.contains(r0)) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    void addRange(long offset, int length) {
        Range r0 = new Range(offset, offset + (long)length);
        int i2 = 0;
        while (i2 < this.ranges.size()) {
            Range r2 = (Range)this.ranges.elementAt(i2);
            if (r2.canJoin(r0)) {
                r2.join(r0);
                int j2 = 0;
                while (j2 < this.ranges.size()) {
                    Range r1 = (Range)this.ranges.elementAt(j2);
                    if (r2 != r1 && r2.canJoin(r1)) {
                        r2.join(r1);
                        --j2;
                        this.ranges.remove(r1);
                    }
                    ++j2;
                }
                return;
            }
            ++i2;
        }
        this.ranges.add(r0);
    }

    public boolean canReload() {
        return true;
    }
}

