/*
 * Decompiled with CFR 0.152.
 */
package com.imagero.uio.bio.content;

import com.imagero.uio.bio.content.Content;
import com.imagero.uio.bio.content.IndexAndStart;
import java.io.IOException;

public class ByteArrayContent
extends Content {
    byte[][] data;

    public ByteArrayContent(byte[][] data) {
        this.data = data;
    }

    public int load(long offset, int bpos, byte[] buffer) throws IOException {
        IndexAndStart ias = this.getIAS(offset);
        if (ias == null) {
            return 0;
        }
        int index = ias.index;
        byte[] src = this.data[index];
        long start = ias.start;
        int pos = (int)(offset - start);
        int toCopy = Math.min(src.length - pos, buffer.length - bpos);
        if (toCopy > 0) {
            System.arraycopy(src, pos, buffer, bpos, toCopy);
            if (toCopy < buffer.length - bpos) {
                return toCopy + this.load(offset + (long)toCopy, bpos + toCopy, buffer);
            }
        }
        return toCopy;
    }

    public void close() {
    }

    private IndexAndStart getIAS(long offset) {
        long start = 0L;
        int i2 = 0;
        while (i2 < this.data.length) {
            byte[] src = this.data[i2];
            int length = src.length;
            long end = start + (long)length;
            if (offset >= start && offset <= end) {
                return new IndexAndStart(i2, start);
            }
            start += (long)length;
            ++i2;
        }
        return null;
    }

    public void save(long offset, int spos, byte[] src, int length) throws IOException {
        IndexAndStart ias = this.getIAS(offset);
        if (ias == null) {
            return;
        }
        int index = ias.index;
        long start = ias.start;
        int dpos = (int)(offset - start);
        byte[] dest = this.data[index];
        int request = Math.min(length, src.length - spos);
        int toCopy = Math.min(dest.length - dpos, request);
        if (request > 0 && toCopy > 0) {
            System.arraycopy(src, spos, dest, dpos, toCopy);
            if (toCopy < request) {
                this.save(offset + (long)toCopy, spos + toCopy, src, request - toCopy);
            }
        }
    }

    public boolean canReload() {
        return true;
    }

    public long length() throws IOException {
        long length = 0L;
        int i2 = 0;
        while (i2 < this.data.length) {
            byte[] dest = this.data[i2];
            length += (long)dest.length;
            ++i2;
        }
        return length;
    }

    public boolean writable() {
        return true;
    }
}

