/*
 * Decompiled with CFR 0.152.
 */
package com.imagero.uio.bio;

import com.imagero.uio.bio.Buffer;
import com.imagero.uio.bio.BufferPosition;
import com.imagero.uio.bio.VSBInputStream;
import com.imagero.uio.bio.VSBOutputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class VariableSizeByteBuffer {
    protected Buffer buf;
    int count;
    boolean changed;

    public VariableSizeByteBuffer(int size) {
        this(new byte[size]);
    }

    public VariableSizeByteBuffer(byte[] buf) {
        this(new Buffer(buf));
    }

    VariableSizeByteBuffer(Buffer buf) {
        this.buf = buf;
        this.count = buf.buffer.length;
    }

    public VariableSizeByteBuffer create() {
        return new VariableSizeByteBuffer(this.buf);
    }

    public void seek(int pos, BufferPosition position) {
        position.pos = pos;
    }

    public int read(BufferPosition position) {
        if (position.pos >= this.count) {
            return -1;
        }
        return this.buf.buffer[position.pos++] & 0xFF;
    }

    public long skip(long n2, BufferPosition position) {
        long p2 = Math.max(0L, Math.min(n2, Integer.MAX_VALUE));
        position.pos = (int)((long)position.pos + p2);
        return p2;
    }

    public int availableForWriting(BufferPosition position) {
        return this.buf.buffer.length - position.pos;
    }

    public int availableForReading(BufferPosition position) {
        return Math.max(0, this.count - position.pos);
    }

    public int read(byte[] dest, int offset, int length, BufferPosition position) {
        int available = this.availableForReading(position);
        int toRead = Math.max(0, Math.min(length, available));
        if (toRead > 0) {
            System.arraycopy(this.buf.buffer, position.pos, dest, offset, toRead);
            position.pos += toRead;
        }
        return toRead;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = Math.min(Math.max(count, 0), this.buf.buffer.length);
    }

    public void writeBuffer(OutputStream out) throws IOException {
        out.write(this.buf.buffer, 0, this.count);
    }

    public void writeBuffer(DataOutput out) throws IOException {
        out.write(this.buf.buffer, 0, this.count);
    }

    public void write(byte[] b2, int offset, int length, BufferPosition position) {
        if (length > 0) {
            this.checkSize(length, position);
            System.arraycopy(b2, offset, this.buf.buffer, position.pos, length);
            position.pos += length;
            this.count = Math.max(this.count, position.pos);
        }
    }

    public void write(int b2, BufferPosition position) {
        this.checkSize(1, position);
        this.buf.buffer[position.pos++] = (byte)b2;
        this.count = Math.max(this.count, position.pos);
    }

    private synchronized void checkSize(int k2, BufferPosition position) {
        if (position.pos + k2 > this.buf.buffer.length) {
            byte[] newbuf = new byte[Math.max(this.buf.buffer.length << 1, position.pos + k2)];
            System.arraycopy(this.buf.buffer, 0, newbuf, 0, this.count);
            this.buf.buffer = newbuf;
        }
    }

    public InputStream getInputStream(int offset) {
        return new VSBInputStream(offset, this);
    }

    public OutputStream getOutputStream(int offset) {
        return new VSBOutputStream(offset, this);
    }
}

