/*
 * Decompiled with CFR 0.152.
 */
package com.imagero.uio.bio;

import com.imagero.uio.bio.BufferPosition;
import com.imagero.uio.bio.VariableSizeByteBuffer;
import java.io.IOException;
import java.io.InputStream;

class VSBInputStream
extends InputStream {
    VariableSizeByteBuffer buffer;
    BufferPosition position;
    int mark;
    long offset;

    public VSBInputStream(VariableSizeByteBuffer buffer) {
        this.buffer = buffer;
        this.position = new BufferPosition(Integer.MAX_VALUE);
    }

    public VSBInputStream(int offset, VariableSizeByteBuffer buffer) {
        this.buffer = buffer;
        this.position = new BufferPosition(Integer.MAX_VALUE);
        buffer.seek(offset, this.position);
        this.offset = offset;
    }

    public int read() {
        return this.buffer.read(this.position);
    }

    public int read(byte[] b2) throws IOException {
        return this.buffer.read(b2, 0, b2.length, this.position);
    }

    public int read(byte[] b2, int off, int len) {
        return this.buffer.read(b2, off, len, this.position);
    }

    public long skip(long n2) {
        return this.buffer.skip(n2, this.position);
    }

    public int available() {
        return this.buffer.availableForReading(this.position);
    }

    public synchronized void mark(int readlimit) {
        this.mark = this.position.pos;
    }

    public synchronized void reset() throws IOException {
        this.buffer.seek(this.mark, this.position);
    }

    public boolean markSupported() {
        return true;
    }

    public long getPosition() {
        return (long)this.position.pos - this.offset;
    }

    public void setPosition(long pos) {
        this.buffer.seek((int)pos, this.position);
    }
}

