/*
 * Decompiled with CFR 0.152.
 */
package com.imagero.uio.bio;

import com.imagero.uio.UIOStreamBuilder;
import com.imagero.uio.bio.BufferIndex;
import com.imagero.uio.bio.FixedSizeByteBuffer;
import com.imagero.uio.bio.Ring;
import com.imagero.uio.bio.content.Content;
import com.imagero.uio.bio.content.SynchronizedContent;
import com.imagero.util.OpenVector;
import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class IOController {
    OpenVector bufs = new OpenVector(100);
    int bufferSize = UIOStreamBuilder.DEFAULT_CHUNK_SIZE;
    int arrayLength = 1000;
    Content content;
    Ring rs;
    int maxBufferCount = UIOStreamBuilder.DEFAULT_CHUNK_COUNT;
    long explicitLength;
    int streamCount;

    public IOController(int bufferSize, Content content) {
        this.bufferSize = bufferSize;
        this.content = content;
        this.rs = new Ring(this.maxBufferCount);
    }

    final void setLength(long newLength) {
        this.explicitLength = newLength;
    }

    private Enumeration buffers(boolean allowNullValues) {
        return new 1(allowNullValues, this);
    }

    private Enumeration buffers(long maxPos, boolean allowNullValues) {
        return new 2(allowNullValues, maxPos, this);
    }

    long length() {
        int maxI;
        if (this.explicitLength > 0L) {
            return this.explicitLength;
        }
        long contentLength = 0L;
        try {
            contentLength = this.content.length();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        Object[] elements = this.bufs.getElements();
        int i2 = maxI = elements.length - 1;
        while (i2 >= 0) {
            BufferArray ba = (BufferArray)elements[i2];
            if (ba != null) {
                int maxJ;
                FixedSizeByteBuffer[] buffers = ba.buffers;
                int j2 = maxJ = buffers.length - 1;
                while (j2 >= 0) {
                    FixedSizeByteBuffer buffer = buffers[j2];
                    if (buffer != null) {
                        int count = buffer.getCount();
                        long startOffset = this.getStartOffset(buffer.index, this.bufferSize);
                        if (count > 0) {
                            return Math.max(contentLength, startOffset + (long)count);
                        }
                    }
                    --j2;
                }
            }
            --i2;
        }
        return contentLength;
    }

    void writeTo(OutputStream out) throws IOException {
        Enumeration e2 = this.buffers(false);
        while (e2.hasMoreElements()) {
            FixedSizeByteBuffer buffer = (FixedSizeByteBuffer)e2.nextElement();
            buffer.writeBuffer(out, e2.hasMoreElements());
        }
    }

    void writeTo(DataOutput out) throws IOException {
        Enumeration e2 = this.buffers(false);
        while (e2.hasMoreElements()) {
            FixedSizeByteBuffer buffer = (FixedSizeByteBuffer)e2.nextElement();
            buffer.writeBuffer(out, e2.hasMoreElements());
        }
    }

    private FixedSizeByteBuffer getBuffer(BufferIndex bi) {
        return this.getBuffer(bi.arrayIndex, bi.index);
    }

    private FixedSizeByteBuffer getBuffer(int aIndex, int index) {
        Object[] objects = this.bufs.checkSize(aIndex);
        BufferArray ba = (BufferArray)objects[aIndex];
        if (ba == null) {
            ba = new BufferArray();
            objects[aIndex] = ba;
        }
        return ba.buffers[index];
    }

    protected void setBuffer(BufferIndex index, FixedSizeByteBuffer buffer) {
        Object[] objects = this.bufs.checkSize(index.arrayIndex);
        BufferArray ba = (BufferArray)objects[index.arrayIndex];
        ba.buffers[index.index] = buffer;
    }

    public long flushBefore(long pos) {
        pos = pos / (long)this.bufferSize * (long)this.bufferSize;
        Enumeration e2 = this.buffers(pos, true);
        while (e2.hasMoreElements()) {
            FixedSizeByteBuffer o2 = (FixedSizeByteBuffer)e2.nextElement();
            if (o2 == null) continue;
            o2.buf = null;
        }
        return pos;
    }

    public BufferIndex getBufferIndex(long pos) {
        if (pos < 0L) {
            throw new IllegalArgumentException("Negative stream position");
        }
        long count = pos / (long)this.bufferSize;
        long aIndex = count / (long)this.arrayLength;
        int index = (int)(count % (long)this.arrayLength);
        if (aIndex > Integer.MAX_VALUE) {
            throw new IndexOutOfBoundsException("Please increase buffer size");
        }
        if (index < 0) {
            throw new IndexOutOfBoundsException("Please increase buffer size");
        }
        BufferIndex bi = new BufferIndex((int)aIndex, index);
        return bi;
    }

    public FixedSizeByteBuffer getBuffer(long pos) {
        return this.getBuffer(this.getBufferIndex(pos));
    }

    FixedSizeByteBuffer getBuffer(long pos, boolean load) throws IOException {
        BufferIndex bi = this.getBufferIndex(pos);
        long startOffset = this.getStartOffset(bi, this.bufferSize);
        FixedSizeByteBuffer sb2 = this.getBuffer(bi);
        if (sb2 == null) {
            sb2 = FixedSizeByteBuffer.createBuffer(new byte[this.bufferSize]);
            this.setBuffer(bi, sb2);
            sb2.index = bi;
            if (load || this.content.canReload() && this.content.length() >= startOffset + (long)this.bufferSize) {
                int size;
                long max = this.content.length();
                if (pos > max) {
                    return null;
                }
                sb2.count = size = this.content.load(startOffset, sb2.buf);
            }
            if (this.content.canReload()) {
                this.checkBuffers(sb2);
            }
        } else if (sb2.buf == null) {
            int size;
            long max = this.content.length();
            if (pos > max) {
                return null;
            }
            sb2.buf = new byte[this.bufferSize];
            sb2.count = size = this.content.load(startOffset, sb2.buf);
        }
        return sb2;
    }

    private void checkBuffers(FixedSizeByteBuffer buffer0) {
        FixedSizeByteBuffer buffer = (FixedSizeByteBuffer)this.rs.add(buffer0);
        if (buffer != null && this.content.writable()) {
            if (buffer.changed) {
                try {
                    long offset = this.getStartOffset(buffer.index, this.bufferSize);
                    this.content.save(offset, 0, buffer.buf, buffer.getCount());
                    buffer.changed = false;
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
            this.setBuffer(buffer.index, null);
            buffer.buf = null;
        }
    }

    void sync() throws IOException {
        boolean canWrite = this.content.writable();
        if (!canWrite) {
            return;
        }
        try {
            long length = this.content.length();
        }
        catch (IOException iOException) {
            return;
        }
        Enumeration e2 = this.buffers(true);
        while (e2.hasMoreElements()) {
            FixedSizeByteBuffer buffer = (FixedSizeByteBuffer)e2.nextElement();
            if (buffer == null || !buffer.changed) continue;
            long offset = this.getStartOffset(buffer.index, this.bufferSize);
            this.content.save(offset, 0, buffer.buf, buffer.getCount());
            buffer.changed = false;
        }
    }

    public long getStartOffset(BufferIndex bufferIndex, int bufferSize) {
        long res = bufferIndex.arrayIndex * this.arrayLength * bufferSize;
        return res += (long)(bufferIndex.index * bufferSize);
    }

    public boolean isSynchronizedContent() {
        return this.content instanceof SynchronizedContent;
    }

    public void setSynchronizedContent(boolean b2) {
        if (b2) {
            if (!this.isSynchronizedContent()) {
                this.content = new SynchronizedContent(this.content);
            }
        } else if (this.isSynchronizedContent()) {
            SynchronizedContent synchronizedContent = (SynchronizedContent)this.content;
            this.content = synchronizedContent.getContent();
        }
    }

    public void close() {
        if (--this.streamCount <= 0 && this.content != null) {
            this.content.close();
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.content != null) {
            this.content.close();
        }
        this.content = null;
        this.rs = null;
        this.bufs = null;
    }

    private static final class 1
    implements Enumeration {
        private final /* synthetic */ boolean val$allowNullValues;
        private final /* synthetic */ IOController this$0;
        final FixedSizeByteBuffer empty;
        final long length;
        final BufferIndex max;
        final BufferIndex bi;

        public boolean hasMoreElements() {
            boolean b2 = this.bi.arrayIndex < this.max.arrayIndex;
            boolean b22 = this.bi.index <= this.max.index;
            return b2 || b22;
        }

        public Object nextElement() {
            if (this.hasMoreElements()) {
                FixedSizeByteBuffer fb2;
                if (this.bi.index >= this.this$0.arrayLength) {
                    this.bi.index = 0;
                    ++this.bi.arrayIndex;
                }
                return (fb2 = this.this$0.getBuffer(this.bi.arrayIndex, this.bi.index++)) != null || this.val$allowNullValues ? fb2 : this.empty;
            }
            throw new NoSuchElementException();
        }

        /* synthetic */ 1(boolean val$allowNullValues, IOController this$0) {
            this.val$allowNullValues = val$allowNullValues;
            this.this$0 = this$0;
            this.empty = FixedSizeByteBuffer.createBuffer(new byte[this$0.bufferSize]);
            this.length = this$0.length();
            this.max = this$0.getBufferIndex(this.length);
            this.bi = new BufferIndex(0, 0);
        }
    }

    private static final class 2
    implements Enumeration {
        private final /* synthetic */ boolean val$allowNullValues;
        private final /* synthetic */ IOController this$0;
        final FixedSizeByteBuffer empty;
        final long length;
        final BufferIndex max;
        final BufferIndex bi;

        public boolean hasMoreElements() {
            boolean b2 = this.bi.arrayIndex < this.max.arrayIndex;
            boolean b22 = this.bi.index <= this.max.index;
            return b2 || b22;
        }

        public Object nextElement() {
            if (this.hasMoreElements()) {
                FixedSizeByteBuffer fb2;
                if (this.bi.index >= this.this$0.arrayLength) {
                    this.bi.index = 0;
                    ++this.bi.arrayIndex;
                }
                return (fb2 = this.this$0.getBuffer(this.bi.arrayIndex, this.bi.index++)) != null || this.val$allowNullValues ? fb2 : this.empty;
            }
            throw new NoSuchElementException();
        }

        /* synthetic */ 2(boolean val$allowNullValues, long val$maxPos, IOController this$0) {
            this.val$allowNullValues = val$allowNullValues;
            this.this$0 = this$0;
            this.empty = FixedSizeByteBuffer.createBuffer(new byte[this$0.bufferSize]);
            this.length = Math.min(val$maxPos, this$0.length());
            this.max = this$0.getBufferIndex(this.length);
            this.bi = new BufferIndex(0, 0);
        }
    }

    private class BufferArray {
        FixedSizeByteBuffer[] buffers;

        public BufferArray() {
            IOController.this = IOController.this;
            this.buffers = new FixedSizeByteBuffer[IOController.this.arrayLength];
        }
    }
}

