/*
 * Decompiled with CFR 0.152.
 */
package com.imagero.uio.bio;

import com.imagero.uio.bio.BufferIndex;
import com.imagero.uio.bio.BufferPosition;
import com.imagero.uio.bio.FixedSizeByteBuffer;
import com.imagero.uio.bio.IOController;
import com.imagero.uio.bio.StreamPosition;
import java.io.IOException;
import java.io.OutputStream;

public class IOCOutputStream
extends OutputStream {
    FixedSizeByteBuffer buffer;
    BufferIndex bufferIndex;
    BufferPosition bufferPosition;
    IOController controller;
    StreamPosition streamPosition = new StreamPosition();
    long offset;
    long mark;

    public IOCOutputStream(IOController controller) {
        this.controller = controller;
        ++controller.streamCount;
    }

    public IOCOutputStream(IOController controller, long offset) {
        this.controller = controller;
        ++controller.streamCount;
        this.offset = offset;
        this.bufferPosition = new BufferPosition(controller.bufferSize);
        this.seek(0L);
    }

    public void seek(long offset) {
        this.streamPosition.pos = offset + this.offset;
    }

    protected void prepareBufferForWriting() throws IOException {
        BufferIndex index = this.controller.getBufferIndex(this.streamPosition.pos);
        if (!index.equals(this.bufferIndex) || this.buffer == null || this.buffer.buf == null) {
            this.bufferIndex = index;
            this.buffer = this.controller.getBuffer(this.streamPosition.pos, false);
        }
        this.bufferPosition.pos = (int)(this.streamPosition.pos % (long)this.controller.bufferSize);
        this.buffer.changed = true;
    }

    private void checkBuffer() throws IOException {
        if (this.buffer == null || this.bufferPosition.available() <= 0) {
            this.prepareBufferForWriting();
        }
    }

    public void write(int b2) throws IOException {
        this.checkBuffer();
        this.buffer.write(b2, this.bufferPosition);
        ++this.streamPosition.pos;
    }

    public void write(byte[] b2) throws IOException {
        this.write(b2, 0, b2.length);
    }

    public void write(byte[] b2, int offset, int length) throws IOException {
        while (length > 0) {
            this.checkBuffer();
            int written = this.buffer.write(b2, offset, length, this.bufferPosition);
            length -= written;
            offset += written;
            this.streamPosition.pos += (long)written;
        }
    }

    public void flush() throws IOException {
        if (this.controller != null) {
            this.controller.sync();
        }
    }

    public void close() throws IOException {
        this.flush();
        if (this.controller != null) {
            this.controller.close();
            this.controller = null;
        }
    }
}

