/*
 * Decompiled with CFR 0.152.
 */
package com.imagero.uio.bio;

import com.imagero.uio.bio.BufferIndex;
import com.imagero.uio.bio.BufferPosition;
import com.imagero.uio.bio.FixedSizeByteBuffer;
import com.imagero.uio.bio.IOController;
import com.imagero.uio.bio.StreamPosition;
import java.io.IOException;
import java.io.InputStream;

public class IOCInputStream
extends InputStream {
    FixedSizeByteBuffer buffer;
    BufferIndex bufferIndex;
    BufferPosition bufferPosition;
    IOController controller;
    StreamPosition streamPosition = new StreamPosition();
    long offset;
    long mark;

    public IOCInputStream(IOController controller) {
        this.controller = controller;
        ++controller.streamCount;
    }

    public IOCInputStream(IOController controller, long offset) {
        this.controller = controller;
        ++controller.streamCount;
        this.offset = offset;
        this.bufferPosition = new BufferPosition(controller.bufferSize);
        this.seek(0L);
    }

    public void seek(long offset) {
        this.streamPosition.pos = offset + this.offset;
        this.bufferPosition.pos = (int)(this.streamPosition.pos % (long)this.controller.bufferSize);
    }

    private void prepareBufferForReading() {
        BufferIndex index = this.controller.getBufferIndex(this.streamPosition.pos);
        if (!index.equals(this.bufferIndex) || this.buffer == null || this.buffer.buf == null) {
            this.bufferIndex = index;
            try {
                this.buffer = this.controller.getBuffer(this.streamPosition.pos, true);
            }
            catch (IOException iOException) {}
        }
        if (this.buffer != null) {
            this.bufferPosition.pos = (int)(this.streamPosition.pos % (long)this.controller.bufferSize);
        }
    }

    public int read() throws IOException {
        this.checkBuffer();
        if (this.buffer != null) {
            ++this.streamPosition.pos;
            return this.buffer.read(this.bufferPosition);
        }
        return -1;
    }

    public int available() throws IOException {
        if (this.buffer != null) {
            return this.buffer.availableForReading(this.bufferPosition);
        }
        return 0;
    }

    private void checkBuffer() {
        if (this.buffer == null || this.bufferPosition.available() <= 0) {
            this.prepareBufferForReading();
        }
    }

    public long skip(long n2) throws IOException {
        this.checkBuffer();
        if (this.buffer == null) {
            return 0L;
        }
        long skp = this.buffer.skip(n2, this.bufferPosition);
        this.streamPosition.pos += skp;
        return skp;
    }

    public int read(byte[] b2) throws IOException {
        return this.read(b2, 0, b2.length);
    }

    public int read(byte[] b2, int offset, int length) throws IOException {
        this.checkBuffer();
        if (this.buffer == null) {
            return -1;
        }
        int rc = this.buffer.read(b2, offset, length, this.bufferPosition);
        if (rc > 0) {
            this.streamPosition.pos += (long)rc;
        }
        return rc;
    }

    public boolean markSupported() {
        return true;
    }

    public synchronized void mark(int readlimit) {
        this.mark = this.streamPosition.pos;
    }

    public synchronized void reset() throws IOException {
        this.seek(this.mark);
    }

    public void close() throws IOException {
        if (this.controller != null) {
            this.controller.close();
            this.controller = null;
        }
    }

    public long getPosition() {
        return this.streamPosition.pos - this.offset;
    }
}

