/*
 * Decompiled with CFR 0.152.
 */
package com.imagero.uio.bio;

import com.imagero.uio.RandomAccessIO;
import com.imagero.uio.bio.BufferIndex;
import com.imagero.uio.bio.BufferPosition;
import com.imagero.uio.bio.FSBRandomAccessIO;
import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;

public class FixedSizeByteBuffer {
    protected byte[] buf;
    protected int count;
    boolean changed;
    BufferIndex index;

    protected FixedSizeByteBuffer(byte[] buf) {
        this.buf = buf;
    }

    public int read(BufferPosition position) {
        if (this.availableForReading(position) > 0) {
            int v2 = this.buf[position.pos++] & 0xFF;
            return v2;
        }
        return -1;
    }

    public long skip(long n2, BufferPosition position) {
        long p2 = Math.max(0L, Math.min((long)(this.count - position.pos), n2));
        position.pos = (int)((long)position.pos + p2);
        return p2;
    }

    public BufferPosition createPosition() {
        return new BufferPosition(this.buf.length);
    }

    public int availableForReading(BufferPosition position) {
        return Math.max(0, this.count - position.pos);
    }

    public int availableForWriting(BufferPosition position) {
        return Math.max(0, this.buf.length - position.pos);
    }

    public int read(byte[] dest, int offset, int length, BufferPosition position) {
        int available = this.availableForReading(position);
        int toCopy = Math.max(0, Math.min(length, available));
        if (toCopy > 0) {
            System.arraycopy(this.buf, position.pos, dest, offset, toCopy);
            position.pos += toCopy;
        }
        return toCopy;
    }

    public void write(int b2, BufferPosition position) {
        this.buf[position.pos++] = (byte)b2;
        this.count = Math.max(position.pos, this.count);
    }

    public int getCount() {
        return this.count;
    }

    public int getPosition(BufferPosition position) {
        return position.pos;
    }

    public void setCount(int count) {
        this.count = Math.min(Math.max(count, 0), this.buf.length);
    }

    public void writeBuffer(OutputStream out, boolean wholeBuffer) throws IOException {
        if (wholeBuffer) {
            out.write(this.buf);
        } else {
            out.write(this.buf, 0, this.count);
        }
    }

    public void writeBuffer(DataOutput out, boolean wholeBuffer) throws IOException {
        if (wholeBuffer) {
            out.write(this.buf);
        } else {
            out.write(this.buf, 0, this.count);
        }
    }

    public void writeBuffer(OutputStream out) throws IOException {
        out.write(this.buf);
    }

    public void writeBuffer(DataOutput out) throws IOException {
        out.write(this.buf);
    }

    public int write(byte[] src, int offset, int length, BufferPosition position) {
        int available = this.availableForWriting(position);
        int toCopy = Math.max(0, Math.min(length, available));
        if (toCopy > 0) {
            System.arraycopy(src, offset, this.buf, position.pos, toCopy);
            position.pos += toCopy;
            this.count = Math.max(this.count, position.pos);
        }
        return toCopy;
    }

    public RandomAccessIO create() {
        return new FSBRandomAccessIO(this);
    }

    public RandomAccessIO create(int offset, int length) {
        return new FSBRandomAccessIO(this, offset, length);
    }

    public static FixedSizeByteBuffer createBuffer(byte[] buf) {
        return new FixedSizeByteBuffer(buf);
    }
}

