/*
 * Decompiled with CFR 0.152.
 */
package com.imagero.uio.bio;

import com.imagero.uio.RandomAccessIO;
import com.imagero.uio.RandomAccessInput;
import com.imagero.uio.RandomAccessOutput;
import com.imagero.uio.bio.BufferPosition;
import com.imagero.uio.bio.FSBInputStream;
import com.imagero.uio.bio.FSBOutputStream;
import com.imagero.uio.bio.FixedSizeByteBuffer;
import com.imagero.uio.impl.AbstractRandomAccessIO;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class FSBRandomAccessIO
extends AbstractRandomAccessIO {
    FixedSizeByteBuffer buffer;
    BufferPosition position;
    int offset;
    int length;

    public FSBRandomAccessIO(FixedSizeByteBuffer buffer) {
        this(buffer, 0, buffer.buf.length);
    }

    public FSBRandomAccessIO(FixedSizeByteBuffer buffer, int offset) {
        this(buffer, offset, buffer.buf.length - offset);
    }

    public FSBRandomAccessIO(FixedSizeByteBuffer buffer, int offset, int length) {
        this.buffer = buffer;
        this.offset = offset;
        this.length = length > 0 ? length : buffer.availableForReading(buffer.createPosition());
    }

    public int read() throws IOException {
        return this.buffer.read(this.position);
    }

    public void seek(long pos) {
        this.position.pos = (int)Math.min((long)this.length, pos + (long)this.offset);
    }

    public long length() throws IOException {
        return this.length;
    }

    public long getFilePointer() throws IOException {
        return this.position.pos - this.offset;
    }

    public void setLength(long newLength) throws IOException {
        this.length = (int)Math.min((long)this.buffer.buf.length, newLength);
    }

    public void write(int b2) throws IOException {
        this.buffer.write(b2, this.position);
    }

    public void write(byte[] b2, int off, int len) throws IOException {
        this.buffer.write(b2, off, len, this.position);
    }

    public InputStream createInputStream(long offset) {
        return new FSBInputStream((int)offset, this.buffer);
    }

    public long getChildPosition(InputStream child) {
        if (child instanceof FSBInputStream) {
            FSBInputStream fsbis = (FSBInputStream)child;
            return fsbis.getPosition();
        }
        return -1L;
    }

    public void setChildPosition(InputStream child, long position) {
        if (child instanceof FSBInputStream) {
            FSBInputStream fsbis = (FSBInputStream)child;
            fsbis.setPosition(position);
        }
    }

    public OutputStream createOutputStream(long offset) {
        return new FSBOutputStream((int)offset, this.buffer);
    }

    public RandomAccessIO createIOChild(long offset, long length, int byteOrder, boolean syncPointer) throws IOException {
        FSBRandomAccessIO rio = new FSBRandomAccessIO(this.buffer, (int)offset, (int)length);
        if (syncPointer) {
            rio.position = this.position;
        }
        rio.setByteOrder(byteOrder);
        return rio;
    }

    public RandomAccessInput createInputChild(long offset, long length, int byteOrder, boolean syncPointer) throws IOException {
        return this.createIOChild(offset, 0L, byteOrder, syncPointer);
    }

    public RandomAccessOutput createOutputChild(long offset, int byteOrder, boolean syncPointer) throws IOException {
        return this.createIOChild(offset, 0L, byteOrder, syncPointer);
    }
}

