/*
 * Decompiled with CFR 0.152.
 */
package com.imagero.uio.bio;

import com.imagero.uio.bio.BufferPosition;
import com.imagero.uio.bio.FixedSizeByteBuffer;
import java.io.IOException;
import java.io.InputStream;

class FSBInputStream
extends InputStream {
    FixedSizeByteBuffer buffer;
    BufferPosition position;
    int mark;
    long offset;

    public FSBInputStream(FixedSizeByteBuffer buffer) {
        this.buffer = buffer;
        this.position = new BufferPosition(buffer.buf.length);
    }

    public FSBInputStream(int offset, FixedSizeByteBuffer buffer) {
        this.buffer = buffer;
        this.position = new BufferPosition(Integer.MAX_VALUE);
        this.position.pos = offset;
        this.offset = offset;
    }

    public int read() {
        return this.buffer.read(this.position);
    }

    public int read(byte[] b2) throws IOException {
        return this.buffer.read(b2, 0, b2.length, this.position);
    }

    public int read(byte[] b2, int off, int len) {
        return this.buffer.read(b2, off, len, this.position);
    }

    public long skip(long n2) {
        return this.buffer.skip(n2, this.position);
    }

    public int available() {
        return this.buffer.availableForReading(this.position);
    }

    public synchronized void mark(int readlimit) {
        this.mark = this.position.pos;
    }

    public synchronized void reset() throws IOException {
        this.position.pos = this.mark;
    }

    public boolean markSupported() {
        return true;
    }

    public long getPosition() {
        return (long)this.position.pos - this.offset;
    }

    public void setPosition(long pos) {
        this.position.pos = (int)(pos + this.offset);
    }
}

