/*
 * Decompiled with CFR 0.152.
 */
package com.imagero.uio.bio;

import com.imagero.uio.RandomAccessIO;
import com.imagero.uio.RandomAccessInput;
import com.imagero.uio.RandomAccessOutput;
import com.imagero.uio.bio.BufferPosition;
import com.imagero.uio.bio.VSBInputStream;
import com.imagero.uio.bio.VariableSizeByteBuffer;
import com.imagero.uio.impl.AbstractRandomAccessIO;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ByteArrayRandomAccessIO
extends AbstractRandomAccessIO
implements RandomAccessIO {
    VariableSizeByteBuffer buffer;
    BufferPosition position;
    int _offset;
    Integer length;

    private static VariableSizeByteBuffer createBuffer(int size) {
        return new VariableSizeByteBuffer(size);
    }

    private static VariableSizeByteBuffer createBuffer(byte[] data) {
        return new VariableSizeByteBuffer(data);
    }

    public ByteArrayRandomAccessIO(int initialSize) {
        this(ByteArrayRandomAccessIO.createBuffer(initialSize));
    }

    public ByteArrayRandomAccessIO(int offset, int length, VariableSizeByteBuffer buffer) {
        this._offset = offset;
        this.buffer = buffer;
        this.position = new BufferPosition(Integer.MAX_VALUE);
        this.position.pos = offset;
        if (length > 0) {
            this.length = new Integer(length);
        }
    }

    public ByteArrayRandomAccessIO(byte[] data) {
        this(ByteArrayRandomAccessIO.createBuffer(data));
    }

    public ByteArrayRandomAccessIO(VariableSizeByteBuffer buffer) {
        this.buffer = buffer;
        this.position = new BufferPosition(Integer.MAX_VALUE);
    }

    public int read() throws IOException {
        return this.buffer.read(this.position);
    }

    public long skip(long n2) throws IOException {
        return this.buffer.skip(n2, this.position);
    }

    public int read(byte[] b2, int off, int len) throws IOException {
        return this.buffer.read(b2, off, len, this.position);
    }

    public long getFilePointer() throws IOException {
        return this.position.pos - this._offset;
    }

    public long length() throws IOException {
        if (this.length != null) {
            return Math.min(this.length, this.buffer.getCount() - this._offset);
        }
        return this.buffer.getCount() - this._offset;
    }

    public void seek(long offset) throws IOException {
        if (offset + (long)this._offset > Integer.MAX_VALUE) {
            throw new IOException("Offset too big: 0x" + Long.toHexString(offset));
        }
        this.buffer.seek((int)offset + this._offset, this.position);
    }

    public void setLength(long newLength) throws IOException {
        if (newLength > Integer.MAX_VALUE) {
            throw new IOException();
        }
        this.buffer.setCount((int)newLength);
    }

    public void write(int b2) throws IOException {
        this.buffer.write(b2, this.position);
    }

    public void write(byte[] b2, int offset, int length) throws IOException {
        this.buffer.write(b2, offset, length, this.position);
    }

    public RandomAccessIO createIOChild(long offset, long length, int byteOrder, boolean syncPointer) {
        ByteArrayRandomAccessIO io = new ByteArrayRandomAccessIO((int)offset, (int)length, this.buffer);
        if (syncPointer) {
            io.buffer = this.buffer;
        }
        io.setByteOrder(byteOrder);
        return io;
    }

    public RandomAccessInput createInputChild(long offset, long length, int byteOrder, boolean syncPointer) {
        return this.createIOChild(offset, length, byteOrder, syncPointer);
    }

    public RandomAccessOutput createOutputChild(long offset, int byteOrder, boolean syncPointer) {
        return this.createIOChild(offset, 0L, byteOrder, syncPointer);
    }

    public byte[] toByteArray() throws IOException {
        byte[] b2 = new byte[(int)this.length()];
        int pos = this.position.pos;
        this.buffer.seek(0, this.position);
        this.buffer.read(b2, 0, b2.length, this.position);
        this.buffer.seek(pos, this.position);
        return b2;
    }

    public InputStream createInputStream(long offset) {
        return this.buffer.getInputStream((int)offset);
    }

    public long getChildPosition(InputStream child) {
        if (child instanceof VSBInputStream) {
            VSBInputStream vsbis = (VSBInputStream)child;
            return vsbis.getPosition();
        }
        return -1L;
    }

    public void setChildPosition(InputStream child, long pos) {
        if (child instanceof VSBInputStream) {
            VSBInputStream vsbis = (VSBInputStream)child;
            vsbis.setPosition(pos);
        }
    }

    public OutputStream createOutputStream(long offset) {
        return this.buffer.getOutputStream((int)offset);
    }
}

