/*
 * Decompiled with CFR 0.152.
 */
package com.imagero.uio.bio;

import com.imagero.uio.RandomAccessIO;
import com.imagero.uio.RandomAccessInput;
import com.imagero.uio.RandomAccessOutput;
import com.imagero.uio.bio.BufferIndex;
import com.imagero.uio.bio.BufferPosition;
import com.imagero.uio.bio.FixedSizeByteBuffer;
import com.imagero.uio.bio.IOCInputStream;
import com.imagero.uio.bio.IOCOutputStream;
import com.imagero.uio.bio.IOController;
import com.imagero.uio.bio.StreamPosition;
import com.imagero.uio.impl.AbstractRandomAccessIO;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class BufferedRandomAccessIO
extends AbstractRandomAccessIO {
    FixedSizeByteBuffer buffer;
    BufferIndex bufferIndex;
    BufferPosition bufferPosition;
    IOController controller;
    StreamPosition streamPosition = new StreamPosition();
    long offset;

    public BufferedRandomAccessIO(IOController controller) {
        this(controller, 0L);
    }

    public BufferedRandomAccessIO(IOController controller, long offset) {
        this.controller = controller;
        ++this.controller.streamCount;
        this.offset = offset;
        this.bufferPosition = new BufferPosition(controller.bufferSize);
        this.seek(0L);
    }

    public final void setLength(long newLength) throws IOException {
        this.controller.setLength(newLength);
    }

    public long flushBefore(long pos) {
        return this.controller.flushBefore(pos);
    }

    protected void prepareBufferForReading(BufferIndex index) throws IOException {
        if (!index.equals(this.bufferIndex) || this.buffer == null || this.buffer.buf == null) {
            this.bufferIndex = index;
            this.buffer = this.controller.getBuffer(this.streamPosition.pos, true);
        }
        this.bufferPosition.pos = (int)(this.streamPosition.pos % (long)this.controller.bufferSize);
    }

    protected void prepareBufferForWriting(BufferIndex index) throws IOException {
        if (!index.equals(this.bufferIndex) || this.buffer == null || this.buffer.buf == null) {
            this.bufferIndex = index;
            this.buffer = this.controller.getBuffer(this.streamPosition.pos, false);
        }
        this.bufferPosition.pos = (int)(this.streamPosition.pos % (long)this.controller.bufferSize);
        this.buffer.changed = true;
    }

    public long getFilePointer() {
        return this.streamPosition.pos - this.offset;
    }

    public long length() throws IOException {
        return this.controller.length() - this.offset;
    }

    public void seek(long pos) {
        if (pos < 0L) {
            throw new IllegalArgumentException("Negative seek offset");
        }
        this.streamPosition.pos = pos + this.offset;
        this.bufferPosition.pos = (int)(this.streamPosition.pos % (long)this.controller.bufferSize);
    }

    public int available() throws IOException {
        if (this.buffer != null) {
            return this.buffer.availableForReading(this.bufferPosition);
        }
        return 0;
    }

    public void write(int b2) throws IOException {
        this.ensureBuffer(false);
        this.buffer.write(b2, this.bufferPosition);
        ++this.streamPosition.pos;
    }

    public void write(byte[] b2, int offset, int length) throws IOException {
        while (length > 0) {
            this.ensureBuffer(false);
            int written = this.buffer.write(b2, offset, length, this.bufferPosition);
            length -= written;
            offset += written;
            this.streamPosition.pos += (long)written;
        }
    }

    public void close() throws IOException {
        this.flush();
        if (this.controller != null) {
            this.controller.close();
            this.controller = null;
        }
    }

    public void writeBuffer(OutputStream out) throws IOException {
        this.controller.writeTo(out);
    }

    public void writeBuffer(DataOutput out) throws IOException {
        this.controller.writeTo(out);
    }

    private void ensureBuffer(boolean read) throws IOException {
        BufferIndex index = this.controller.getBufferIndex(this.streamPosition.pos);
        if (read) {
            if (this.buffer == null || this.buffer.availableForReading(this.bufferPosition) <= 0 || this.bufferIndex != index) {
                this.prepareBufferForReading(index);
            }
        } else if (this.buffer == null || this.buffer.availableForWriting(this.bufferPosition) <= 0 || this.bufferIndex != index) {
            this.prepareBufferForWriting(index);
        }
    }

    public int read() throws IOException {
        try {
            this.ensureBuffer(true);
        }
        catch (IOException iOException) {
            return -1;
        }
        if (this.buffer != null) {
            ++this.streamPosition.pos;
            return this.buffer.read(this.bufferPosition);
        }
        return -1;
    }

    public long skip(long n2) throws IOException {
        this.ensureBuffer(true);
        if (this.buffer == null) {
            return 0L;
        }
        long skipped = this.buffer.skip(n2, this.bufferPosition);
        this.streamPosition.pos += skipped;
        return skipped;
    }

    public int read(byte[] b2, int offset, int length) throws IOException {
        this.ensureBuffer(true);
        if (this.buffer == null) {
            return 0;
        }
        int rc = this.buffer.read(b2, offset, length, this.bufferPosition);
        if (rc > 0) {
            this.streamPosition.pos += (long)rc;
        }
        return rc;
    }

    public RandomAccessIO createIOChild(long offset, long length, int byteOrder, boolean syncPointer) {
        BufferedRandomAccessIO io = new BufferedRandomAccessIO(this.controller, this.offset + offset);
        io.setByteOrder(byteOrder);
        if (syncPointer) {
            io.streamPosition = this.streamPosition;
        }
        return io;
    }

    public RandomAccessInput createInputChild(long offset, long length, int byteOrder, boolean syncPointer) {
        return this.createIOChild(offset, 0L, byteOrder, syncPointer);
    }

    public InputStream createInputStream(long offset) {
        return new IOCInputStream(this.controller, this.offset + offset);
    }

    public RandomAccessOutput createOutputChild(long offset, int byteOrder, boolean syncPointer) {
        return this.createIOChild(offset, 0L, byteOrder, syncPointer);
    }

    public OutputStream createOutputStream(long offset) {
        return new IOCOutputStream(this.controller, this.offset + offset);
    }

    public void flush() throws IOException {
        if (this.controller != null) {
            this.controller.sync();
        }
    }

    public boolean isBuffered() {
        return true;
    }

    public long getChildPosition(InputStream child) {
        if (child instanceof IOCInputStream) {
            IOCInputStream in = (IOCInputStream)child;
            return in.getPosition();
        }
        return -1L;
    }

    public void setChildPosition(InputStream child, long position) {
        if (child instanceof IOCInputStream) {
            IOCInputStream in = (IOCInputStream)child;
            in.seek(position);
        }
    }
}

