/*
 * Decompiled with CFR 0.152.
 */
package com.imagero.uio.bio;

import com.imagero.uio.UIOStreamBuilder;
import com.imagero.uio.bio.BufferedRandomAccessIO;
import com.imagero.uio.bio.IOController;
import com.imagero.uio.bio.content.Content;
import com.imagero.uio.bio.content.DummyContent;
import com.imagero.uio.bio.content.FileCachedHTTPContent;
import com.imagero.uio.bio.content.FileCachedInputStreamContent;
import com.imagero.uio.bio.content.HTTPContent;
import com.imagero.uio.bio.content.MemoryCachedInputStreamContent;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;

public class BIOFactory {
    public static BufferedRandomAccessIO create(int chunkSize) {
        IOController controller = BIOFactory.createIOController(chunkSize);
        BufferedRandomAccessIO out = new BufferedRandomAccessIO(controller);
        return out;
    }

    public static BufferedRandomAccessIO create(OutputStream out) {
        return BIOFactory.create(out, UIOStreamBuilder.DEFAULT_CHUNK_SIZE);
    }

    public static BufferedRandomAccessIO create(OutputStream out, int chunkSize) {
        IOController ctrl = BIOFactory.createIOController(chunkSize);
        1 bio = new 1(out, ctrl);
        return bio;
    }

    public static BufferedRandomAccessIO create(DataOutput out) {
        return BIOFactory.create(out, UIOStreamBuilder.DEFAULT_CHUNK_SIZE);
    }

    public static BufferedRandomAccessIO create(DataOutput out, int chunkSize) {
        IOController ctrl = BIOFactory.createIOController(chunkSize);
        2 bio = new 2(out, ctrl);
        return bio;
    }

    public static IOController createIOController(int chunkSize) {
        DummyContent bc2 = new DummyContent();
        IOController sb2 = new IOController(chunkSize, bc2);
        return sb2;
    }

    public static IOController createIOController(InputStream in, File tmp, int chunkSize) {
        Content bc2;
        if (tmp != null) {
            try {
                bc2 = new FileCachedInputStreamContent(in, tmp);
            }
            catch (IOException ex) {
                System.err.println("Unable to use file cache, switching to memory cache.");
                ex.printStackTrace();
                bc2 = new MemoryCachedInputStreamContent(in, chunkSize);
            }
        } else {
            bc2 = new MemoryCachedInputStreamContent(in, chunkSize);
        }
        IOController sb2 = new IOController(chunkSize, bc2);
        return sb2;
    }

    public static IOController createIOController(URL url) {
        return BIOFactory.createIOController(url, UIOStreamBuilder.DEFAULT_CHUNK_SIZE);
    }

    public static IOController createIOController(URL url, int chunkSize) {
        return BIOFactory.createIOController(url, null, chunkSize);
    }

    public static IOController createIOController(URL url, File tmp) {
        return BIOFactory.createIOController(url, tmp, UIOStreamBuilder.DEFAULT_CHUNK_SIZE);
    }

    public static IOController createIOController(URL url, File tmp, int chunkSize) {
        HTTPContent bc2;
        if (tmp != null) {
            try {
                bc2 = new FileCachedHTTPContent(url, tmp);
            }
            catch (IOException ex) {
                ex.printStackTrace();
                System.err.println("Unable to use file cache, switching to memory cache.");
                bc2 = new HTTPContent(url);
            }
        } else {
            bc2 = new HTTPContent(url);
        }
        IOController sb2 = new IOController(chunkSize, bc2);
        return sb2;
    }

    private static final class 1
    extends BufferedRandomAccessIO {
        private final /* synthetic */ OutputStream val$out;

        public void close() throws IOException {
            this.controller.writeTo(this.val$out);
            super.close();
        }

        /* synthetic */ 1(OutputStream val$out, IOController $0) {
            super($0);
            this.val$out = val$out;
        }
    }

    private static final class 2
    extends BufferedRandomAccessIO {
        private final /* synthetic */ DataOutput val$out;

        public void close() throws IOException {
            this.controller.writeTo(this.val$out);
            super.close();
        }

        /* synthetic */ 2(DataOutput val$out, IOController $0) {
            super($0);
            this.val$out = val$out;
        }
    }
}

