/*
 * Decompiled with CFR 0.152.
 */
package com.imagero.uio;

import com.imagero.uio.BaisWrapper;
import com.imagero.uio.RandomAccessIO;
import com.imagero.uio.RandomAccessInput;
import com.imagero.uio.Sys;
import com.imagero.uio.bio.BIOFactory;
import com.imagero.uio.bio.BufferedRandomAccessIO;
import com.imagero.uio.bio.ByteArrayRandomAccessIO;
import com.imagero.uio.bio.IOController;
import com.imagero.uio.bio.VariableSizeByteBuffer;
import com.imagero.uio.bio.content.ByteArrayContent;
import com.imagero.uio.bio.content.CharArrayContent;
import com.imagero.uio.bio.content.Content;
import com.imagero.uio.bio.content.DoubleArrayContent;
import com.imagero.uio.bio.content.FloatArrayContent;
import com.imagero.uio.bio.content.IntArrayContent;
import com.imagero.uio.bio.content.LongArrayContent;
import com.imagero.uio.bio.content.RandomAccessFileContent;
import com.imagero.uio.bio.content.ShortArrayContent;
import com.imagero.uio.bio.content.Span;
import com.imagero.uio.bio.content.SpannedRandomAccessIOContent;
import com.imagero.uio.bio.content.SpannedRandomAccessInputContent;
import com.imagero.uio.impl.RandomAccessFileWrapper;
import com.imagero.uio.impl.RandomAccessFileX;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.URL;

public class UIOStreamBuilder {
    public static final String READ_ONLY = "r";
    public static final String READ_WRITE = "rw";
    String mode = "r";
    int byteOrder = 19789;
    Long start;
    Long length;
    private boolean buffered = true;
    private Integer maxBufferCount;
    private Integer bufferSize;
    Creator creator;
    File cache;
    public static int DEFAULT_CHUNK_SIZE = 262144;
    public static int DEFAULT_CHUNK_COUNT = 8;

    public boolean isReadOnly() {
        return !READ_WRITE.equals(this.mode);
    }

    public UIOStreamBuilder(String filename) {
        this(new File(filename));
    }

    public UIOStreamBuilder(File file) {
        this.creator = new FileCreator(file);
    }

    public UIOStreamBuilder(RandomAccessFile rafSource) {
        this.creator = new RAFCreator(rafSource);
    }

    public UIOStreamBuilder(RandomAccessIO ra) {
        this.creator = new RAIOCreator(ra);
    }

    public UIOStreamBuilder(RandomAccessInput ro) {
        this.creator = new RAICreator(ro);
    }

    public UIOStreamBuilder(RandomAccessInput ro, Span[] spans) {
        this.creator = new SpannedCreator(ro, spans);
    }

    public UIOStreamBuilder(byte[] byteSource) {
        this.creator = new ByteCreator(byteSource);
    }

    public UIOStreamBuilder(byte[][] byteSource) {
        this.creator = byteSource.length == 1 ? new ByteCreator(byteSource[0]) : new Byte2DCreator(byteSource);
    }

    public UIOStreamBuilder(short[] shortSource) {
        this.creator = new ShortCreator(shortSource);
    }

    public UIOStreamBuilder(short[][] shortSource) {
        this.creator = new ShortCreator(shortSource);
    }

    public UIOStreamBuilder(char[] charSource) {
        this.creator = new CharCreator(charSource);
    }

    public UIOStreamBuilder(char[][] charSource) {
        this.creator = new CharCreator(charSource);
    }

    public UIOStreamBuilder(int[] intSource) {
        this.creator = new IntCreator(intSource);
    }

    public UIOStreamBuilder(int[][] intSource) {
        this.creator = new IntCreator(intSource);
    }

    public UIOStreamBuilder(long[] longSource) {
        this.creator = new LongCreator(longSource);
    }

    public UIOStreamBuilder(long[][] longSource) {
        this.creator = new LongCreator(longSource);
    }

    public UIOStreamBuilder(float[] floatSource) {
        this.creator = new FloatCreator(floatSource);
    }

    public UIOStreamBuilder(float[][] floatSource) {
        this.creator = new FloatCreator(floatSource);
    }

    public UIOStreamBuilder(double[] doubleSource) {
        this.creator = new DoubleCreator(doubleSource);
    }

    public UIOStreamBuilder(double[][] doubleSource) {
        this.creator = new DoubleCreator(doubleSource);
    }

    private static File getTmpDir() {
        String name = System.getProperty("uio.temp.dir");
        if (name != null && name.length() > 0) {
            File f2 = new File(name);
            if (!f2.exists()) {
                f2.mkdirs();
            }
            if (f2.isDirectory()) {
                return f2;
            }
        }
        return null;
    }

    static File createTempFile(String prefix) {
        File dir = UIOStreamBuilder.getTmpDir();
        if (dir != null) {
            return new File(dir, String.valueOf(prefix) + Integer.toHexString(dir.hashCode()));
        }
        return null;
    }

    public UIOStreamBuilder(URL url) {
        this.creator = new URLCreator(url);
    }

    public UIOStreamBuilder(InputStream in) {
        this.creator = new ISCreator(in);
    }

    public UIOStreamBuilder(OutputStream out) {
        this.creator = new OSCreator(out);
    }

    public UIOStreamBuilder setMode(String mode) {
        if (READ_ONLY.equals(mode) || READ_WRITE.equals(mode)) {
            this.mode = mode;
            return this;
        }
        throw new IllegalArgumentException(mode);
    }

    public UIOStreamBuilder setByteOrder(int byteOrder) {
        switch (byteOrder) {
            case 18761: 
            case 19789: {
                this.byteOrder = byteOrder;
                return this;
            }
        }
        throw new IllegalArgumentException(String.valueOf(byteOrder));
    }

    public UIOStreamBuilder setStart(long start) {
        if (start < 0L) {
            throw new IllegalArgumentException(" " + start);
        }
        this.start = new Long(start);
        return this;
    }

    public UIOStreamBuilder setLength(long length) {
        if (length < 0L) {
            throw new IllegalArgumentException(" " + length);
        }
        this.length = new Long(length);
        if (this.start == null) {
            this.start = new Long(0L);
        }
        return this;
    }

    public UIOStreamBuilder setBuffered(boolean buffered) {
        this.buffered = buffered;
        return this;
    }

    public UIOStreamBuilder setMaxBufferCount(int max) {
        this.maxBufferCount = new Integer(max);
        return this;
    }

    public UIOStreamBuilder setBufferSize(int bufferSize) {
        this.bufferSize = new Integer(bufferSize);
        return this;
    }

    public UIOStreamBuilder setCacheFile(File f2) {
        this.cache = f2;
        return this;
    }

    public RandomAccessInput create() throws IOException {
        if (this.length != null && this.length == 0L) {
            Sys.err.println("Warning: stream length is 0");
        }
        if (this.buffered) {
            return this.creator.createBuffered();
        }
        return this.creator.create();
    }

    abstract class Creator {
        abstract RandomAccessInput create() throws IOException;

        abstract RandomAccessInput createBuffered() throws IOException;

        protected int getByteOrder() {
            return UIOStreamBuilder.this.byteOrder != 0 ? UIOStreamBuilder.this.byteOrder : 19789;
        }

        protected int getBufferCount() {
            if (UIOStreamBuilder.this.maxBufferCount != null) {
                return UIOStreamBuilder.this.maxBufferCount;
            }
            return DEFAULT_CHUNK_COUNT;
        }

        protected int getBufferSize() {
            if (UIOStreamBuilder.this.bufferSize != null) {
                return UIOStreamBuilder.this.bufferSize;
            }
            return DEFAULT_CHUNK_SIZE;
        }

        Creator() {
            UIOStreamBuilder.this = UIOStreamBuilder.this;
        }
    }

    class FileCreator
    extends Creator {
        File fileSource;

        public FileCreator(File fileSource) {
            UIOStreamBuilder.this = UIOStreamBuilder.this;
            this.fileSource = fileSource;
        }

        public RandomAccessInput create() throws IOException {
            RandomAccessFileX rafx = new RandomAccessFileX(this.fileSource, UIOStreamBuilder.this.mode);
            if (UIOStreamBuilder.this.start == null && UIOStreamBuilder.this.length == null) {
                return new RandomAccessFileWrapper(rafx, this.getByteOrder());
            }
            if (UIOStreamBuilder.this.length == null) {
                return new RandomAccessFileWrapper(rafx, UIOStreamBuilder.this.start, this.getByteOrder());
            }
            return new RandomAccessFileWrapper(rafx, UIOStreamBuilder.this.start, UIOStreamBuilder.this.length, this.getByteOrder());
        }

        RandomAccessInput createBuffered() throws IOException {
            RandomAccessFileContent bc2 = new RandomAccessFileContent(this.fileSource, UIOStreamBuilder.this.mode);
            IOController controller = new IOController(DEFAULT_CHUNK_SIZE, bc2);
            BufferedRandomAccessIO bio = new BufferedRandomAccessIO(controller);
            bio.setByteOrder(UIOStreamBuilder.this.byteOrder);
            return bio;
        }
    }

    class RAFCreator
    extends Creator {
        RandomAccessFile rafSource;

        public RAFCreator(RandomAccessFile rafSource) {
            UIOStreamBuilder.this = UIOStreamBuilder.this;
            this.rafSource = rafSource;
        }

        public RandomAccessInput create() throws IOException {
            if (UIOStreamBuilder.this.start == null && UIOStreamBuilder.this.length == null) {
                return new RandomAccessFileWrapper(this.rafSource, this.getByteOrder());
            }
            if (UIOStreamBuilder.this.length == null) {
                return new RandomAccessFileWrapper(this.rafSource, UIOStreamBuilder.this.start, this.getByteOrder());
            }
            return new RandomAccessFileWrapper(this.rafSource, UIOStreamBuilder.this.start, UIOStreamBuilder.this.length, this.getByteOrder());
        }

        RandomAccessInput createBuffered() throws IOException {
            RandomAccessFileContent bc2 = new RandomAccessFileContent(this.rafSource);
            IOController controller = new IOController(DEFAULT_CHUNK_SIZE, bc2);
            return new BufferedRandomAccessIO(controller);
        }
    }

    class RAICreator
    extends Creator {
        RandomAccessInput roSource;

        public RAICreator(RandomAccessInput roSource) {
            UIOStreamBuilder.this = UIOStreamBuilder.this;
            this.roSource = roSource;
        }

        protected int getByteOrder() {
            return UIOStreamBuilder.this.byteOrder != 0 ? UIOStreamBuilder.this.byteOrder : this.roSource.getByteOrder();
        }

        public RandomAccessInput create() throws IOException {
            return this.roSource.createInputChild(UIOStreamBuilder.this.start != null ? UIOStreamBuilder.this.start : 0L, 0L, UIOStreamBuilder.this.byteOrder, true);
        }

        RandomAccessInput createBuffered() throws IOException {
            return this.create();
        }
    }

    class RAIOCreator
    extends Creator {
        RandomAccessIO raSource;

        public RAIOCreator(RandomAccessIO raSource) {
            UIOStreamBuilder.this = UIOStreamBuilder.this;
            this.raSource = raSource;
        }

        protected int getByteOrder() {
            return UIOStreamBuilder.this.byteOrder != 0 ? UIOStreamBuilder.this.byteOrder : this.raSource.getByteOrder();
        }

        public RandomAccessInput create() throws IOException {
            return this.raSource.createIOChild(UIOStreamBuilder.this.start != null ? UIOStreamBuilder.this.start : 0L, 0L, UIOStreamBuilder.this.byteOrder, true);
        }

        RandomAccessInput createBuffered() throws IOException {
            return this.create();
        }
    }

    class Byte2DCreator
    extends Creator {
        byte[][] byteSource;

        public Byte2DCreator(byte[][] byteSource) {
            UIOStreamBuilder.this = UIOStreamBuilder.this;
            this.byteSource = byteSource;
        }

        RandomAccessInput create() throws IOException {
            return this.createBuffered();
        }

        RandomAccessInput createBuffered() throws IOException {
            ByteArrayContent content = new ByteArrayContent(this.byteSource);
            IOController controller = new IOController(DEFAULT_CHUNK_SIZE, content);
            return new BufferedRandomAccessIO(controller, UIOStreamBuilder.this.start != null ? UIOStreamBuilder.this.start : 0L);
        }
    }

    class ByteCreator
    extends Creator {
        byte[] byteSource;

        public ByteCreator(byte[] byteSource) {
            UIOStreamBuilder.this = UIOStreamBuilder.this;
            this.byteSource = byteSource;
        }

        RandomAccessInput create() throws IOException {
            if (UIOStreamBuilder.this.start != null) {
                VariableSizeByteBuffer vsb = new VariableSizeByteBuffer(this.byteSource);
                return new ByteArrayRandomAccessIO(UIOStreamBuilder.this.start.intValue(), UIOStreamBuilder.this.length != null ? UIOStreamBuilder.this.length.intValue() : 0, vsb);
            }
            return new ByteArrayRandomAccessIO(this.byteSource);
        }

        RandomAccessInput createBuffered() throws IOException {
            return this.create();
        }
    }

    class ShortCreator
    extends Creator {
        short[][] shortSource;

        public ShortCreator(short[] shortSource) {
            this(new short[][]{shortSource});
        }

        public ShortCreator(short[][] shortSource) {
            UIOStreamBuilder.this = UIOStreamBuilder.this;
            this.shortSource = shortSource;
        }

        RandomAccessInput create() throws IOException {
            ShortArrayContent content = new ShortArrayContent(this.shortSource);
            IOController controller = new IOController(DEFAULT_CHUNK_SIZE, content);
            return new BufferedRandomAccessIO(controller, UIOStreamBuilder.this.start != null ? UIOStreamBuilder.this.start : 0L);
        }

        RandomAccessInput createBuffered() throws IOException {
            return this.create();
        }
    }

    class CharCreator
    extends Creator {
        char[][] charSource;

        public CharCreator(char[] charSource) {
            this(new char[][]{charSource});
        }

        public CharCreator(char[][] charSource) {
            UIOStreamBuilder.this = UIOStreamBuilder.this;
            this.charSource = charSource;
        }

        RandomAccessInput create() throws IOException {
            CharArrayContent content = new CharArrayContent(this.charSource);
            IOController controller = new IOController(DEFAULT_CHUNK_SIZE, content);
            return new BufferedRandomAccessIO(controller, UIOStreamBuilder.this.start != null ? UIOStreamBuilder.this.start : 0L);
        }

        RandomAccessInput createBuffered() throws IOException {
            return this.create();
        }
    }

    class IntCreator
    extends Creator {
        int[][] intSource;

        public IntCreator(int[] intSource) {
            this(new int[][]{intSource});
        }

        public IntCreator(int[][] intSource) {
            UIOStreamBuilder.this = UIOStreamBuilder.this;
            this.intSource = intSource;
        }

        RandomAccessInput create() throws IOException {
            IntArrayContent content = new IntArrayContent(this.intSource);
            IOController controller = new IOController(DEFAULT_CHUNK_SIZE, content);
            return new BufferedRandomAccessIO(controller, UIOStreamBuilder.this.start != null ? UIOStreamBuilder.this.start : 0L);
        }

        RandomAccessInput createBuffered() throws IOException {
            return this.create();
        }
    }

    class SpannedCreator
    extends Creator {
        Span[] spans;
        RandomAccessInput raiSource;

        public SpannedCreator(RandomAccessInput raiSource, Span[] spans) {
            UIOStreamBuilder.this = UIOStreamBuilder.this;
            this.raiSource = raiSource;
            this.spans = spans;
        }

        RandomAccessInput create() throws IOException {
            Content content;
            RandomAccessInput inputChild;
            if (UIOStreamBuilder.this.mode == UIOStreamBuilder.READ_ONLY) {
                inputChild = this.raiSource.createInputChild(0L, 0L, this.getByteOrder(), false);
                content = new SpannedRandomAccessInputContent(inputChild, this.spans);
            } else if (this.raiSource instanceof RandomAccessIO) {
                inputChild = ((RandomAccessIO)this.raiSource).createIOChild(0L, 0L, this.getByteOrder(), false);
                content = new SpannedRandomAccessIOContent((RandomAccessIO)inputChild, this.spans);
            } else {
                inputChild = this.raiSource.createInputChild(0L, 0L, this.getByteOrder(), false);
                content = new SpannedRandomAccessInputContent(inputChild, this.spans);
            }
            IOController controller = new IOController(Math.min(DEFAULT_CHUNK_SIZE, Math.max(1024, this.getLength())), content);
            return new BufferedRandomAccessIO(controller, 0L);
        }

        private int getLength() {
            int length = 0;
            int i2 = 0;
            while (i2 < this.spans.length) {
                Span span = this.spans[i2];
                length = (int)((long)length + span.length);
                ++i2;
            }
            return length;
        }

        protected int getByteOrder() {
            return UIOStreamBuilder.this.byteOrder != 0 ? UIOStreamBuilder.this.byteOrder : this.raiSource.getByteOrder();
        }

        RandomAccessInput createBuffered() throws IOException {
            return this.create();
        }
    }

    class LongCreator
    extends Creator {
        long[][] longSource;

        public LongCreator(long[] longSource) {
            this(new long[][]{longSource});
        }

        public LongCreator(long[][] longSource) {
            UIOStreamBuilder.this = UIOStreamBuilder.this;
            this.longSource = longSource;
        }

        RandomAccessInput create() throws IOException {
            LongArrayContent content = new LongArrayContent(this.longSource);
            IOController controller = new IOController(DEFAULT_CHUNK_SIZE, content);
            return new BufferedRandomAccessIO(controller, UIOStreamBuilder.this.start != null ? UIOStreamBuilder.this.start : 0L);
        }

        RandomAccessInput createBuffered() throws IOException {
            return this.create();
        }
    }

    class FloatCreator
    extends Creator {
        float[][] floatSource;

        public FloatCreator(float[] floatSource) {
            this(new float[][]{floatSource});
        }

        public FloatCreator(float[][] floatSource) {
            UIOStreamBuilder.this = UIOStreamBuilder.this;
            this.floatSource = floatSource;
        }

        RandomAccessInput create() throws IOException {
            FloatArrayContent content = new FloatArrayContent(this.floatSource);
            IOController controller = new IOController(DEFAULT_CHUNK_SIZE, content);
            return new BufferedRandomAccessIO(controller, UIOStreamBuilder.this.start != null ? UIOStreamBuilder.this.start : 0L);
        }

        RandomAccessInput createBuffered() throws IOException {
            return this.create();
        }
    }

    class DoubleCreator
    extends Creator {
        double[][] doubleSource;

        public DoubleCreator(double[] doubleSource) {
            this(new double[][]{doubleSource});
        }

        public DoubleCreator(double[][] doubleSource) {
            UIOStreamBuilder.this = UIOStreamBuilder.this;
            this.doubleSource = doubleSource;
        }

        RandomAccessInput create() throws IOException {
            DoubleArrayContent content = new DoubleArrayContent(this.doubleSource);
            IOController controller = new IOController(DEFAULT_CHUNK_SIZE, content);
            return new BufferedRandomAccessIO(controller, UIOStreamBuilder.this.start != null ? UIOStreamBuilder.this.start : 0L);
        }

        RandomAccessInput createBuffered() throws IOException {
            return this.create();
        }
    }

    class URLCreator
    extends Creator {
        URL url;
        FileCreator fileCreator;

        public URLCreator(URL url) {
            UIOStreamBuilder.this = UIOStreamBuilder.this;
            this.url = url;
            String protocol = url.getProtocol();
            if ("file".equalsIgnoreCase(protocol)) {
                File f2 = new File(url.getFile());
                UIOStreamBuilder uIOStreamBuilder = UIOStreamBuilder.this;
                uIOStreamBuilder.getClass();
                this.fileCreator = uIOStreamBuilder.new FileCreator(f2);
            }
        }

        RandomAccessInput create() throws IOException {
            if (this.fileCreator == null) {
                return this.create0();
            }
            return this.fileCreator.create();
        }

        RandomAccessInput createBuffered() throws IOException {
            if (this.fileCreator == null) {
                return this.create0();
            }
            return this.fileCreator.createBuffered();
        }

        private RandomAccessInput create0() {
            if (UIOStreamBuilder.this.cache == null) {
                UIOStreamBuilder.this.cache = UIOStreamBuilder.createTempFile("urc");
            }
            IOController controller = BIOFactory.createIOController(this.url, UIOStreamBuilder.this.cache, this.getBufferSize());
            BufferedRandomAccessIO rio = new BufferedRandomAccessIO(controller);
            rio.setByteOrder(UIOStreamBuilder.this.byteOrder);
            return rio;
        }
    }

    class ISCreator
    extends Creator {
        InputStream inputStreamSource;

        public ISCreator(InputStream inputStreamSource) {
            UIOStreamBuilder.this = UIOStreamBuilder.this;
            this.inputStreamSource = inputStreamSource;
        }

        RandomAccessInput create() throws IOException {
            if (this.inputStreamSource instanceof ByteArrayInputStream) {
                return new BaisWrapper((ByteArrayInputStream)this.inputStreamSource);
            }
            if (UIOStreamBuilder.this.cache == null) {
                UIOStreamBuilder.this.cache = UIOStreamBuilder.createTempFile("isc");
            }
            IOController controller = BIOFactory.createIOController(this.inputStreamSource, UIOStreamBuilder.this.cache, this.getBufferSize());
            BufferedRandomAccessIO bio = new BufferedRandomAccessIO(controller);
            bio.setByteOrder(UIOStreamBuilder.this.byteOrder);
            return bio;
        }

        RandomAccessInput createBuffered() throws IOException {
            return this.create();
        }
    }

    class OSCreator
    extends Creator {
        OutputStream outputStreamSource;

        public OSCreator(OutputStream outputStreamSource) {
            UIOStreamBuilder.this = UIOStreamBuilder.this;
            this.outputStreamSource = outputStreamSource;
            UIOStreamBuilder.this.setMode(UIOStreamBuilder.READ_WRITE);
        }

        RandomAccessInput create() throws IOException {
            BufferedRandomAccessIO bio = BIOFactory.create(this.outputStreamSource);
            bio.setByteOrder(UIOStreamBuilder.this.byteOrder);
            return bio;
        }

        RandomAccessInput createBuffered() throws IOException {
            return this.create();
        }
    }
}

