/*
 * Decompiled with CFR 0.152.
 */
package com.imagero.uio;

import com.imagero.uio.RandomAccessInput;
import com.imagero.uio.io.BitInputStream;
import com.imagero.uio.io.BitOutputStream;
import com.imagero.uio.io.ByteArrayOutputStreamExt;
import com.imagero.uio.xform.ByteToXBE;
import com.imagero.uio.xform.ByteToXLE;
import com.imagero.uio.xform.XTransformer;
import com.imagero.uio.xform.XtoByteBE;
import com.imagero.uio.xform.XtoByteLE;
import java.io.ByteArrayInputStream;
import java.io.IOException;

public class Transformer
extends XTransformer {
    public static final int byteToInt(byte[] source, int sourceOffset, int[] dest, int destOffset, boolean bigEndian) {
        if (bigEndian) {
            return ByteToXBE.byteToInt(source, sourceOffset, dest, destOffset);
        }
        return ByteToXLE.byteToInt(source, sourceOffset, dest, destOffset);
    }

    public static final void byteToInt(byte[] source, int sourceOffset, int count, int[] dest, int destOffset, boolean bigEndian) {
        if (bigEndian) {
            ByteToXBE.byteToInt(source, sourceOffset, count, dest, destOffset);
        } else {
            ByteToXLE.byteToInt(source, sourceOffset, count, dest, destOffset);
        }
    }

    public static final int intToByte(int[] source, int sourceOffset, byte[] dest, int destOffset, boolean bigEndian) {
        if (bigEndian) {
            return XtoByteBE.intToByte(source, sourceOffset, dest, destOffset);
        }
        return XtoByteLE.intToByte(source, sourceOffset, dest, destOffset);
    }

    public static final void intToByte(int[] source, int srcOffset, int count, byte[] dest, int destOffset, boolean bigEndian) {
        if (bigEndian) {
            XtoByteBE.intToByte(source, srcOffset, count, dest, destOffset);
        } else {
            XtoByteLE.intToByte(source, srcOffset, count, dest, destOffset);
        }
    }

    public static int intToByte(int v2, byte[] dest, int destOffset, boolean bigEndian) {
        if (bigEndian) {
            return XtoByteBE.intToByte(v2, dest, destOffset);
        }
        return XtoByteLE.intToByte(v2, dest, destOffset);
    }

    public static final int byteToInt(byte[] source, int sourceOffset, boolean bigEndian) {
        if (bigEndian) {
            return ByteToXBE.byteToInt(source, sourceOffset);
        }
        return ByteToXLE.byteToInt(source, sourceOffset);
    }

    public static int byteToChar(byte[] source, int sourceOffset, char[] dest, int destOffset, boolean bigEndian) {
        if (bigEndian) {
            return ByteToXBE.byteToChar(source, sourceOffset, dest, destOffset);
        }
        return ByteToXLE.byteToChar(source, sourceOffset, dest, destOffset);
    }

    public static void byteToChar(byte[] source, int sourceOffset, int count, char[] dest, int destOffset, boolean bigEndian) {
        if (bigEndian) {
            ByteToXBE.byteToChar(source, sourceOffset, count, dest, destOffset);
        } else {
            ByteToXLE.byteToChar(source, sourceOffset, count, dest, destOffset);
        }
    }

    public static int byteToChar(byte[] source, int sourceOffset, boolean bigEndian) {
        if (bigEndian) {
            return ByteToXBE.byteToChar(source, sourceOffset);
        }
        return ByteToXLE.byteToChar(source, sourceOffset);
    }

    public static int charToByte(char[] source, int srcOffset, byte[] dest, int destOffset, boolean bigEndian) {
        if (bigEndian) {
            return XtoByteBE.charToByte(source, srcOffset, dest, destOffset);
        }
        return XtoByteLE.charToByte(source, srcOffset, dest, destOffset);
    }

    public static int charToByte(char v2, byte[] dest, int destOffset, boolean bigEndian) {
        if (bigEndian) {
            return XtoByteBE.charToByte(v2, dest, destOffset);
        }
        return XtoByteLE.charToByte(v2, dest, destOffset);
    }

    public static void charToByte(char[] source, int srcOffset, int count, byte[] dest, int destOffset, boolean bigEndian) {
        if (bigEndian) {
            XtoByteBE.charToByte(source, srcOffset, count, dest, destOffset);
        } else {
            XtoByteLE.charToByte(source, srcOffset, count, dest, destOffset);
        }
    }

    public static int byteToDouble(byte[] source, int sourceOffset, double[] dest, int destOffset, boolean bigEndian) {
        if (bigEndian) {
            return ByteToXBE.byteToDoubleBE(source, sourceOffset, dest, destOffset);
        }
        return ByteToXLE.byteToDoubleLE(source, sourceOffset, dest, destOffset);
    }

    public static void byteToDouble(byte[] source, int sourceOffset, int count, double[] dest, int destOffset, boolean bigEndian) {
        if (bigEndian) {
            ByteToXBE.byteToDoubleBE(source, sourceOffset, count, dest, destOffset);
        } else {
            ByteToXLE.byteToDoubleLE(source, sourceOffset, count, dest, destOffset);
        }
    }

    public static double byteToDouble(byte[] source, int sourceOffset, boolean bigEndian) {
        if (bigEndian) {
            return ByteToXBE.byteToDoubleBE(source, sourceOffset);
        }
        return ByteToXLE.byteToDoubleLE(source, sourceOffset);
    }

    public static int doubleToByte(double[] source, int srcOffset, byte[] dest, int destOffset, boolean bigEndian) {
        if (bigEndian) {
            return XtoByteBE.doubleToByteBE(source, srcOffset, dest, destOffset);
        }
        return XtoByteLE.doubleToByteLE(source, srcOffset, dest, destOffset);
    }

    public static void doubleToByte(double[] source, int srcOffset, int count, byte[] dest, int destOffset, boolean bigEndian) {
        if (bigEndian) {
            XtoByteBE.doubleToByteBE(source, srcOffset, count, dest, destOffset);
        } else {
            XtoByteLE.doubleToByteLE(source, srcOffset, count, dest, destOffset);
        }
    }

    public static int doubleToByte(double d2, byte[] dest, int destOffset, boolean bigEndian) {
        if (bigEndian) {
            return XtoByteBE.doubleToByteBE(d2, dest, destOffset);
        }
        return XtoByteLE.doubleToByteLE(d2, dest, destOffset);
    }

    public static int byteToFloat(byte[] source, int sourceOffset, float[] dest, int destOffset, boolean bigEndian) {
        if (bigEndian) {
            return ByteToXBE.byteToFloatBE(source, sourceOffset, dest, destOffset);
        }
        return ByteToXLE.byteToFloatLE(source, sourceOffset, dest, destOffset);
    }

    public static void byteToFloat(byte[] source, int sourceOffset, int count, float[] dest, int destOffset, boolean bigEndian) {
        if (bigEndian) {
            ByteToXBE.byteToFloatBE(source, sourceOffset, count, dest, destOffset);
        } else {
            ByteToXLE.byteToFloatLE(source, sourceOffset, count, dest, destOffset);
        }
    }

    public static float byteToFloat(byte[] source, int sourceOffset, boolean bigEndian) {
        if (bigEndian) {
            return ByteToXBE.byteToFloatBE(source, sourceOffset);
        }
        return ByteToXLE.byteToFloatLE(source, sourceOffset);
    }

    public static int floatToByte(float[] source, int offset, byte[] dest, int destOffset, boolean bigEndian) {
        if (bigEndian) {
            return XtoByteBE.floatToByteBE(source, offset, dest, destOffset);
        }
        return XtoByteLE.floatToByteLE(source, offset, dest, destOffset);
    }

    public static void floatToByte(float[] source, int offset, int count, byte[] dest, int destOffset, boolean bigEndian) {
        if (bigEndian) {
            XtoByteBE.floatToByteBE(source, offset, count, dest, destOffset);
        } else {
            XtoByteLE.floatToByteLE(source, offset, count, dest, destOffset);
        }
    }

    public static int floatToByte(float f2, byte[] dest, int destOffset, boolean bigEndian) {
        if (bigEndian) {
            return XtoByteBE.floatToByteBE(f2, dest, destOffset);
        }
        return XtoByteLE.floatToByteLE(f2, dest, destOffset);
    }

    public static int byteToLong(byte[] source, int sourceOffset, long[] dest, int destOffset, boolean bigEndian) {
        if (bigEndian) {
            return ByteToXBE.byteToLongBE(source, sourceOffset, dest, destOffset);
        }
        return ByteToXLE.byteToLongLE(source, sourceOffset, dest, destOffset);
    }

    public static void byteToLong(byte[] source, int sourceOffset, int count, long[] dest, int destOffset, boolean bigEndian) {
        if (bigEndian) {
            ByteToXBE.byteToLongBE(source, sourceOffset, count, dest, destOffset);
        } else {
            ByteToXLE.byteToLongLE(source, sourceOffset, count, dest, destOffset);
        }
    }

    public static long byteToLong(byte[] source, int sourceOffset, boolean bigEndian) {
        if (bigEndian) {
            return ByteToXBE.byteToLongBE(source, sourceOffset);
        }
        return ByteToXLE.byteToLongLE(source, sourceOffset);
    }

    public static int longToByte(long[] source, int offset, byte[] dest, int destOffset, boolean bigEndian) {
        if (bigEndian) {
            return XtoByteBE.longToByteBE(source, offset, dest, destOffset);
        }
        return XtoByteLE.longToByteLE(source, offset, dest, destOffset);
    }

    public static void longToByte(long[] source, int offset, int count, byte[] dest, int destOffset, boolean bigEndian) {
        if (bigEndian) {
            XtoByteBE.longToByteBE(source, offset, count, dest, destOffset);
        } else {
            XtoByteLE.longToByteLE(source, offset, count, dest, destOffset);
        }
    }

    public static int longToByte(long v2, byte[] dest, int destOffset, boolean bigEndian) {
        if (bigEndian) {
            return XtoByteBE.longToByteBE(v2, dest, destOffset);
        }
        return XtoByteLE.longToByteLE(v2, dest, destOffset);
    }

    public static int byteToShort(byte[] source, int sourceOffset, short[] dest, int destOffset, boolean bigEndian) {
        if (bigEndian) {
            return ByteToXBE.byteToShortBE(source, sourceOffset, dest, destOffset);
        }
        return ByteToXLE.byteToShortLE(source, sourceOffset, dest, destOffset);
    }

    public static void byteToShort(byte[] source, int sourceOffset, int count, short[] dest, int destOffset, boolean bigEndian) {
        if (bigEndian) {
            ByteToXBE.byteToShortBE(source, sourceOffset, count, dest, destOffset);
        } else {
            ByteToXLE.byteToShortLE(source, sourceOffset, count, dest, destOffset);
        }
    }

    public static int byteToShort(byte[] source, int sourceOffset, boolean bigEndian) {
        if (bigEndian) {
            return ByteToXBE.byteToShortBE(source, sourceOffset);
        }
        return ByteToXLE.byteToShortLE(source, sourceOffset);
    }

    public static int shortToByte(short[] source, int offset, byte[] dest, int destOffset, boolean bigEndian) {
        if (bigEndian) {
            return XtoByteBE.shortToByteBE(source, offset, dest, destOffset);
        }
        return XtoByteBE.shortToByteBE(source, offset, dest, destOffset);
    }

    public static void shortToByte(short[] source, int offset, int count, byte[] dest, int destOffset, boolean bigEndian) {
        if (bigEndian) {
            XtoByteBE.shortToByteBE(source, offset, count, dest, destOffset);
        } else {
            XtoByteLE.shortToByteLE(source, offset, count, dest, destOffset);
        }
    }

    public static int shortToByte(short v2, byte[] dest, int destOffset, boolean bigEndian) {
        if (bigEndian) {
            return XtoByteBE.shortToByteBE(v2, dest, destOffset);
        }
        return XtoByteLE.shortToByteLE(v2, dest, destOffset);
    }

    public static final byte[] readByteLine(RandomAccessInput in) throws IOException {
        long start;
        long end = start = in.getFilePointer();
        boolean finished = false;
        boolean eof = false;
        int length = 0;
        block5: while (!finished) {
            int k2 = in.read();
            switch (k2) {
                case -1: {
                    eof = true;
                    finished = true;
                    break;
                }
                case 10: {
                    finished = true;
                    end = in.getFilePointer();
                    length = (int)(end - start);
                    break;
                }
                case 13: {
                    finished = true;
                    end = in.getFilePointer();
                    length = (int)(end - start);
                    if (in.read() != 10) continue block5;
                    end = in.getFilePointer();
                    break;
                }
                default: {
                    k2 = 0;
                    break;
                }
            }
        }
        if (eof && length == 0) {
            return null;
        }
        byte[] b2 = new byte[length];
        in.seek(start);
        in.readFully(b2);
        in.seek(end);
        return b2;
    }

    public static final int readByteLine(RandomAccessInput in, byte[] dest) throws IOException {
        long start;
        long end = start = in.getFilePointer();
        boolean finished = false;
        boolean eof = false;
        int length = 0;
        int cnt = 0;
        while (!finished) {
            if (cnt++ >= dest.length) {
                finished = true;
                break;
            }
            switch (in.read()) {
                case -1: {
                    eof = true;
                    finished = true;
                    break;
                }
                case 10: {
                    finished = true;
                    end = in.getFilePointer();
                    length = (int)(end - start);
                    break;
                }
                case 13: {
                    finished = true;
                    end = in.getFilePointer();
                    length = (int)(end - start);
                    if (in.read() != 10) break;
                    end = in.getFilePointer();
                    break;
                }
            }
        }
        if (eof && length == 0) {
            return 0;
        }
        if (length == 0) {
            end = in.getFilePointer();
            length = Math.min(dest.length, (int)(end - start));
        }
        in.seek(start);
        in.readFully(dest, 0, length);
        in.seek(end);
        return length;
    }

    public static void shiftRight(byte[] src, int first, int shift) throws IOException {
        ByteArrayOutputStreamExt out = new ByteArrayOutputStreamExt(src.length + 1);
        BitOutputStream bos = new BitOutputStream(out);
        bos.write(first, shift);
        int i2 = 0;
        while (i2 < src.length) {
            bos.write(src[i2] & 0xFF);
            ++i2;
        }
        bos.close();
        byte[] dst = out.drain();
        System.arraycopy(dst, 0, src, 0, src.length);
    }

    public static void shiftLeft(byte[] src, int shift) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(src);
        BitInputStream bis = new BitInputStream(in);
        bis.read(shift);
        bis.setBitsToRead(8);
        int a2 = bis.read();
        int p2 = 0;
        while (a2 != -1 && p2 < src.length) {
            int b2 = bis.read();
            src[p2++] = (byte)a2;
            if (b2 == -1) break;
            a2 = b2;
        }
    }
}

