/*
 * Decompiled with CFR 0.152.
 */
package com.imagero.uio;

import com.imagero.uio.ByteArray;

public class ByteArrayIO {
    public static int read(ByteArray ba) {
        return ByteArrayIO.read(ba, 8);
    }

    public static int read(ByteArray ba, int nbits) {
        int bitOffset;
        int ret = 0;
        if (nbits == 0) {
            return 0;
        }
        if (nbits > 8) {
            throw new IllegalArgumentException("no more then 8 bits can be read at once");
        }
        if (ba.bitOffset == 0 && nbits == 8) {
            return ba.buffer[ba.position++];
        }
        ret = ba.buffer[ba.position] & ByteArray.N_MASK[ba.bitOffset];
        int rshift = 8 - ba.bitOffset - nbits;
        if (rshift > 0) {
            ret >>= rshift;
        }
        if ((bitOffset = ba.bitOffset + nbits) > 7) {
            ba.bitOffset = bitOffset -= 8;
            ++ba.position;
            if (bitOffset > 0) {
                ret = ret << bitOffset | ba.buffer[ba.position] & ByteArray.N_MASK[ba.bitOffset];
            }
        }
        return ret;
    }

    public static int read(ByteArray ba, byte[] b2) {
        return ByteArrayIO.read(ba, b2, 0, b2.length);
    }

    public static int read(ByteArray ba, byte[] b2, int off, int len) {
        if (len <= 0) {
            return 0;
        }
        int c2 = ByteArrayIO.read(ba);
        if (c2 == -1) {
            return -1;
        }
        b2[off] = (byte)c2;
        int i2 = 1;
        while (i2 < len) {
            c2 = ByteArrayIO.read(ba);
            if (c2 == -1) break;
            b2[off + i2] = (byte)c2;
            ++i2;
        }
        return i2;
    }

    public static long skipBytes(ByteArray ba, long n2) {
        int max = (int)Math.min((long)(ba.buffer.length - ba.position), n2);
        ba.position += max;
        return max;
    }

    public static int skipBits(ByteArray ba, int n2) {
        int k2 = n2;
        int nbits = k2 % 8;
        int nbytes = k2 / 8;
        int bitOffset = ba.bitOffset + nbits;
        if (bitOffset > 7) {
            ++nbytes;
            ba.bitOffset = bitOffset - 8;
        }
        ba.position += nbytes;
        return n2;
    }

    public static void seek(ByteArray ba, int pos) {
        ba.position = pos;
    }

    public static void seek(ByteArray ba, int pos, int bitPos) {
        ba.position = pos + bitPos / 8;
        ba.bitOffset = bitPos % 8;
    }

    public static int skipToByteBoundary(ByteArray ba) {
        if (ba.bitOffset > 0) {
            int ret = 8 - ba.bitOffset;
            ba.bitOffset = 0;
            ++ba.position;
            return ret;
        }
        return 0;
    }

    public static void write(ByteArray ba, int b2) {
        ByteArrayIO.write(ba, b2, 8);
    }

    public static void write(ByteArray ba, int N, int N_BITS) {
        if (N_BITS == 0) {
            return;
        }
        if (N_BITS > 8) {
            throw new IllegalArgumentException("no more then 8 bits can be written at once");
        }
        if (ba.bitOffset == 0 && N_BITS == 8) {
            ba.buffer[ba.position++] = (byte)(N & 0xFF);
        } else {
            ByteArrayIO.write0(ba, N, N_BITS);
        }
    }

    protected static final void write0(ByteArray ba, int N, int N_BITS) {
        int a2;
        int available = 8 - ba.bitOffset;
        int b2 = a2 = ba.buffer[ba.position] & 0xFF;
        a2 = a2 >> available << N_BITS | N & ByteArray.K_MASK[N_BITS];
        if (N_BITS > available) {
            ba.buffer[ba.position++] = (byte)(a2 >>= N_BITS - available);
            ba.bitOffset = 0;
            ByteArrayIO.write0(ba, N & ByteArray.K_MASK[N_BITS -= available], N_BITS);
        } else if (available > N_BITS) {
            a2 <<= available - N_BITS;
            ba.buffer[ba.position] = (byte)(a2 |= b2 & ByteArray.K_MASK[available - N_BITS]);
            ba.bitOffset += N_BITS;
        } else {
            ba.buffer[ba.position++] = (byte)a2;
            ba.bitOffset = 0;
        }
        if (ba.bitOffset >= 8) {
            ++ba.position;
            ba.bitOffset -= 8;
        }
    }
}

