/*
 * Decompiled with CFR 0.152.
 */
package com.imagero.uio;

import com.imagero.uio.RandomAccessInput;
import com.imagero.uio.impl.AbstractRandomAccessInput;
import com.imagero.uio.io.IOutils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class BaisWrapper
extends AbstractRandomAccessInput {
    long pos;
    long mark;
    long count;
    long offset;
    ByteArrayInputStream in;

    public BaisWrapper(ByteArrayInputStream in) {
        this.in = in;
        in.mark(0);
        this.count = in.available();
    }

    public BaisWrapper(BaisWrapper in, long offset, int byteOrder) {
        this.in = in.in;
        this.offset = offset;
        this.count = in.count - (in.offset + (long)((int)offset));
        this.setByteOrder(byteOrder);
    }

    public BaisWrapper(BaisWrapper in, long offset, long length, int byteOrder) {
        this.in = in.in;
        this.offset = offset;
        this.count = in.count - (in.offset + (long)((int)offset));
        if (length > 0L) {
            this.count = Math.min(this.count, length);
        }
        this.setByteOrder(byteOrder);
    }

    public synchronized int read() {
        this.seek0(this.pos);
        int k2 = this.in.read();
        ++this.pos;
        return k2;
    }

    public synchronized int read(byte[] b2, int off, int len) {
        this.seek0(this.pos);
        int read = this.in.read(b2, off, len);
        this.pos += (long)read;
        return read;
    }

    public synchronized long skip(long n2) {
        this.seek0(this.pos);
        long length = this.in.skip(n2);
        this.pos += length;
        return length;
    }

    public synchronized void seek(long position) {
        this.seek0(position);
    }

    private void seek0(long position) {
        this.in.reset();
        this.pos = 0L;
        if (position + this.offset > 0L) {
            this.skip(position + this.offset);
        }
    }

    public boolean markSupported() {
        return true;
    }

    public synchronized void mark(int readlimit) {
        this.mark = this.pos;
    }

    public synchronized void reset() {
        this.seek0(this.mark);
    }

    public long getFilePointer() {
        return this.pos;
    }

    public long length() {
        return this.count - this.offset;
    }

    public RandomAccessInput createInputChild(long offset, long length, int byteOrder, boolean syncPointer) {
        return new BaisWrapper(this, offset, length, byteOrder);
    }

    public void close() {
        IOutils.closeStream(this.in);
    }

    public InputStream createInputStream(long offset) {
        return new BaisWrapper(this, offset, this.byteOrder);
    }

    public long getChildPosition(InputStream child) {
        if (child instanceof BaisWrapper) {
            BaisWrapper wrapper = (BaisWrapper)child;
            return wrapper.getFilePointer();
        }
        return -1L;
    }

    public void setChildPosition(InputStream child, long position) {
        if (child instanceof BaisWrapper) {
            BaisWrapper wrapper = (BaisWrapper)child;
            wrapper.seek(position);
        }
    }
}

