/*
 * Decompiled with CFR 0.152.
 */
package com.imagero.reader.tiff;

import com.imagero.reader.Imagero;
import com.imagero.reader.MetadataUtils;
import com.imagero.reader.jpeg.enc.DCTImage;
import com.imagero.reader.jpeg.enc.JpegWriter;
import com.imagero.reader.tiff.IFDEntry;
import com.imagero.reader.tiff.IFDEntryMeta;
import com.imagero.reader.tiff.IFDEntryTagNumbers;
import com.imagero.reader.tiff.Rational;
import com.imagero.reader.tiff.SRational;
import com.imagero.reader.tiff.TiffConstants;
import com.imagero.reader.tiff.type.Altitude;
import com.imagero.reader.tiff.type.CFAValue;
import com.imagero.reader.tiff.type.CharacterCode;
import com.imagero.reader.tiff.type.ColorSpace;
import com.imagero.reader.tiff.type.Component;
import com.imagero.reader.tiff.type.Compression;
import com.imagero.reader.tiff.type.Contrast;
import com.imagero.reader.tiff.type.CustomRendered;
import com.imagero.reader.tiff.type.Direction;
import com.imagero.reader.tiff.type.DistanceUnit;
import com.imagero.reader.tiff.type.ExposureMode;
import com.imagero.reader.tiff.type.ExposureProgram;
import com.imagero.reader.tiff.type.FileSource;
import com.imagero.reader.tiff.type.FlashFiringStatus;
import com.imagero.reader.tiff.type.FlashReturnStatus;
import com.imagero.reader.tiff.type.GPSVersionID;
import com.imagero.reader.tiff.type.GainControl;
import com.imagero.reader.tiff.type.Latitude;
import com.imagero.reader.tiff.type.LightSource;
import com.imagero.reader.tiff.type.Longitude;
import com.imagero.reader.tiff.type.MeasureMode;
import com.imagero.reader.tiff.type.MeteringMode;
import com.imagero.reader.tiff.type.Orientation;
import com.imagero.reader.tiff.type.PhotometricInterpretation;
import com.imagero.reader.tiff.type.PlanarConfiguration;
import com.imagero.reader.tiff.type.ResolutionUnit;
import com.imagero.reader.tiff.type.Saturation;
import com.imagero.reader.tiff.type.SceneCaptureType;
import com.imagero.reader.tiff.type.SceneType;
import com.imagero.reader.tiff.type.SensingMethod;
import com.imagero.reader.tiff.type.Sharpness;
import com.imagero.reader.tiff.type.SubjectDistanceRange;
import com.imagero.reader.tiff.type.WhiteBalance;
import com.imagero.reader.tiff.type.YCbCrPositioning;
import com.imagero.reader.tiff.type.YccSubsampling;
import com.imagero.uio.blob.Blob;
import com.imagero.uio.io.ByteArrayOutputStreamExt;
import java.awt.Image;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class IFDEntryFactory
implements IFDEntryTagNumbers,
TiffConstants {
    static int a;
    private static String[] z;

    public static int getByteOrder() {
        return a;
    }

    public static void setByteOrder(int n2) {
        switch (n2) {
            case 18761: 
            case 19789: {
                a = n2;
                if (!IFDEntryMeta.s) break;
            }
            default: {
                throw new IllegalArgumentException(z[0] + n2);
            }
        }
    }

    public static IFDEntry createWidth(int n2) throws IOException {
        return new IFDEntry(256, 3, 1, a, new short[]{(short)n2});
    }

    public static IFDEntry createHeight(int n2) throws IOException {
        return new IFDEntry(257, 3, 1, a, new short[]{(short)n2});
    }

    public static IFDEntry createBitsPerSample(short[] sArray) throws IOException {
        return new IFDEntry(258, 3, sArray.length, a, sArray);
    }

    public static IFDEntry createSamplesPerPixel(short s2) throws IOException {
        return new IFDEntry(277, 3, 1, a, new short[]{s2});
    }

    public static IFDEntry createNewSubfileType(boolean bl, boolean bl2, boolean bl3) throws IOException {
        int n2 = 0;
        n2 = n2 << 1 | (bl ? 1 : 0);
        n2 = n2 << 1 | (bl2 ? 1 : 0);
        n2 = n2 << 1 | (bl3 ? 1 : 0);
        return new IFDEntry(254, 4, 1, a, n2);
    }

    public static IFDEntry createPageNumber(int n2, int n3) throws IOException {
        return new IFDEntry(297, 3, 2, a, new short[]{(short)n2, (short)n3});
    }

    public static IFDEntry createPageName(String string) throws IOException {
        byte[] byArray = string.getBytes(z[1]);
        return new IFDEntry(285, 2, byArray.length + 1, a, byArray);
    }

    public static IFDEntry createDocumentName(String string) throws IOException {
        byte[] byArray = string.getBytes(z[1]);
        return new IFDEntry(269, 2, byArray.length + 1, a, byArray);
    }

    public static IFDEntry createCompression(Compression compression) throws IOException {
        return new IFDEntry(259, 3, 1, a, new short[]{(short)compression.value});
    }

    public static IFDEntry createPhotometricInterpretation(PhotometricInterpretation photometricInterpretation) throws IOException {
        return new IFDEntry(262, 3, 1, a, new short[]{(short)photometricInterpretation.value});
    }

    public static IFDEntry createOrientation(Orientation orientation) throws IOException {
        return new IFDEntry(274, 3, 1, a, new short[]{orientation.value});
    }

    public static IFDEntry createPlanarConfiguration(PlanarConfiguration planarConfiguration) throws IOException {
        return new IFDEntry(284, 3, 1, a, new short[]{planarConfiguration.value});
    }

    public static IFDEntry createYCbCrSubSampling(YccSubsampling yccSubsampling) throws IOException {
        return new IFDEntry(530, 3, 2, a, new short[]{2, yccSubsampling.value});
    }

    public static IFDEntry createYCbCrPositioning(YCbCrPositioning yCbCrPositioning) throws IOException {
        return new IFDEntry(531, 3, 1, a, new short[]{yCbCrPositioning.value});
    }

    public static IFDEntry createXPosition(Rational rational) throws IOException {
        return new IFDEntry(286, 5, 1, a, new int[]{rational.a, rational.b});
    }

    public static IFDEntry createYPosition(Rational rational) throws IOException {
        return new IFDEntry(287, 5, 1, a, new int[]{rational.a, rational.b});
    }

    public static IFDEntry createXResolution(Rational rational) throws IOException {
        return new IFDEntry(282, 5, 1, a, new int[]{rational.a, rational.b});
    }

    public static IFDEntry createYResolution(Rational rational) throws IOException {
        return new IFDEntry(283, 5, 1, a, new int[]{rational.a, rational.b});
    }

    public static IFDEntry createXMP(String string) throws IOException {
        byte[] byArray = MetadataUtils.encodeXMP(string);
        return new IFDEntry(700, 1, byArray.length, a, byArray);
    }

    public static IFDEntry createResolutionUnit(ResolutionUnit resolutionUnit) throws IOException {
        return new IFDEntry(296, 3, 1, a, new short[]{resolutionUnit.value});
    }

    public static IFDEntry createStripOffsets(short[] sArray) throws IOException {
        return new IFDEntry(273, 3, sArray.length, a, sArray);
    }

    public static IFDEntry createStripOffsets(int[] nArray) throws IOException {
        return new IFDEntry(273, 4, nArray.length, a, nArray);
    }

    public static IFDEntry createRowsPerStrip(short s2) throws IOException {
        return new IFDEntry(278, 3, 1, a, new short[]{s2});
    }

    public static IFDEntry createRowsPerStrip(int n2) throws IOException {
        return new IFDEntry(278, 4, 1, a, new int[]{n2});
    }

    public static IFDEntry createStripByteCounts(short[] sArray) throws IOException {
        return new IFDEntry(279, 3, sArray.length, a, sArray);
    }

    public static IFDEntry createStripByteCounts(int[] nArray) throws IOException {
        return new IFDEntry(279, 4, nArray.length, a, nArray);
    }

    public static IFDEntry[] createJPEGInterchangeFormat(Image image) throws IOException {
        ByteArrayOutputStreamExt byteArrayOutputStreamExt = new ByteArrayOutputStreamExt();
        Imagero.saveAsJpeg(image, 10, byteArrayOutputStreamExt);
        byte[] byArray = byteArrayOutputStreamExt.drain();
        Blob.BaBlob baBlob = new Blob.BaBlob(byArray);
        return IFDEntryFactory.createJPEGInterchangeFormat(baBlob);
    }

    public static IFDEntry[] createJPEGInterchangeFormat(int[] nArray, int n2, int n3) throws IOException {
        DCTImage dCTImage = DCTImage.createImage(nArray, n2, n3, 0, n2, 5);
        ByteArrayOutputStreamExt byteArrayOutputStreamExt = new ByteArrayOutputStreamExt();
        JpegWriter.saveImage(byteArrayOutputStreamExt, dCTImage, n2, n3);
        byte[] byArray = byteArrayOutputStreamExt.drain();
        Blob.BaBlob baBlob = new Blob.BaBlob(byArray);
        return IFDEntryFactory.createJPEGInterchangeFormat(baBlob);
    }

    public static IFDEntry[] createJPEGInterchangeFormat(Blob blob) throws IOException {
        IFDEntry iFDEntry = new IFDEntry(513, 4, 1, a, new int[1]);
        iFDEntry.a(blob);
        IFDEntry iFDEntry2 = new IFDEntry(514, 4, 1, a, new int[1]);
        return new IFDEntry[]{iFDEntry, iFDEntry2};
    }

    public static IFDEntry createJPEGTables(byte[] byArray) throws IOException {
        IFDEntry iFDEntry = new IFDEntry(347, 7, byArray.length, a, byArray);
        return iFDEntry;
    }

    /*
     * Unable to fully structure code
     */
    public static IFDEntry[] createStrips(Blob[] var0, int var1_1) throws IOException {
        var8_2 = IFDEntryMeta.s;
        var2_3 = new IFDEntry(273, 4, var0.length, IFDEntryFactory.a, new int[var0.length]);
        var3_4 = new int[var0.length];
        var4_5 = new IFDEntry(279, 4, var0.length, IFDEntryFactory.a, var3_4);
        var5_6 = new IFDEntry(278, 4, 1, IFDEntryFactory.a, new int[]{var1_1});
        var6_7 = new IFDEntry(284, 3, 1, IFDEntryFactory.a, new short[]{PlanarConfiguration.PC_FORMAT_CHUNKY.value});
        var7_8 = 0;
        if (!var8_2) ** GOTO lbl13
        block0: while (true) {
            var2_3.a(var0[var7_8]);
            do {
                ++var7_8;
lbl13:
                // 2 sources

                if (var7_8 < var0.length) continue block0;
            } while (var8_2);
            break;
        }
        return new IFDEntry[]{var5_6, var6_7, var2_3, var4_5};
    }

    /*
     * Unable to fully structure code
     */
    public static IFDEntry[] createTiles(Blob[] var0, int var1_1, int var2_2) throws IOException {
        var9_3 = IFDEntryMeta.s;
        var3_4 = new IFDEntry(324, 4, var0.length, IFDEntryFactory.a, new int[var0.length]);
        var4_5 = new IFDEntry(325, 4, var0.length, IFDEntryFactory.a, new int[var0.length]);
        var5_6 = new IFDEntry(323, 4, 1, IFDEntryFactory.a, new int[]{var2_2});
        var6_7 = new IFDEntry(322, 4, 1, IFDEntryFactory.a, new int[]{var1_1});
        var7_8 = new IFDEntry(284, 3, 1, IFDEntryFactory.a, new short[]{PlanarConfiguration.PC_FORMAT_PLANAR.value});
        var8_9 = 0;
        if (!var9_3) ** GOTO lbl13
        block0: while (true) {
            var3_4.a(var0[var8_9]);
            do {
                ++var8_9;
lbl13:
                // 2 sources

                if (var8_9 < var0.length) continue block0;
            } while (var9_3);
            break;
        }
        return new IFDEntry[]{var7_8, var5_6, var6_7, var3_4, var4_5};
    }

    public static IFDEntry createTransferFunction(short[] sArray) throws IOException {
        if (sArray.length != 768) {
            throw new IllegalArgumentException();
        }
        return new IFDEntry(301, 3, sArray.length, a, sArray);
    }

    public static IFDEntry createWhitePoint(Rational[] rationalArray) throws IOException {
        if (rationalArray.length != 2) {
            throw new IllegalArgumentException();
        }
        return new IFDEntry(318, 5, 2, a, new int[]{rationalArray[0].a, rationalArray[0].b, rationalArray[1].a, rationalArray[1].b});
    }

    public static IFDEntry createPrimaryChromaticities(Rational[] rationalArray) throws IOException {
        if (rationalArray.length != 6) {
            throw new IllegalArgumentException();
        }
        return new IFDEntry(319, 5, rationalArray.length, a, Rational.a(rationalArray));
    }

    public static IFDEntry createYCbCrCoefficients(Rational[] rationalArray) throws IOException {
        if (rationalArray.length != 3) {
            throw new IllegalArgumentException();
        }
        return new IFDEntry(529, 5, rationalArray.length, a, Rational.a(rationalArray));
    }

    public static IFDEntry createReferenceBlackWhite(Rational[] rationalArray) throws IOException {
        if (rationalArray.length != 6) {
            throw new IllegalArgumentException();
        }
        return new IFDEntry(532, 5, rationalArray.length, a, Rational.a(rationalArray));
    }

    public static IFDEntry createDateTime(String string) throws IOException {
        if (string.length() != 20) {
            throw new IllegalArgumentException();
        }
        return new IFDEntry(306, 2, 20, a, string.getBytes());
    }

    public static IFDEntry createImageDescription(String string) throws IOException {
        byte[] byArray = string.getBytes();
        return new IFDEntry(270, 2, byArray.length + 1, a, byArray);
    }

    public static IFDEntry createMake(String string) throws IOException {
        byte[] byArray = string.getBytes();
        return new IFDEntry(271, 2, byArray.length + 1, a, byArray);
    }

    public static IFDEntry createModel(String string) throws IOException {
        byte[] byArray = string.getBytes();
        return new IFDEntry(272, 2, byArray.length + 1, a, byArray);
    }

    public static IFDEntry createSoftware(String string) throws IOException {
        byte[] byArray = string.getBytes();
        return new IFDEntry(305, 2, byArray.length + 1, a, byArray);
    }

    public static IFDEntry createArtist(String string) throws IOException {
        byte[] byArray = string.getBytes();
        return new IFDEntry(315, 2, byArray.length + 1, a, byArray);
    }

    public static IFDEntry createCopyright(String string, String string2) throws IOException {
        byte[] byArray;
        if (string != null) {
            byArray = string.getBytes();
        } else {
            byte[] byArray2 = new byte[2];
            byArray = byArray2;
            byArray2[0] = 32;
        }
        byte[] byArray3 = byArray;
        byte[] byArray4 = string2 != null ? string2.getBytes() : new byte[]{};
        byte[] byArray5 = new byte[byArray3.length + byArray4.length];
        System.arraycopy(byArray3, 0, byArray5, 0, byArray3.length);
        if (byArray4.length > 0) {
            System.arraycopy(byArray4, 0, byArray5, byArray3.length, byArray4.length);
        }
        return new IFDEntry(33432, 2, byArray5.length, a, byArray5);
    }

    public static IFDEntry createExifVersion(String string) throws IOException {
        if (string.length() != 4) {
            throw new IllegalArgumentException();
        }
        return new IFDEntry(36864, 7, 4, a, string.getBytes());
    }

    public static IFDEntry createFlashPixVersion(String string) throws IOException {
        if (string.length() != 4) {
            throw new IllegalArgumentException();
        }
        byte[] byArray = string.getBytes();
        return new IFDEntry(40960, 7, byArray.length, a, byArray);
    }

    public static IFDEntry createColorSpace(ColorSpace colorSpace) throws IOException {
        return new IFDEntry(40961, 3, 1, a, new short[]{colorSpace.value});
    }

    public static IFDEntry createPixelXDimension(int n2) throws IOException {
        return new IFDEntry(40962, 4, 1, a, new int[]{n2});
    }

    public static IFDEntry createPixelXDimension(short s2) throws IOException {
        return new IFDEntry(40962, 3, 1, a, new short[]{s2});
    }

    public static IFDEntry createPixelYDimension(int n2) throws IOException {
        return new IFDEntry(40963, 4, 1, a, new int[]{n2});
    }

    public static IFDEntry createPixelYDimension(short s2) throws IOException {
        return new IFDEntry(40963, 3, 1, a, new short[]{s2});
    }

    /*
     * Unable to fully structure code
     */
    public static IFDEntry createComponentsConfiguration(Component[] var0) throws IOException {
        var3_1 = IFDEntryMeta.s;
        if (var0 == null || var0.length != 4) {
            throw new IllegalArgumentException();
        }
        var1_2 = new byte[4];
        var2_3 = 0;
        if (!var3_1) ** GOTO lbl11
        block0: while (true) {
            var1_2[var2_3] = var0[var2_3].value;
            do {
                ++var2_3;
lbl11:
                // 2 sources

                if (var2_3 < var1_2.length) continue block0;
            } while (var3_1);
            break;
        }
        return new IFDEntry(37121, 7, 4, IFDEntryFactory.a, var1_2);
    }

    public static IFDEntry createCompressedBitsPerPixel(Rational rational) throws IOException {
        return new IFDEntry(37122, 5, 1, a, Rational.a(rational));
    }

    public static IFDEntry createMakerNote(byte[] byArray) throws IOException {
        return new IFDEntry(37500, 7, byArray.length, a, byArray);
    }

    public static IFDEntry createUserComment(CharacterCode characterCode, byte[] byArray) throws IOException {
        byte[] byArray2 = new byte[byArray.length + 8];
        System.arraycopy(characterCode.getCode(), 0, byArray2, 0, 8);
        System.arraycopy(byArray, 0, byArray2, 8, byArray.length);
        return new IFDEntry(IFDEntryMeta.USER_COMMENT.e, 7, byArray2.length, a, byArray2);
    }

    public static IFDEntry createRelatedSoundFile(String string) throws IOException {
        if (string.length() != 13) {
            throw new IllegalArgumentException();
        }
        return new IFDEntry(40964, 2, 13, a, string.getBytes());
    }

    public static IFDEntry createDateTimeOriginal(String string) throws IOException {
        if (string.length() != 20) {
            throw new IllegalArgumentException();
        }
        return new IFDEntry(36867, 2, 20, a, string.getBytes());
    }

    public static IFDEntry createDateTimeDigitized(String string) throws IOException {
        if (string.length() != 20) {
            throw new IllegalArgumentException();
        }
        return new IFDEntry(36868, 2, 20, a, string.getBytes());
    }

    public static IFDEntry createSubsecTime(String string) throws IOException {
        byte[] byArray = string.getBytes();
        return new IFDEntry(37520, 2, byArray.length, a, byArray);
    }

    public static IFDEntry createSubsecTimeOriginal(String string) throws IOException {
        byte[] byArray = string.getBytes();
        return new IFDEntry(37521, 2, byArray.length, a, byArray);
    }

    public static IFDEntry createSubsecTimeDigitized(String string) throws IOException {
        byte[] byArray = string.getBytes();
        return new IFDEntry(37522, 2, byArray.length, a, byArray);
    }

    public static IFDEntry createExposureTime(Rational rational) throws IOException {
        return new IFDEntry(33434, 5, 1, a, Rational.a(rational));
    }

    public static IFDEntry createShutterSpeedValue(SRational sRational) throws IOException {
        return new IFDEntry(37377, 10, 1, a, SRational.a(sRational));
    }

    public static IFDEntry createApertureValue(Rational rational) throws IOException {
        return new IFDEntry(37378, 5, 1, a, Rational.a(rational));
    }

    public static IFDEntry createBrightnessValue(Rational rational) throws IOException {
        return new IFDEntry(37379, 10, 1, a, Rational.a(rational));
    }

    public static IFDEntry createExposureBiasValue(Rational rational) throws IOException {
        return new IFDEntry(37380, 10, 1, a, Rational.a(rational));
    }

    public static IFDEntry createMaxApertureValue(Rational rational) throws IOException {
        return new IFDEntry(37381, 5, 1, a, Rational.a(rational));
    }

    public static IFDEntry createSubjectDistance(Rational rational) throws IOException {
        return new IFDEntry(37382, 5, 1, a, Rational.a(rational));
    }

    public static IFDEntry createMeteringMode(MeteringMode meteringMode) throws IOException {
        return new IFDEntry(37383, 3, 1, a, new short[]{meteringMode.value});
    }

    public static IFDEntry createLightSource(LightSource lightSource) throws IOException {
        return new IFDEntry(37384, 3, 1, a, new short[]{lightSource.value});
    }

    public static IFDEntry createFlash(FlashFiringStatus flashFiringStatus, FlashReturnStatus flashReturnStatus) throws IOException {
        int n2 = flashFiringStatus.status | flashReturnStatus.status;
        return new IFDEntry(37385, 3, 1, a, new short[]{(short)n2});
    }

    public static IFDEntry createFocalLength(Rational rational) throws IOException {
        return new IFDEntry(37386, 5, 1, a, Rational.a(rational));
    }

    public static IFDEntry createFNumber(Rational rational) throws IOException {
        return new IFDEntry(33437, 5, 1, a, Rational.a(rational));
    }

    public static IFDEntry createExposureProgram(ExposureProgram exposureProgram) throws IOException {
        return new IFDEntry(34850, 3, 1, a, new short[]{exposureProgram.value});
    }

    public static IFDEntry createSpectralSensitivity(String string) throws IOException {
        return new IFDEntry(34852, 2, 1, a, string.getBytes());
    }

    public static IFDEntry createISOSpeedRatings(short[] sArray) throws IOException {
        return new IFDEntry(34855, 3, sArray.length, a, sArray);
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    public static IFDEntry createOECF(int n2, int n3, String[] stringArray, SRational[][] sRationalArray) throws IOException {
        byte[] byArray;
        boolean bl = IFDEntryMeta.s;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream.writeShort(n2);
        dataOutputStream.writeShort(n3);
        int n4 = 0;
        boolean bl2 = true;
        do {
            if (bl2 && !(bl2 = false) && !bl) continue;
            String string = stringArray[n4];
            byArray = string.getBytes();
            dataOutputStream.write(byArray);
            if (byArray[byArray.length - 1] != 0) {
                dataOutputStream.write(0);
            }
            ++n4;
        } while (n4 < n2);
        int n5 = 0;
        boolean bl3 = true;
        do {
            if (bl3 && !(bl3 = false) && !bl) continue;
            int n6 = 0;
            boolean bl4 = true;
            do {
                if (bl4 && !(bl4 = false) && !bl) continue;
                SRational sRational = sRationalArray[n6][n5];
                dataOutputStream.writeInt(sRational.a);
                dataOutputStream.writeInt(sRational.b);
                ++n6;
            } while (n6 < n2);
            ++n5;
        } while (n5 < n3);
        dataOutputStream.flush();
        byArray = byteArrayOutputStream.toByteArray();
        return new IFDEntry(IFDEntryMeta.OECF.e, 7, byArray.length, a, byArray);
    }

    public static IFDEntry createExtraSamples(int n2) throws IOException {
        return new IFDEntry(IFDEntryMeta.EXTRA_SAMPLES.e, 3, 1, a, n2);
    }

    public static IFDEntry createFlashEnergy(Rational rational) throws IOException {
        return new IFDEntry(IFDEntryMeta.FLASH_ENERGY.e, 5, 1, a, Rational.a(rational));
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    public static IFDEntry createSpatialFrequencyResponse(int n2, int n3, String[] stringArray, SRational[][] sRationalArray) throws IOException {
        byte[] byArray;
        boolean bl = IFDEntryMeta.s;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream.writeShort(n2);
        dataOutputStream.writeShort(n3);
        int n4 = 0;
        boolean bl2 = true;
        do {
            if (bl2 && !(bl2 = false) && !bl) continue;
            String string = stringArray[n4];
            byArray = string.getBytes();
            dataOutputStream.write(byArray);
            if (byArray[byArray.length - 1] != 0) {
                dataOutputStream.write(0);
            }
            ++n4;
        } while (n4 < n2);
        int n5 = 0;
        boolean bl3 = true;
        do {
            if (bl3 && !(bl3 = false) && !bl) continue;
            int n6 = 0;
            boolean bl4 = true;
            do {
                if (bl4 && !(bl4 = false) && !bl) continue;
                SRational sRational = sRationalArray[n6][n5];
                dataOutputStream.writeInt(sRational.a);
                dataOutputStream.writeInt(sRational.b);
                ++n6;
            } while (n6 < n2);
            ++n5;
        } while (n5 < n3);
        dataOutputStream.flush();
        byArray = byteArrayOutputStream.toByteArray();
        return new IFDEntry(41484, 7, byArray.length, a, byArray);
    }

    public static IFDEntry createFocalPlaneXResolution(Rational rational) throws IOException {
        return new IFDEntry(41486, 5, 1, a, Rational.a(rational));
    }

    public static IFDEntry createFocalPlaneYResolution(Rational rational) throws IOException {
        return new IFDEntry(41487, 5, 1, a, Rational.a(rational));
    }

    public static IFDEntry createFocalPlaneResolutionUnit(ResolutionUnit resolutionUnit) throws IOException {
        return new IFDEntry(296, 3, 1, a, new short[]{resolutionUnit.value});
    }

    public static IFDEntry createSubjectLocation(int n2, int n3) throws IOException {
        short[] sArray = new short[]{(short)n2, (short)n3};
        return new IFDEntry(IFDEntryMeta.SUBJECT_LOCATION.e, 3, 2, a, sArray);
    }

    public static IFDEntry createSubjectArea(short[] sArray) throws IOException {
        return new IFDEntry(37396, 3, sArray.length, a, sArray);
    }

    public static IFDEntry createExposureIndex(Rational rational) throws IOException {
        return new IFDEntry(41493, 5, 1, a, Rational.a(rational));
    }

    public static IFDEntry createSensingMethod(SensingMethod sensingMethod) throws IOException {
        return new IFDEntry(41495, 3, 1, a, new short[]{sensingMethod.value});
    }

    public static IFDEntry createFileSource(FileSource fileSource) throws IOException {
        return new IFDEntry(41728, 7, 1, a, new byte[]{fileSource.value});
    }

    public static IFDEntry createSceneType(SceneType sceneType) throws IOException {
        return new IFDEntry(41729, 7, 1, a, new byte[]{sceneType.value});
    }

    /*
     * Unable to fully structure code
     */
    public static IFDEntry createCFAPattern(int var0, int var1_1, CFAValue[][] var2_2) throws IOException {
        var7_3 = IFDEntryMeta.s;
        var3_4 = new ByteArrayOutputStream();
        var4_5 = new DataOutputStream(var3_4);
        var4_5.writeShort(var0);
        var4_5.writeShort(var1_1);
        var5_6 = 0;
        if (!var7_3) ** GOTO lbl18
        do {
            var6_7 = 0;
            if (!var7_3) ** GOTO lbl15
            block1: while (true) {
                var4_5.writeByte(var2_2[var6_7][var5_6].value);
                do {
                    ++var6_7;
lbl15:
                    // 2 sources

                    if (var6_7 < var6_7) continue block1;
                } while (var7_3);
                break;
            }
            ++var5_6;
lbl18:
            // 2 sources

        } while (var5_6 < var5_6);
        var4_5.flush();
        var6_8 = var3_4.toByteArray();
        return new IFDEntry(IFDEntryMeta.CFA_PATTERN.e, 7, var6_8.length, IFDEntryFactory.a, var6_8);
    }

    public static IFDEntry createCustomRendered(CustomRendered customRendered) throws IOException {
        return new IFDEntry(IFDEntryMeta.CUSTOM_RENDERED.e, 3, 1, a, new short[]{customRendered.value});
    }

    public static IFDEntry createExposureMode(ExposureMode exposureMode) throws IOException {
        return new IFDEntry(IFDEntryMeta.EXPOSURE_MODE.e, 3, 1, a, new short[]{exposureMode.value});
    }

    public static IFDEntry createWhiteBalance(WhiteBalance whiteBalance) throws IOException {
        return new IFDEntry(IFDEntryMeta.WHITE_BALANCE.e, 3, 1, a, new short[]{whiteBalance.value});
    }

    public static IFDEntry createDigitalZoomRatio(Rational rational) throws IOException {
        return new IFDEntry(IFDEntryMeta.DIGITAL_ZOOM_RATIO.e, 5, 1, a, Rational.a(rational));
    }

    public static IFDEntry createFocalLengthIn35mmFilm(short s2) throws IOException {
        return new IFDEntry(IFDEntryMeta.FOCAL_LENGTH_IN_35_MM_FILM.e, 3, 1, a, new short[]{s2});
    }

    public static IFDEntry createSceneCaptureType(SceneCaptureType sceneCaptureType) throws IOException {
        return new IFDEntry(IFDEntryMeta.SCENE_CAPTURE_TYPE.e, 3, 1, a, new short[]{sceneCaptureType.value});
    }

    public static IFDEntry createGainControl(GainControl gainControl) throws IOException {
        return new IFDEntry(IFDEntryMeta.GAIN_CONTROL.e, 3, 1, a, new short[]{gainControl.value});
    }

    public static IFDEntry createContrast(Contrast contrast) throws IOException {
        return new IFDEntry(IFDEntryMeta.CONTRAST.e, 3, 1, a, new short[]{contrast.value});
    }

    public static IFDEntry createSaturation(Saturation saturation) throws IOException {
        return new IFDEntry(IFDEntryMeta.SATURATION.e, 3, 1, a, new short[]{saturation.value});
    }

    public static IFDEntry createSharpness(Sharpness sharpness) throws IOException {
        return new IFDEntry(IFDEntryMeta.SHARPNESS.e, 3, 1, a, new short[]{sharpness.value});
    }

    public static IFDEntry createDeviceSettingDescription(String string) throws IOException {
        byte[] byArray = string.getBytes();
        return new IFDEntry(IFDEntryMeta.DEVICE_SETTINGS_DESCRIPTION.e, 7, byArray.length, a, byArray);
    }

    public static IFDEntry createSubjectDistanceRange(SubjectDistanceRange subjectDistanceRange) throws IOException {
        return new IFDEntry(IFDEntryMeta.SUBJECT_DISTANCE_RANGE.e, 3, 1, a, new short[]{subjectDistanceRange.value});
    }

    public static IFDEntry createImageUniqueID(byte[] byArray) throws IOException {
        return new IFDEntry(IFDEntryMeta.IMAGE_UNIQUE_ID.e, 2, byArray.length, a, byArray);
    }

    public static IFDEntry createGPSVersionID(GPSVersionID gPSVersionID) throws IOException {
        byte[] byArray = gPSVersionID.getVersionData();
        return new IFDEntry(IFDEntryMeta.GPS_VERSION_ID.e, 1, byArray.length, a, byArray);
    }

    public static IFDEntry createGPSLatitudeRef(Latitude latitude) throws IOException {
        byte[] byArray = new byte[2];
        byArray[0] = latitude.value;
        return new IFDEntry(IFDEntryMeta.GPSLatitudeRef.e, 2, 2, a, byArray);
    }

    public static IFDEntry createGPSLatitude(Rational rational, Rational rational2, Rational rational3) throws IOException {
        Rational[] rationalArray = new Rational[]{rational, rational2, rational3};
        return new IFDEntry(IFDEntryMeta.GPS_LATITUDE.e, 5, rationalArray.length, a, Rational.a(rationalArray));
    }

    public static IFDEntry createGPSLongitudeRef(Longitude longitude) throws IOException {
        byte[] byArray = new byte[2];
        byArray[0] = longitude.value;
        return new IFDEntry(IFDEntryMeta.GPSLongitudeRef.e, 2, 2, a, byArray);
    }

    public static IFDEntry createGPSLongitude(Rational rational, Rational rational2, Rational rational3) throws IOException {
        Rational[] rationalArray = new Rational[]{rational, rational2, rational3};
        return new IFDEntry(IFDEntryMeta.GPS_LONGITUDE.e, 5, rationalArray.length, a, Rational.a(rationalArray));
    }

    public static IFDEntry createGPSAltitudeRef(Altitude altitude) throws IOException {
        return new IFDEntry(IFDEntryMeta.GPS_ALTITUDE_REF.e, 1, 2, a, new byte[]{altitude.value});
    }

    public static IFDEntry createGPSAltitude(Rational rational) throws IOException {
        int[] nArray = Rational.a(rational);
        return new IFDEntry(IFDEntryMeta.GPS_ALTITUDE.e, 5, nArray.length, a, nArray);
    }

    public static IFDEntry createGPSTimeStamp(Rational rational, Rational rational2, Rational rational3) throws IOException {
        Rational[] rationalArray = new Rational[]{rational, rational2, rational3};
        return new IFDEntry(IFDEntryMeta.GPS_TIME_STAMP.e, 5, rationalArray.length, a, Rational.a(rationalArray));
    }

    public static IFDEntry createGPSSatellites(String string) throws IOException {
        byte[] byArray = string.getBytes();
        return new IFDEntry(IFDEntryMeta.GPS_SATELLITES.e, 2, byArray.length, a, byArray);
    }

    public static IFDEntry createGPSMeasureMode(MeasureMode measureMode) throws IOException {
        byte[] byArray = new byte[2];
        byArray[0] = measureMode.value;
        return new IFDEntry(IFDEntryMeta.GPS_MEASURE_MODE.e, 2, 2, a, byArray);
    }

    public static IFDEntry createGPSDOP(Rational rational) throws IOException {
        return new IFDEntry(IFDEntryMeta.GPSDOP.e, 5, 1, a, Rational.a(rational));
    }

    public static IFDEntry createGPSSpeedRef(DistanceUnit distanceUnit) throws IOException {
        byte[] byArray = new byte[2];
        byArray[0] = distanceUnit.value;
        return new IFDEntry(IFDEntryMeta.GPS_SPEED_REF.e, 2, 2, a, byArray);
    }

    public static IFDEntry createGPSSpeed(Rational rational) throws IOException {
        return new IFDEntry(IFDEntryMeta.GPS_SPEED.e, 5, 1, a, Rational.a(rational));
    }

    public static IFDEntry createGPSTrackRef(Direction direction) throws IOException {
        byte[] byArray = new byte[2];
        byArray[0] = direction.value;
        return new IFDEntry(IFDEntryMeta.GPS_TRACK_REF.e, 2, 2, a, byArray);
    }

    public static IFDEntry createGPSTrack(Rational rational) throws IOException {
        return new IFDEntry(IFDEntryMeta.GPS_TRACK.e, 5, 1, a, Rational.a(rational));
    }

    public static IFDEntry createGPSImgDirectionRef(Direction direction) throws IOException {
        byte[] byArray = new byte[2];
        byArray[0] = direction.value;
        return new IFDEntry(IFDEntryMeta.GPS_IMG_DIRECTION_REF.e, 2, 2, a, byArray);
    }

    public static IFDEntry createGPSImgDirection(Rational rational) throws IOException {
        return new IFDEntry(IFDEntryMeta.GPS_IMG_DIRECTION.e, 5, 1, a, Rational.a(rational));
    }

    public static IFDEntry createGPSMapDatum(String string) throws IOException {
        byte[] byArray = string.getBytes();
        return new IFDEntry(IFDEntryMeta.GPS_MAP_DATUM.e, 2, byArray.length, a, byArray);
    }

    public static IFDEntry createGPSDestLatitudeRef(Latitude latitude) throws IOException {
        byte[] byArray = new byte[2];
        byArray[0] = latitude.value;
        return new IFDEntry(IFDEntryMeta.GPSDestLatitudeRef.e, 2, 2, a, byArray);
    }

    public static IFDEntry createGPSDestLatitude(Rational rational, Rational rational2, Rational rational3) throws IOException {
        Rational[] rationalArray = new Rational[]{rational, rational2, rational3};
        return new IFDEntry(IFDEntryMeta.GPS_DEST_LATITUDE.e, 5, rationalArray.length, a, Rational.a(rationalArray));
    }

    public static IFDEntry createGPSDestLongitudeRef(Longitude longitude) throws IOException {
        byte[] byArray = new byte[2];
        byArray[0] = longitude.value;
        return new IFDEntry(IFDEntryMeta.GPSDestLongitudeRef.e, 2, 2, a, byArray);
    }

    public static IFDEntry createGPSDestLongitude(Rational rational, Rational rational2, Rational rational3) throws IOException {
        Rational[] rationalArray = new Rational[]{rational, rational2, rational3};
        return new IFDEntry(IFDEntryMeta.GPS_DEST_LONGITUDE.e, 5, rationalArray.length, a, Rational.a(rationalArray));
    }

    public static IFDEntry createGPSDestBearingRef(Direction direction) throws IOException {
        byte[] byArray = new byte[2];
        byArray[0] = direction.value;
        return new IFDEntry(IFDEntryMeta.GPS_DEST_BEARING_REF.e, 2, 2, a, byArray);
    }

    public static IFDEntry createGPSDestBearing(Rational rational) throws IOException {
        return new IFDEntry(IFDEntryMeta.GPS_DEST_BEARING.e, 5, 1, a, Rational.a(rational));
    }

    public static IFDEntry createGPSDestDistanceRef(DistanceUnit distanceUnit) throws IOException {
        byte[] byArray = new byte[2];
        byArray[0] = distanceUnit.value;
        return new IFDEntry(IFDEntryMeta.GPS_DEST_DISTANCE_REF.e, 2, 2, a, byArray);
    }

    public static IFDEntry createGPSDestDistance(Rational rational) throws IOException {
        return new IFDEntry(IFDEntryMeta.GPS_DEST_DISTANCE.e, 5, 1, a, Rational.a(rational));
    }

    public static IFDEntry createGPSProcessingMethod(String string) throws IOException {
        byte[] byArray = string.getBytes();
        return new IFDEntry(IFDEntryMeta.GPS_PROCESSING_METHOD.e, 7, byArray.length, a, byArray);
    }

    public static IFDEntry createGPSAreaInformation(String string) throws IOException {
        byte[] byArray = string.getBytes();
        return new IFDEntry(IFDEntryMeta.GPS_AREA_INFORMATION.e, 7, byArray.length, a, byArray);
    }

    public static IFDEntry createGPSDateStamp(String string) throws IOException {
        byte[] byArray = string.getBytes();
        return new IFDEntry(IFDEntryMeta.GPS_DATE_STAMP.e, 2, byArray.length, a, byArray);
    }

    public static IFDEntry createGPSDifferential(short s2) throws IOException {
        return new IFDEntry(IFDEntryMeta.GPS_DIFFERENTIAL.e, 3, 1, a, new short[]{s2});
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        String[] stringArray;
        block21: {
            int n2;
            int n3;
            char[] cArray2;
            int n4;
            block20: {
                char[] cArray3;
                Object var0;
                block19: {
                    int n5;
                    int n6;
                    char[] cArray4;
                    block18: {
                        stringArray = new String[2];
                        var0 = null;
                        char[] cArray5 = "\u0005b8\u0007_rr.\u001d]r\u007f%\r] *w".toCharArray();
                        n4 = 0;
                        int n7 = cArray5.length;
                        cArray4 = cArray5;
                        n6 = n7;
                        if (n7 <= 1) break block18;
                        cArray3 = cArray4;
                        n5 = n6;
                        if (n6 <= n4) break block19;
                    }
                    do {
                        char[] cArray6 = cArray4;
                        char[] cArray7 = cArray4;
                        int n8 = n4;
                        while (true) {
                            int n9;
                            char c2 = cArray6[n8];
                            switch (n4 % 5) {
                                case 0: {
                                    n9 = 82;
                                    break;
                                }
                                case 1: {
                                    n9 = 16;
                                    break;
                                }
                                case 2: {
                                    n9 = 87;
                                    break;
                                }
                                case 3: {
                                    n9 = 105;
                                    break;
                                }
                                default: {
                                    n9 = 56;
                                }
                            }
                            cArray6[n8] = (char)(c2 ^ n9);
                            ++n4;
                            cArray4 = cArray7;
                            n6 = n6;
                            if (n6 != 0) break;
                            cArray7 = cArray4;
                            n5 = n6;
                            n8 = n6;
                            cArray6 = cArray4;
                        }
                        cArray3 = cArray4;
                        n5 = n6;
                    } while (n6 > n4);
                }
                stringArray[0] = new String(cArray3).intern();
                var0 = null;
                char[] cArray8 = "\u0007Cz(k\u0011Y\u001e".toCharArray();
                n4 = 0;
                int n10 = cArray8.length;
                cArray2 = cArray8;
                n3 = n10;
                if (n10 <= 1) break block20;
                cArray = cArray2;
                n2 = n3;
                if (n3 <= n4) break block21;
            }
            do {
                char[] cArray9 = cArray2;
                char[] cArray10 = cArray2;
                int n11 = n4;
                while (true) {
                    int n12;
                    char c3 = cArray9[n11];
                    switch (n4 % 5) {
                        case 0: {
                            n12 = 82;
                            break;
                        }
                        case 1: {
                            n12 = 16;
                            break;
                        }
                        case 2: {
                            n12 = 87;
                            break;
                        }
                        case 3: {
                            n12 = 105;
                            break;
                        }
                        default: {
                            n12 = 56;
                        }
                    }
                    cArray9[n11] = (char)(c3 ^ n12);
                    ++n4;
                    cArray2 = cArray10;
                    n3 = n3;
                    if (n3 != 0) break;
                    cArray10 = cArray2;
                    n2 = n3;
                    n11 = n3;
                    cArray9 = cArray2;
                }
                cArray = cArray2;
                n2 = n3;
            } while (n3 > n4);
        }
        stringArray[1] = new String(cArray).intern();
        z = stringArray;
        a = 19789;
    }
}

