/*
 * Decompiled with CFR 0.152.
 */
package com.imagero.reader.pro.decoder;

import com.imagero.java.EventSource;
import com.imagero.java.Rectangle;
import com.imagero.reader.ColorInfo;
import com.imagero.reader.ImageReader;
import com.imagero.reader.pro.DecoderTileI;
import com.imagero.uio.io.BitInputStream;
import com.imagero.uio.io.BitOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public abstract class ImageDecoder {
    protected Rectangle roi;
    protected ImageReader reader;
    protected int index;
    protected int width;
    protected int height;
    protected int pixelSize;
    protected int[] bitsPerSample;
    protected ColorInfo colorInfo;
    protected boolean planar;
    public static boolean a;

    public ImageDecoder(ImageReader imageReader, int n2) throws IOException {
        this(imageReader, n2, null);
    }

    public ImageDecoder(ImageReader imageReader, int n2, Rectangle rectangle) throws IOException {
        this.roi = rectangle;
        this.index = n2;
        this.reader = imageReader;
        int n3 = imageReader.getWidth(n2);
        int n4 = imageReader.getHeight(n2);
        this.height = rectangle == null ? n4 : Math.min(rectangle.height, n4);
        this.width = rectangle == null ? n3 : Math.min(rectangle.width, n3);
        this.pixelSize = imageReader.getPixelSize(n2);
        this.colorInfo = imageReader.getColorInfo(n2);
        this.bitsPerSample = imageReader.getBitsPerSample(n2);
    }

    public int getImageWidth() {
        return this.width;
    }

    public int getImageHeight() {
        return this.height;
    }

    public abstract int getTileWidth();

    public abstract int getTileHeight();

    public abstract DecoderTileI getTile(int var1, int var2) throws IOException;

    public ColorInfo getColorInfo() {
        return this.colorInfo;
    }

    public boolean isPlanar() {
        return this.planar;
    }

    public abstract void clean();

    /*
     * Unable to fully structure code
     */
    protected byte[] extractRoi(byte[] var1_1) throws IOException {
        var7_2 = ImageDecoder.a;
        if (this.roi == null) {
            return var1_1;
        }
        var2_3 = new BitInputStream(new ByteArrayInputStream(var1_1));
        var3_4 = new ByteArrayOutputStream(this.getRowLength(this.width, this.pixelSize));
        var4_5 = new BitOutputStream(var3_4);
        var4_5.setBitsToWrite(this.pixelSize);
        var2_3.setBitsToRead(this.pixelSize);
        var5_6 = 0;
        if (!var7_2) ** GOTO lbl16
        block0: while (true) {
            var2_3.read();
            do {
                ++var5_6;
lbl16:
                // 2 sources

                if (var5_6 < this.roi.x) continue block0;
                var6_7 = 0;
            } while (var7_2);
            break;
        }
        if (!var7_2) ** GOTO lbl24
        block2: while (true) {
            var4_5.write(var2_3.read());
            do {
                ++var6_7;
lbl24:
                // 2 sources

                if (var6_7 < this.roi.width) continue block2;
                var4_5.close();
            } while (var7_2);
            break;
        }
        return var3_4.toByteArray();
    }

    public final Rectangle tileToArea(Rectangle rectangle) {
        int n2 = this.getTileWidth();
        int n3 = this.getTileHeight();
        return new Rectangle(rectangle.x * n2, rectangle.y * n3, rectangle.width * n2, rectangle.height * n3);
    }

    public final Rectangle getEnclosingTiles(Rectangle rectangle) {
        boolean bl = a;
        int n2 = this.getTileWidth();
        int n3 = this.getTileHeight();
        int n4 = rectangle.x / n2;
        int n5 = rectangle.y / n3;
        int n6 = (rectangle.y + rectangle.height + n3 - 1) / n3;
        int n7 = (rectangle.x + rectangle.width + n2 - 1) / n2;
        Rectangle rectangle2 = new Rectangle(n4, n5, Math.min(this.getTileCountX() - n4, n7 - n4), Math.min(this.getTileCountY() - n5, n6 - n5));
        if (EventSource.c) {
            a = !bl;
        }
        return rectangle2;
    }

    public final Rectangle getEnclosedTiles(Rectangle rectangle) {
        int n2 = this.getTileWidth();
        int n3 = this.getTileHeight();
        int n4 = (rectangle.x + n2 - 1) / n2;
        int n5 = (rectangle.y + n3 - 1) / n3;
        int n6 = rectangle.width / n2;
        int n7 = rectangle.height / n3;
        return new Rectangle(n4, n5, n6, n7);
    }

    public final int getTileCountX() {
        return (this.getImageWidth() + this.getTileWidth() - 1) / this.getTileWidth();
    }

    public final int getTileCountY() {
        return (this.getImageHeight() + this.getTileHeight() - 1) / this.getTileHeight();
    }

    protected abstract int getRowLength(int var1, int var2);
}

