/*
 * Decompiled with CFR 0.152.
 */
package com.imagero.reader.png.chunk;

import com.imagero.reader.png.chunk.PngChunk;
import com.imagero.uio.RandomAccessInput;
import com.imagero.uio.io.IOutils;
import java.io.DataOutput;
import java.io.IOException;
import java.util.zip.CRC32;

public class AbstractChunk
implements PngChunk {
    String a;
    public final int type;
    protected byte[] data;
    protected long checksum = -1L;
    RandomAccessInput b;
    protected long filePointer = -1L;
    public final int length;
    protected int p;
    public static boolean c;

    protected AbstractChunk(int n2, int n3) {
        this.type = n2;
        this.length = n3;
    }

    protected AbstractChunk(int n2, byte[] byArray) {
        byArray = byArray != null ? byArray : new byte[]{};
        this.data = byArray;
        this.type = n2;
        this.length = byArray.length;
        this.a = new String(AbstractChunk.int2bytes(n2));
        this.checksum = this.computeChecksum();
        this.init();
    }

    public AbstractChunk(int n2, RandomAccessInput randomAccessInput, long l2, int n3) throws IOException {
        this.type = n2;
        this.length = n3;
        this.filePointer = l2;
        this.a = new String(AbstractChunk.int2bytes(n2));
        this.b = randomAccessInput;
        this.fillData();
        this.init();
    }

    protected void init() {
    }

    protected int readByte() {
        return this.data[this.p++] & 0xFF;
    }

    protected int readShort() {
        return (this.data[this.p++] & 0xFF) << 8 | this.data[this.p++] & 0xFF;
    }

    protected int readInt() {
        return (this.data[this.p++] & 0xFF) << 24 | (this.data[this.p++] & 0xFF) << 16 | (this.data[this.p++] & 0xFF) << 8 | this.data[this.p++] & 0xFF;
    }

    protected void fillData() throws IOException {
        if (this.length > 0) {
            this.data = new byte[this.length];
            this.b.seek(this.filePointer + 4L);
            this.b.readFully(this.data);
        }
        this.checksum = IOutils.readInt4D(this.b);
    }

    /*
     * Unable to fully structure code
     */
    public static byte[] int2bytes(int var0) {
        var3_1 = AbstractChunk.c;
        var1_2 = new byte[4];
        var2_3 = 0;
        if (!var3_1) ** GOTO lbl10
        block0: while (true) {
            v0 = var1_2;
            do {
                v0[var2_3] = (byte)(var0 >> (var1_2.length - 1 - var2_3) * 8 & 255);
                ++var2_3;
lbl10:
                // 2 sources

                if (var2_3 < var1_2.length) continue block0;
                v0 = var1_2;
            } while (var3_1);
            break;
        }
        return v0;
    }

    public static int name2int(String string) {
        byte[] byArray = string.getBytes();
        int n2 = 0;
        int n3 = 0;
        while (n3 < 4) {
            int n4 = byArray[n3] & 0xFF;
            n2 = n2 << 8 | n4;
            ++n3;
        }
        return n2;
    }

    public byte[] getData() {
        if (this.data != null) {
            return this.data;
        }
        byte[] byArray = new byte[this.length];
        try {
            this.b.seek(this.filePointer + 4L);
            this.b.readFully(byArray);
        }
        catch (IOException iOException) {}
        if (this.cacheData()) {
            this.data = byArray;
        }
        return byArray;
    }

    public int length() {
        return this.length;
    }

    public int getType() {
        return this.type;
    }

    public long getChecksum() throws IOException {
        if (this.checksum == -1L) {
            long l2 = this.filePointer + 4L + (long)this.length;
            this.b.seek(l2);
            return IOutils.readInt4D(this.b) & Integer.MAX_VALUE;
        }
        return this.checksum;
    }

    public boolean checkChunk() throws IOException {
        long l2 = this.computeChecksum();
        return l2 == this.getChecksum();
    }

    public boolean isCritical() {
        return AbstractChunk.isCritical(this.type);
    }

    public static boolean isCritical(int n2) {
        return (n2 & 0x20000000) != 0;
    }

    public boolean isPublic() {
        return AbstractChunk.isPublic(this.type);
    }

    public static boolean isPublic(int n2) {
        return (n2 & 0x200000) != 0;
    }

    public boolean isSaveToCopy() {
        return AbstractChunk.isSaveToCopy(this.type);
    }

    public static boolean isSaveToCopy(int n2) {
        return (n2 & 0x20) != 0;
    }

    public String getTypeAsString() {
        return this.a;
    }

    public boolean cacheData() {
        return true;
    }

    protected long computeChecksum() {
        CRC32 cRC32 = new CRC32();
        byte[] byArray = this.getData();
        byte[] byArray2 = AbstractChunk.int2bytes(this.type);
        cRC32.update(byArray2);
        cRC32.update(byArray);
        long l2 = cRC32.getValue() & 0xFFFFFFFFL;
        return l2;
    }

    /*
     * Unable to fully structure code
     */
    protected int getNameLength() {
        var3_1 = AbstractChunk.c;
        var1_2 = Math.min(79, this.data.length);
        var2_3 = 0;
        if (!var3_1) ** GOTO lbl11
        block0: while (true) {
            v0 = this.data[var2_3];
            do {
                if (v0 == 0) {
                    return var2_3;
                }
                ++var2_3;
lbl11:
                // 2 sources

                if (var2_3 < var1_2) continue block0;
                v0 = 80;
            } while (var3_1);
            break;
        }
        return v0;
    }

    public void write(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.length);
        dataOutput.writeInt(this.type);
        if (this.length > 0) {
            dataOutput.write(this.getData());
        }
        dataOutput.writeInt((int)this.checksum);
    }
}

