/*
 * Decompiled with CFR 0.152.
 */
package com.imagero.reader.marker;

import com.imagero.reader.ImageProcOptions;
import com.imagero.reader.ImageReader;
import com.imagero.reader.Imagero;
import com.imagero.reader.RawImageReader;
import com.imagero.reader.jpeg.JpegReader;
import com.imagero.reader.marker.JFIFConstants;
import com.imagero.reader.marker.Marker;
import com.imagero.uio.io.IOutils;
import java.awt.Image;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ThumbnailResource
implements JFIFConstants {
    protected static final int HEADER_LENGTH = 28;
    protected static final int FORMAT_0 = 0;
    protected static final int FORMAT_1 = 1;
    protected static final int FORMAT_2 = 2;
    protected static final int FORMAT_3 = 3;
    protected static final int WIDTH_0 = 4;
    protected static final int WIDTH_1 = 5;
    protected static final int WIDTH_2 = 6;
    protected static final int WIDTH_3 = 7;
    protected static final int HEIGHT_0 = 8;
    protected static final int HEIGHT_1 = 9;
    protected static final int HEIGHT_2 = 10;
    protected static final int HEIGHT_3 = 11;
    protected static final int WIDTHBYTES_0 = 12;
    protected static final int WIDTHBYTES_1 = 13;
    protected static final int WIDTHBYTES_2 = 14;
    protected static final int WIDTHBYTES_3 = 15;
    protected static final int SIZE_0 = 16;
    protected static final int SIZE_1 = 17;
    protected static final int SIZE_2 = 18;
    protected static final int SIZE_3 = 19;
    protected static final int COMPR_SIZE_0 = 20;
    protected static final int COMPR_SIZE_1 = 21;
    protected static final int COMPR_SIZE_2 = 22;
    protected static final int COMPR_SIZE_3 = 23;
    protected static final int BITSPIXEL_0 = 24;
    protected static final int BITSPIXEL_1 = 25;
    protected static final int PLANES_0 = 26;
    protected static final int PLANES_1 = 27;
    protected static final int DATA_0 = 27;
    protected byte[] header;
    protected byte[] data;

    /*
     * Unable to fully structure code
     */
    public ThumbnailResource(InputStream var1_1, int var2_2) throws IOException {
        var5_3 = Marker.b;
        super();
        this.header = new byte[28];
        var3_4 = 0;
        if (var5_3 == 0) ** GOTO lbl10
        block0: while (true) {
            this.header[var3_4] = (byte)(var1_1.read() & 255);
            do {
                ++var3_4;
lbl10:
                // 2 sources

                if (var3_4 < 28) continue block0;
                this.data = new byte[var2_2 - 28];
                var4_5 = 0;
            } while (var5_3 != 0);
            break;
        }
        if (var5_3 == 0) ** GOTO lbl19
        block2: while (true) {
            this.data[var4_5] = (byte)(var1_1.read() & 255);
            do {
                ++var4_5;
lbl19:
                // 2 sources

                if (var4_5 < var2_2 - 28) continue block2;
            } while (var5_3 != 0);
            break;
        }
    }

    public int getDataFormat() {
        return ThumbnailResource.b(this.header, 0);
    }

    public int getThumbnailWidth() {
        return ThumbnailResource.b(this.header, 4);
    }

    public int getThumbnailHeight() {
        return ThumbnailResource.b(this.header, 8);
    }

    public int getThumbnailSize() {
        return ThumbnailResource.b(this.header, 16);
    }

    public int getCompressedThumbnailSize() {
        return ThumbnailResource.b(this.header, 20);
    }

    public int getThumbnailBpp() {
        return ThumbnailResource.a(this.header, 24);
    }

    public int getThumbnailPlanes() {
        return ThumbnailResource.a(this.header, 26);
    }

    public int getThumbnailWidthBytes() {
        return ThumbnailResource.b(this.header, 12);
    }

    public byte[] getData() {
        return this.data;
    }

    public int getDataLength() {
        return this.data.length;
    }

    protected static int readByte(byte[] byArray, int n2) {
        return byArray[n2] & 0xFF;
    }

    private static int a(byte[] byArray, int n2) {
        return ((byArray[n2] & 0xFF) << 8) + (byArray[n2 + 1] & 0xFF);
    }

    private static int b(byte[] byArray, int n2) {
        return ((byArray[n2] & 0xFF) << 24) + ((byArray[n2 + 1] & 0xFF) << 16) + ((byArray[n2 + 2] & 0xFF) << 8) + (byArray[n2 + 3] & 0xFF);
    }

    public void saveThumbnail(String string) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        try {
            fileOutputStream.write(this.data);
        }
        finally {
            Object var4_3 = null;
            IOutils.closeStream(fileOutputStream);
        }
    }

    public void saveThumbnail(OutputStream outputStream) throws IOException {
        outputStream.write(this.data);
    }

    public Image getThumbnail() throws IOException {
        ImageProcOptions imageProcOptions = new ImageProcOptions();
        imageProcOptions.setSource(this.getImageReader());
        return Imagero.readImage(imageProcOptions);
    }

    public ImageReader getImageReader() throws IOException {
        if (this.getDataFormat() == 0) {
            int n2 = this.getThumbnailWidth();
            int n3 = this.getThumbnailHeight();
            return new RawImageReader(n2, n3, this.data, false, 3);
        }
        byte[] byArray = new byte[this.data.length];
        System.arraycopy(this.data, 0, byArray, 0, this.data.length);
        JpegReader jpegReader = new JpegReader(byArray);
        return jpegReader;
    }
}

