/*
 * Decompiled with CFR 0.152.
 */
package com.imagero.reader.jpeg;

import com.imagero.java.Rectangle;
import com.imagero.reader.AbstractImageReader;
import com.imagero.reader.ColorInfo;
import com.imagero.reader.ColorInfoBuilder;
import com.imagero.reader.ImageProducerAdapter;
import com.imagero.reader.MetadataUtils;
import com.imagero.reader.jpeg.BaselineDecoder;
import com.imagero.reader.jpeg.ChannelMap;
import com.imagero.reader.jpeg.ExtendedDecoder;
import com.imagero.reader.jpeg.HuffmanTable;
import com.imagero.reader.jpeg.JpegConstants;
import com.imagero.reader.jpeg.QuantizationTable;
import com.imagero.reader.jpeg.SimpleJpegWriter;
import com.imagero.reader.jpeg.e;
import com.imagero.reader.marker.DHTMarker;
import com.imagero.reader.marker.DQTMarker;
import com.imagero.reader.marker.ExifApp1;
import com.imagero.reader.marker.JpegMetadataReader;
import com.imagero.reader.marker.Marker;
import com.imagero.reader.marker.SOFMarker;
import com.imagero.reader.tiff.IFDEditor;
import com.imagero.reader.tiff.Rational;
import com.imagero.uio.RandomAccessIO;
import com.imagero.uio.RandomAccessInput;
import com.imagero.uio.UIOStreamBuilder;
import com.imagero.util.Vector;
import java.awt.image.ImageProducer;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;

public class JpegReader
extends AbstractImageReader
implements JpegConstants {
    Rectangle f;
    int g = 1;
    Vector h = new Vector();
    JpegMetadataReader i;
    SOFMarker j;
    DQTMarker k;
    DHTMarker l;
    protected IFDEditor exifEditor;
    boolean m;
    private ChannelMap n;
    private static String[] z;

    static RandomAccessInput a(File file) throws IOException {
        return new UIOStreamBuilder(file).setBuffered(true).create();
    }

    static RandomAccessIO b(File file) throws IOException {
        RandomAccessInput randomAccessInput = new UIOStreamBuilder(file).setMode(z[1]).setBuffered(true).create();
        return (RandomAccessIO)randomAccessInput;
    }

    public JpegReader(File file) throws IOException {
        this(file, 1);
    }

    public JpegReader(File file, boolean bl) throws IOException {
        this(file, bl, 1);
    }

    public JpegReader(File file, int n2) throws IOException {
        this(JpegReader.a(file), n2);
    }

    public JpegReader(File file, boolean bl, int n2) throws IOException {
        this(bl ? JpegReader.b(file) : JpegReader.a(file), n2);
    }

    public JpegReader(byte[] byArray) throws IOException {
        this(byArray, 1);
    }

    public JpegReader(byte[] byArray, int n2) throws IOException {
        this(new UIOStreamBuilder(byArray).setMode(z[1]).setByteOrder(19789).create(), n2);
    }

    public JpegReader(RandomAccessInput randomAccessInput) throws IOException {
        this(randomAccessInput, 1);
    }

    public JpegReader(RandomAccessInput randomAccessInput, int n2) throws IOException {
        this(randomAccessInput, randomAccessInput.getFilePointer(), n2);
    }

    public JpegReader(RandomAccessInput randomAccessInput, long l2, int n2) throws IOException {
        this.g = n2;
        this.ro = randomAccessInput;
        this.i = new JpegMetadataReader(randomAccessInput, l2);
        this.j = this.i.getFrameHeader();
        this.k = (DQTMarker)this.i.getMarker(z[15], 0);
        this.l = (DHTMarker)this.i.getMarker(z[17], 0);
    }

    public JpegMetadataReader getJpegMetadataReader() {
        return this.i;
    }

    public static boolean canRead(byte[] byArray) {
        if (byArray == null || byArray.length < 2) {
            return false;
        }
        return (byArray[0] & 0xFF) == 255 && (byArray[1] & 0xFF) == 216;
    }

    public static ImageProducer createReader(byte[] byArray) throws IOException {
        return JpegReader.createReader(byArray, null);
    }

    public static ImageProducer createReader(byte[] byArray, Rectangle rectangle) throws IOException {
        Vector vector = new Vector();
        vector.add(byArray);
        RandomAccessIO randomAccessIO = (RandomAccessIO)new UIOStreamBuilder(byArray).setMode(z[1]).setByteOrder(19789).create();
        JpegReader jpegReader = new JpegReader(randomAccessIO);
        return new BaselineDecoder(randomAccessIO, 1, jpegReader, rectangle);
    }

    public void setSubsampling(int n2) {
        this.g = n2;
    }

    public int getSubsampling() {
        return this.g;
    }

    public int getType() {
        return this.j.getTag() & 0xFF;
    }

    void a(boolean bl) {
        this.m = bl;
    }

    public SOFMarker getSof() {
        return this.j;
    }

    public DQTMarker getDqt() {
        return this.k;
    }

    public DHTMarker getDht() {
        return this.l;
    }

    BaselineDecoder b() throws IOException {
        switch (this.getType()) {
            case 192: 
            case 193: 
            case 194: {
                this.ro.seek(0L);
                BaselineDecoder baselineDecoder = new BaselineDecoder(this.ro, this.g, this, this.f);
                baselineDecoder.a(this.m);
                this.m = false;
                return baselineDecoder;
            }
        }
        throw new IOException(z[0] + this.getType());
    }

    e a(Rectangle rectangle) throws IOException {
        switch (this.getType()) {
            case 192: 
            case 193: 
            case 194: {
                this.ro.seek(0L);
                return new e(this.ro, this, rectangle);
            }
        }
        throw new IOException(z[0] + this.getType());
    }

    public BaselineDecoder createExtendedDecoder() throws IOException {
        switch (this.getType()) {
            case 192: 
            case 193: 
            case 194: {
                this.ro.seek(0L);
                return new ExtendedDecoder(this.ro, this.g, this, this.f);
            }
        }
        throw new IOException(z[0] + this.getType());
    }

    public int getHeight(int n2) {
        return this.j.getY();
    }

    public int getImageCount() {
        return 1;
    }

    public ImageProducerAdapter getProducer0(int n2) {
        try {
            BaselineDecoder baselineDecoder = this.b();
            baselineDecoder.setROI(this.f);
            baselineDecoder.setSubsampling(this.g);
            return baselineDecoder;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new RuntimeException(iOException.getMessage());
        }
    }

    public ImageProducerAdapter getProducer0(int n2, int n3) {
        try {
            BaselineDecoder baselineDecoder = this.b();
            baselineDecoder.setROI(this.f);
            baselineDecoder.setSubsampling(this.g);
            baselineDecoder.setChannelToRead(n3);
            return baselineDecoder;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new RuntimeException(iOException.getMessage());
        }
    }

    /*
     * Unable to fully structure code
     */
    public int getJpegQuality() {
        var9_1 = QuantizationTable.d;
        var1_2 = new Vector(4);
        var2_3 = this.getQuantizationTables();
        var3_4 = 0;
        if (!var9_1) ** GOTO lbl26
        block0: while (true) {
            var4_5 = 0;
            var5_6 = 0;
            do {
                var6_7 = ((QuantizationTable)var2_3.elementAt((int)var3_4)).c;
                if (!var9_1) ** GOTO lbl18
                block2: while (true) {
                    var4_5 += var6_7[var5_6] * (64 - var5_6);
                    v0 = var6_7[var5_6];
                    do {
                        block9: {
                            if (v0 == 0 && !var9_1) break block9;
                            ++var5_6;
lbl18:
                            // 2 sources

                            if (var5_6 < var6_7.length) continue block2;
                        }
                        v0 = var5_6;
                    } while (var9_1);
                    break;
                }
                if (v0 != 0) {
                    var4_5 /= var5_6;
                    var1_2.add(new Integer(var4_5 /= 16));
                }
                ++var3_4;
lbl26:
                // 2 sources

                if (var3_4 < var2_3.size()) continue block0;
                var4_5 = 0;
                var5_6 = 0;
                var6_8 = 0;
            } while (var9_1);
            break;
        }
        if (!var9_1) ** GOTO lbl38
        do {
            var7_9 = (Integer)var1_2.elementAt(var6_8);
            var8_11 = var1_2.size() + 1 - var6_8;
            var5_6 += var7_9 * var8_11;
            var4_5 += var8_11;
            ++var6_8;
lbl38:
            // 2 sources

        } while (var6_8 < var1_2.size());
        var7_10 = var5_6 / var4_5;
        return JpegReader.a(var7_10);
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    public Vector getQuantizationTables() {
        boolean bl = QuantizationTable.d;
        Vector vector = new Vector();
        int n2 = this.i.getMarkerCount(z[15]);
        int n3 = 0;
        boolean bl2 = true;
        do {
            if (bl2 && !(bl2 = false) && !bl) continue;
            DQTMarker dQTMarker = (DQTMarker)this.i.getMarker(z[15], n3);
            int n4 = dQTMarker.getTableCount();
            int n5 = 0;
            int n6 = n4;
            boolean bl3 = true;
            do {
                if (bl3 && !(bl3 = false) && !bl) continue;
                QuantizationTable quantizationTable = dQTMarker.getTable(n5);
                vector.add(quantizationTable);
                ++n5;
            } while (n5 < n6);
            ++n3;
        } while (n3 < n2);
        return vector;
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    public Vector getHuffmanTables() {
        boolean bl = QuantizationTable.d;
        Vector vector = new Vector();
        int n2 = this.i.getMarkerCount(z[17]);
        int n3 = 0;
        boolean bl2 = true;
        do {
            if (bl2 && !(bl2 = false) && !bl) continue;
            DHTMarker dHTMarker = (DHTMarker)this.i.getMarker(z[17], n3);
            int n4 = dHTMarker.getTableCount();
            int n5 = 0;
            int n6 = n4;
            boolean bl3 = true;
            do {
                if (bl3 && !(bl3 = false) && !bl) continue;
                HuffmanTable huffmanTable = dHTMarker.getTable(n5);
                vector.add(huffmanTable);
                ++n5;
            } while (n5 < n6);
            ++n3;
        } while (n3 < n2);
        return vector;
    }

    private static int a(int n2) {
        if (n2 >= 56) {
            return 1;
        }
        if (n2 >= 43) {
            return 2;
        }
        if (n2 >= 41) {
            return 3;
        }
        if (n2 >= 37) {
            return 4;
        }
        if (n2 >= 33) {
            return 5;
        }
        if (n2 >= 32) {
            return 6;
        }
        if (n2 >= 27) {
            return 7;
        }
        if (n2 >= 26) {
            return 8;
        }
        if (n2 >= 21) {
            return 9;
        }
        if (n2 >= 16) {
            return 10;
        }
        if (n2 >= 8) {
            return 11;
        }
        if (n2 >= 2) {
            return 12;
        }
        return 0;
    }

    public void saveImage(File file) throws IOException {
        new SimpleJpegWriter(this).saveImage(file);
    }

    public void saveImage(OutputStream outputStream) throws IOException {
        new SimpleJpegWriter(this).saveImage(outputStream);
    }

    public IFDEditor getExifEditor() throws IOException {
        if (this.ro instanceof RandomAccessIO) {
            if (this.exifEditor == null) {
                this.exifEditor = new IFDEditor(MetadataUtils.getExif(this));
            }
            return this.exifEditor;
        }
        throw new IOException(z[16]);
    }

    public int getWidth(int n2) {
        return this.j.getX();
    }

    public int getChannelCount(int n2) {
        return this.j.getNf();
    }

    public void setROI(int n2, Rectangle rectangle) {
        this.f = rectangle;
    }

    public Rectangle getROI(int n2) {
        return this.f;
    }

    public int getAvailableChannels(int n2) {
        if (this.j != null) {
            byte by = this.j.getNf();
            int n3 = this.getOriginalChannels(n2);
            switch (by) {
                case 1: {
                    return 0x40000 | n3;
                }
                case 3: {
                    return 0x1C07 | n3;
                }
                case 4: {
                    return 0x7F | n3;
                }
            }
            throw new IllegalArgumentException();
        }
        return -1;
    }

    protected ChannelMap getChannelMap() {
        if (this.n == null) {
            this.n = new ChannelMap(this.i);
        }
        return this.n;
    }

    public int getOriginalChannels(int n2) {
        ChannelMap channelMap = this.getChannelMap();
        String string = channelMap.getImageType();
        if (string == z[2]) {
            return 262144;
        }
        if (string == z[3]) {
            return 0x140000;
        }
        if (string == z[10]) {
            return 7;
        }
        if (string == z[6]) {
            return 0x100007;
        }
        if (string == z[7]) {
            return 7168;
        }
        if (string == z[9]) {
            return 0x101C00;
        }
        if (string == z[8]) {
            return 120;
        }
        if (string == z[4]) {
            return 7168;
        }
        if (string == z[5]) {
            return 7168;
        }
        return -1;
    }

    public int getSamplesPerPixel(int n2) {
        return this.j.getNf();
    }

    /*
     * Unable to fully structure code
     */
    public int[] getBitsPerSample(int var1_1) {
        var5_2 = QuantizationTable.d;
        var2_3 = new int[this.getSamplesPerPixel(var1_1)];
        var3_4 = this.j.getSamplePrecision();
        var4_5 = 0;
        if (!var5_2) ** GOTO lbl11
        block0: while (true) {
            v0 = var2_3;
            do {
                v0[var4_5] = var3_4;
                ++var4_5;
lbl11:
                // 2 sources

                if (var4_5 < var2_3.length) continue block0;
                v0 = var2_3;
            } while (var5_2);
            break;
        }
        return v0;
    }

    public int getPixelSize(int n2) {
        return this.getSamplesPerPixel(n2) * this.j.getSamplePrecision();
    }

    public Rational getXResolution(int n2) {
        try {
            ExifApp1 exifApp1 = this.i.getExif()[0];
            return exifApp1.getIFD((int)0).get.xResolution();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public Rational getYResolution(int n2) {
        try {
            ExifApp1 exifApp1 = this.i.getExif()[0];
            return exifApp1.getIFD((int)0).get.yResolution();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public String getResolutionUnit(int n2) {
        try {
            ExifApp1 exifApp1 = this.i.getExif()[0];
            short s2 = exifApp1.getIFD((int)0).get.resolutionUnit().value;
            switch (s2) {
                case 1: {
                    return z[12];
                }
                case 2: {
                    return z[14];
                }
                case 3: {
                    return z[13];
                }
            }
            return z[11];
        }
        catch (Throwable throwable) {
            return z[11];
        }
    }

    public ColorInfo getColorInfo(int n2) throws IOException {
        int n3;
        int[] nArray;
        block5: {
            String string;
            block12: {
                boolean bl;
                block11: {
                    block10: {
                        block9: {
                            block8: {
                                block7: {
                                    block6: {
                                        block4: {
                                            bl = QuantizationTable.d;
                                            ChannelMap channelMap = this.getChannelMap();
                                            string = channelMap.getImageType();
                                            nArray = this.getBitsPerSample(n2);
                                            n3 = 0;
                                            if (string != z[2]) break block4;
                                            n3 = 12;
                                            if (!bl) break block5;
                                        }
                                        if (string != z[3]) break block6;
                                        n3 = 12;
                                        if (!bl) break block5;
                                    }
                                    if (string != z[10]) break block7;
                                    n3 = 10;
                                    if (!bl) break block5;
                                }
                                if (string != z[6]) break block8;
                                n3 = 11;
                                if (!bl) break block5;
                            }
                            if (string != z[7]) break block9;
                            n3 = 3;
                            if (!bl) break block5;
                        }
                        if (string != z[9]) break block10;
                        n3 = 4;
                        if (!bl) break block5;
                    }
                    if (string != z[8]) break block11;
                    n3 = 6;
                    if (!bl) break block5;
                }
                if (string != z[4]) break block12;
                n3 = 7;
                if (!bl) break block5;
            }
            if (string == z[5]) {
                n3 = 3;
            }
        }
        return new ColorInfoBuilder().setColorSpace(n3).setBitsPerSample(nArray).create();
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    public void close() {
        super.close();
        Enumeration enumeration = this.i.markers();
        boolean bl = true;
        do {
            if (bl && !(bl = false) && !QuantizationTable.d) continue;
            Marker marker = (Marker)enumeration.nextElement();
            marker.close();
        } while (enumeration.hasMoreElements());
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        String[] stringArray;
        block197: {
            int n2;
            int n3;
            char[] cArray2;
            int n4;
            block196: {
                char[] cArray3;
                Object var0;
                block195: {
                    int n5;
                    int n6;
                    char[] cArray4;
                    block194: {
                        char[] cArray5;
                        block193: {
                            int n7;
                            int n8;
                            char[] cArray6;
                            block192: {
                                char[] cArray7;
                                block191: {
                                    int n9;
                                    int n10;
                                    char[] cArray8;
                                    block190: {
                                        char[] cArray9;
                                        block189: {
                                            int n11;
                                            int n12;
                                            char[] cArray10;
                                            block188: {
                                                char[] cArray11;
                                                block187: {
                                                    int n13;
                                                    int n14;
                                                    char[] cArray12;
                                                    block186: {
                                                        char[] cArray13;
                                                        block185: {
                                                            int n15;
                                                            int n16;
                                                            char[] cArray14;
                                                            block184: {
                                                                char[] cArray15;
                                                                block183: {
                                                                    int n17;
                                                                    int n18;
                                                                    char[] cArray16;
                                                                    block182: {
                                                                        char[] cArray17;
                                                                        block181: {
                                                                            int n19;
                                                                            int n20;
                                                                            char[] cArray18;
                                                                            block180: {
                                                                                char[] cArray19;
                                                                                block179: {
                                                                                    int n21;
                                                                                    int n22;
                                                                                    char[] cArray20;
                                                                                    block178: {
                                                                                        char[] cArray21;
                                                                                        block177: {
                                                                                            int n23;
                                                                                            int n24;
                                                                                            char[] cArray22;
                                                                                            block176: {
                                                                                                char[] cArray23;
                                                                                                block175: {
                                                                                                    int n25;
                                                                                                    int n26;
                                                                                                    char[] cArray24;
                                                                                                    block174: {
                                                                                                        char[] cArray25;
                                                                                                        block173: {
                                                                                                            int n27;
                                                                                                            int n28;
                                                                                                            char[] cArray26;
                                                                                                            block172: {
                                                                                                                char[] cArray27;
                                                                                                                block171: {
                                                                                                                    int n29;
                                                                                                                    int n30;
                                                                                                                    char[] cArray28;
                                                                                                                    block170: {
                                                                                                                        char[] cArray29;
                                                                                                                        block169: {
                                                                                                                            int n31;
                                                                                                                            int n32;
                                                                                                                            char[] cArray30;
                                                                                                                            block168: {
                                                                                                                                char[] cArray31;
                                                                                                                                block167: {
                                                                                                                                    int n33;
                                                                                                                                    int n34;
                                                                                                                                    char[] cArray32;
                                                                                                                                    block166: {
                                                                                                                                        char[] cArray33;
                                                                                                                                        block165: {
                                                                                                                                            int n35;
                                                                                                                                            int n36;
                                                                                                                                            char[] cArray34;
                                                                                                                                            block164: {
                                                                                                                                                char[] cArray35;
                                                                                                                                                block163: {
                                                                                                                                                    int n37;
                                                                                                                                                    int n38;
                                                                                                                                                    char[] cArray36;
                                                                                                                                                    block162: {
                                                                                                                                                        stringArray = new String[18];
                                                                                                                                                        var0 = null;
                                                                                                                                                        char[] cArray37 = "ny]a|16@}id6MrvxzF}`=|_vb=oJg%t{_\u007f`psAg`y,".toCharArray();
                                                                                                                                                        n4 = 0;
                                                                                                                                                        int n39 = cArray37.length;
                                                                                                                                                        cArray36 = cArray37;
                                                                                                                                                        n38 = n39;
                                                                                                                                                        if (n39 <= 1) break block162;
                                                                                                                                                        cArray35 = cArray36;
                                                                                                                                                        n37 = n38;
                                                                                                                                                        if (n38 <= n4) break block163;
                                                                                                                                                    }
                                                                                                                                                    do {
                                                                                                                                                        char[] cArray38 = cArray36;
                                                                                                                                                        char[] cArray39 = cArray36;
                                                                                                                                                        int n40 = n4;
                                                                                                                                                        while (true) {
                                                                                                                                                            int n41;
                                                                                                                                                            char c2 = cArray38[n40];
                                                                                                                                                            switch (n4 % 5) {
                                                                                                                                                                case 0: {
                                                                                                                                                                    n41 = 29;
                                                                                                                                                                    break;
                                                                                                                                                                }
                                                                                                                                                                case 1: {
                                                                                                                                                                    n41 = 22;
                                                                                                                                                                    break;
                                                                                                                                                                }
                                                                                                                                                                case 2: {
                                                                                                                                                                    n41 = 47;
                                                                                                                                                                    break;
                                                                                                                                                                }
                                                                                                                                                                case 3: {
                                                                                                                                                                    n41 = 19;
                                                                                                                                                                    break;
                                                                                                                                                                }
                                                                                                                                                                default: {
                                                                                                                                                                    n41 = 5;
                                                                                                                                                                }
                                                                                                                                                            }
                                                                                                                                                            cArray38[n40] = (char)(c2 ^ n41);
                                                                                                                                                            ++n4;
                                                                                                                                                            cArray36 = cArray39;
                                                                                                                                                            n38 = n38;
                                                                                                                                                            if (n38 != 0) break;
                                                                                                                                                            cArray39 = cArray36;
                                                                                                                                                            n37 = n38;
                                                                                                                                                            n40 = n38;
                                                                                                                                                            cArray38 = cArray36;
                                                                                                                                                        }
                                                                                                                                                        cArray35 = cArray36;
                                                                                                                                                        n37 = n38;
                                                                                                                                                    } while (n38 > n4);
                                                                                                                                                }
                                                                                                                                                stringArray[0] = new String(cArray35).intern();
                                                                                                                                                var0 = null;
                                                                                                                                                char[] cArray40 = "oa".toCharArray();
                                                                                                                                                n4 = 0;
                                                                                                                                                int n42 = cArray40.length;
                                                                                                                                                cArray34 = cArray40;
                                                                                                                                                n36 = n42;
                                                                                                                                                if (n42 <= 1) break block164;
                                                                                                                                                cArray33 = cArray34;
                                                                                                                                                n35 = n36;
                                                                                                                                                if (n36 <= n4) break block165;
                                                                                                                                            }
                                                                                                                                            do {
                                                                                                                                                char[] cArray41 = cArray34;
                                                                                                                                                char[] cArray42 = cArray34;
                                                                                                                                                int n43 = n4;
                                                                                                                                                while (true) {
                                                                                                                                                    int n44;
                                                                                                                                                    char c3 = cArray41[n43];
                                                                                                                                                    switch (n4 % 5) {
                                                                                                                                                        case 0: {
                                                                                                                                                            n44 = 29;
                                                                                                                                                            break;
                                                                                                                                                        }
                                                                                                                                                        case 1: {
                                                                                                                                                            n44 = 22;
                                                                                                                                                            break;
                                                                                                                                                        }
                                                                                                                                                        case 2: {
                                                                                                                                                            n44 = 47;
                                                                                                                                                            break;
                                                                                                                                                        }
                                                                                                                                                        case 3: {
                                                                                                                                                            n44 = 19;
                                                                                                                                                            break;
                                                                                                                                                        }
                                                                                                                                                        default: {
                                                                                                                                                            n44 = 5;
                                                                                                                                                        }
                                                                                                                                                    }
                                                                                                                                                    cArray41[n43] = (char)(c3 ^ n44);
                                                                                                                                                    ++n4;
                                                                                                                                                    cArray34 = cArray42;
                                                                                                                                                    n36 = n36;
                                                                                                                                                    if (n36 != 0) break;
                                                                                                                                                    cArray42 = cArray34;
                                                                                                                                                    n35 = n36;
                                                                                                                                                    n43 = n36;
                                                                                                                                                    cArray41 = cArray34;
                                                                                                                                                }
                                                                                                                                                cArray33 = cArray34;
                                                                                                                                                n35 = n36;
                                                                                                                                            } while (n36 > n4);
                                                                                                                                        }
                                                                                                                                        stringArray[1] = new String(cArray33).intern();
                                                                                                                                        var0 = null;
                                                                                                                                        char[] cArray43 = "ZdNjv~wCv".toCharArray();
                                                                                                                                        n4 = 0;
                                                                                                                                        int n45 = cArray43.length;
                                                                                                                                        cArray32 = cArray43;
                                                                                                                                        n34 = n45;
                                                                                                                                        if (n45 <= 1) break block166;
                                                                                                                                        cArray31 = cArray32;
                                                                                                                                        n33 = n34;
                                                                                                                                        if (n34 <= n4) break block167;
                                                                                                                                    }
                                                                                                                                    do {
                                                                                                                                        char[] cArray44 = cArray32;
                                                                                                                                        char[] cArray45 = cArray32;
                                                                                                                                        int n46 = n4;
                                                                                                                                        while (true) {
                                                                                                                                            int n47;
                                                                                                                                            char c4 = cArray44[n46];
                                                                                                                                            switch (n4 % 5) {
                                                                                                                                                case 0: {
                                                                                                                                                    n47 = 29;
                                                                                                                                                    break;
                                                                                                                                                }
                                                                                                                                                case 1: {
                                                                                                                                                    n47 = 22;
                                                                                                                                                    break;
                                                                                                                                                }
                                                                                                                                                case 2: {
                                                                                                                                                    n47 = 47;
                                                                                                                                                    break;
                                                                                                                                                }
                                                                                                                                                case 3: {
                                                                                                                                                    n47 = 19;
                                                                                                                                                    break;
                                                                                                                                                }
                                                                                                                                                default: {
                                                                                                                                                    n47 = 5;
                                                                                                                                                }
                                                                                                                                            }
                                                                                                                                            cArray44[n46] = (char)(c4 ^ n47);
                                                                                                                                            ++n4;
                                                                                                                                            cArray32 = cArray45;
                                                                                                                                            n34 = n34;
                                                                                                                                            if (n34 != 0) break;
                                                                                                                                            cArray45 = cArray32;
                                                                                                                                            n33 = n34;
                                                                                                                                            n46 = n34;
                                                                                                                                            cArray44 = cArray32;
                                                                                                                                        }
                                                                                                                                        cArray31 = cArray32;
                                                                                                                                        n33 = n34;
                                                                                                                                    } while (n34 > n4);
                                                                                                                                }
                                                                                                                                stringArray[2] = new String(cArray31).intern();
                                                                                                                                var0 = null;
                                                                                                                                char[] cArray46 = "ZdNjv~wCv%\\z_{d".toCharArray();
                                                                                                                                n4 = 0;
                                                                                                                                int n48 = cArray46.length;
                                                                                                                                cArray30 = cArray46;
                                                                                                                                n32 = n48;
                                                                                                                                if (n48 <= 1) break block168;
                                                                                                                                cArray29 = cArray30;
                                                                                                                                n31 = n32;
                                                                                                                                if (n32 <= n4) break block169;
                                                                                                                            }
                                                                                                                            do {
                                                                                                                                char[] cArray47 = cArray30;
                                                                                                                                char[] cArray48 = cArray30;
                                                                                                                                int n49 = n4;
                                                                                                                                while (true) {
                                                                                                                                    int n50;
                                                                                                                                    char c5 = cArray47[n49];
                                                                                                                                    switch (n4 % 5) {
                                                                                                                                        case 0: {
                                                                                                                                            n50 = 29;
                                                                                                                                            break;
                                                                                                                                        }
                                                                                                                                        case 1: {
                                                                                                                                            n50 = 22;
                                                                                                                                            break;
                                                                                                                                        }
                                                                                                                                        case 2: {
                                                                                                                                            n50 = 47;
                                                                                                                                            break;
                                                                                                                                        }
                                                                                                                                        case 3: {
                                                                                                                                            n50 = 19;
                                                                                                                                            break;
                                                                                                                                        }
                                                                                                                                        default: {
                                                                                                                                            n50 = 5;
                                                                                                                                        }
                                                                                                                                    }
                                                                                                                                    cArray47[n49] = (char)(c5 ^ n50);
                                                                                                                                    ++n4;
                                                                                                                                    cArray30 = cArray48;
                                                                                                                                    n32 = n32;
                                                                                                                                    if (n32 != 0) break;
                                                                                                                                    cArray48 = cArray30;
                                                                                                                                    n31 = n32;
                                                                                                                                    n49 = n32;
                                                                                                                                    cArray47 = cArray30;
                                                                                                                                }
                                                                                                                                cArray29 = cArray30;
                                                                                                                                n31 = n32;
                                                                                                                            } while (n32 > n4);
                                                                                                                        }
                                                                                                                        stringArray[3] = new String(cArray29).intern();
                                                                                                                        var0 = null;
                                                                                                                        char[] cArray49 = "DUlX".toCharArray();
                                                                                                                        n4 = 0;
                                                                                                                        int n51 = cArray49.length;
                                                                                                                        cArray28 = cArray49;
                                                                                                                        n30 = n51;
                                                                                                                        if (n51 <= 1) break block170;
                                                                                                                        cArray27 = cArray28;
                                                                                                                        n29 = n30;
                                                                                                                        if (n30 <= n4) break block171;
                                                                                                                    }
                                                                                                                    do {
                                                                                                                        char[] cArray50 = cArray28;
                                                                                                                        char[] cArray51 = cArray28;
                                                                                                                        int n52 = n4;
                                                                                                                        while (true) {
                                                                                                                            int n53;
                                                                                                                            char c6 = cArray50[n52];
                                                                                                                            switch (n4 % 5) {
                                                                                                                                case 0: {
                                                                                                                                    n53 = 29;
                                                                                                                                    break;
                                                                                                                                }
                                                                                                                                case 1: {
                                                                                                                                    n53 = 22;
                                                                                                                                    break;
                                                                                                                                }
                                                                                                                                case 2: {
                                                                                                                                    n53 = 47;
                                                                                                                                    break;
                                                                                                                                }
                                                                                                                                case 3: {
                                                                                                                                    n53 = 19;
                                                                                                                                    break;
                                                                                                                                }
                                                                                                                                default: {
                                                                                                                                    n53 = 5;
                                                                                                                                }
                                                                                                                            }
                                                                                                                            cArray50[n52] = (char)(c6 ^ n53);
                                                                                                                            ++n4;
                                                                                                                            cArray28 = cArray51;
                                                                                                                            n30 = n30;
                                                                                                                            if (n30 != 0) break;
                                                                                                                            cArray51 = cArray28;
                                                                                                                            n29 = n30;
                                                                                                                            n52 = n30;
                                                                                                                            cArray50 = cArray28;
                                                                                                                        }
                                                                                                                        cArray27 = cArray28;
                                                                                                                        n29 = n30;
                                                                                                                    } while (n30 > n4);
                                                                                                                }
                                                                                                                stringArray[4] = new String(cArray27).intern();
                                                                                                                var0 = null;
                                                                                                                char[] cArray52 = "M~@gj=OlP".toCharArray();
                                                                                                                n4 = 0;
                                                                                                                int n54 = cArray52.length;
                                                                                                                cArray26 = cArray52;
                                                                                                                n28 = n54;
                                                                                                                if (n54 <= 1) break block172;
                                                                                                                cArray25 = cArray26;
                                                                                                                n27 = n28;
                                                                                                                if (n28 <= n4) break block173;
                                                                                                            }
                                                                                                            do {
                                                                                                                char[] cArray53 = cArray26;
                                                                                                                char[] cArray54 = cArray26;
                                                                                                                int n55 = n4;
                                                                                                                while (true) {
                                                                                                                    int n56;
                                                                                                                    char c7 = cArray53[n55];
                                                                                                                    switch (n4 % 5) {
                                                                                                                        case 0: {
                                                                                                                            n56 = 29;
                                                                                                                            break;
                                                                                                                        }
                                                                                                                        case 1: {
                                                                                                                            n56 = 22;
                                                                                                                            break;
                                                                                                                        }
                                                                                                                        case 2: {
                                                                                                                            n56 = 47;
                                                                                                                            break;
                                                                                                                        }
                                                                                                                        case 3: {
                                                                                                                            n56 = 19;
                                                                                                                            break;
                                                                                                                        }
                                                                                                                        default: {
                                                                                                                            n56 = 5;
                                                                                                                        }
                                                                                                                    }
                                                                                                                    cArray53[n55] = (char)(c7 ^ n56);
                                                                                                                    ++n4;
                                                                                                                    cArray26 = cArray54;
                                                                                                                    n28 = n28;
                                                                                                                    if (n28 != 0) break;
                                                                                                                    cArray54 = cArray26;
                                                                                                                    n27 = n28;
                                                                                                                    n55 = n28;
                                                                                                                    cArray53 = cArray26;
                                                                                                                }
                                                                                                                cArray25 = cArray26;
                                                                                                                n27 = n28;
                                                                                                            } while (n28 > n4);
                                                                                                        }
                                                                                                        stringArray[5] = new String(cArray25).intern();
                                                                                                        var0 = null;
                                                                                                        char[] cArray55 = "OQmR".toCharArray();
                                                                                                        n4 = 0;
                                                                                                        int n57 = cArray55.length;
                                                                                                        cArray24 = cArray55;
                                                                                                        n26 = n57;
                                                                                                        if (n57 <= 1) break block174;
                                                                                                        cArray23 = cArray24;
                                                                                                        n25 = n26;
                                                                                                        if (n26 <= n4) break block175;
                                                                                                    }
                                                                                                    do {
                                                                                                        char[] cArray56 = cArray24;
                                                                                                        char[] cArray57 = cArray24;
                                                                                                        int n58 = n4;
                                                                                                        while (true) {
                                                                                                            int n59;
                                                                                                            char c8 = cArray56[n58];
                                                                                                            switch (n4 % 5) {
                                                                                                                case 0: {
                                                                                                                    n59 = 29;
                                                                                                                    break;
                                                                                                                }
                                                                                                                case 1: {
                                                                                                                    n59 = 22;
                                                                                                                    break;
                                                                                                                }
                                                                                                                case 2: {
                                                                                                                    n59 = 47;
                                                                                                                    break;
                                                                                                                }
                                                                                                                case 3: {
                                                                                                                    n59 = 19;
                                                                                                                    break;
                                                                                                                }
                                                                                                                default: {
                                                                                                                    n59 = 5;
                                                                                                                }
                                                                                                            }
                                                                                                            cArray56[n58] = (char)(c8 ^ n59);
                                                                                                            ++n4;
                                                                                                            cArray24 = cArray57;
                                                                                                            n26 = n26;
                                                                                                            if (n26 != 0) break;
                                                                                                            cArray57 = cArray24;
                                                                                                            n25 = n26;
                                                                                                            n58 = n26;
                                                                                                            cArray56 = cArray24;
                                                                                                        }
                                                                                                        cArray23 = cArray24;
                                                                                                        n25 = n26;
                                                                                                    } while (n26 > n4);
                                                                                                }
                                                                                                stringArray[6] = new String(cArray23).intern();
                                                                                                var0 = null;
                                                                                                char[] cArray58 = "DUMPw".toCharArray();
                                                                                                n4 = 0;
                                                                                                int n60 = cArray58.length;
                                                                                                cArray22 = cArray58;
                                                                                                n24 = n60;
                                                                                                if (n60 <= 1) break block176;
                                                                                                cArray21 = cArray22;
                                                                                                n23 = n24;
                                                                                                if (n24 <= n4) break block177;
                                                                                            }
                                                                                            do {
                                                                                                char[] cArray59 = cArray22;
                                                                                                char[] cArray60 = cArray22;
                                                                                                int n61 = n4;
                                                                                                while (true) {
                                                                                                    int n62;
                                                                                                    char c9 = cArray59[n61];
                                                                                                    switch (n4 % 5) {
                                                                                                        case 0: {
                                                                                                            n62 = 29;
                                                                                                            break;
                                                                                                        }
                                                                                                        case 1: {
                                                                                                            n62 = 22;
                                                                                                            break;
                                                                                                        }
                                                                                                        case 2: {
                                                                                                            n62 = 47;
                                                                                                            break;
                                                                                                        }
                                                                                                        case 3: {
                                                                                                            n62 = 19;
                                                                                                            break;
                                                                                                        }
                                                                                                        default: {
                                                                                                            n62 = 5;
                                                                                                        }
                                                                                                    }
                                                                                                    cArray59[n61] = (char)(c9 ^ n62);
                                                                                                    ++n4;
                                                                                                    cArray22 = cArray60;
                                                                                                    n24 = n24;
                                                                                                    if (n24 != 0) break;
                                                                                                    cArray60 = cArray22;
                                                                                                    n23 = n24;
                                                                                                    n61 = n24;
                                                                                                    cArray59 = cArray22;
                                                                                                }
                                                                                                cArray21 = cArray22;
                                                                                                n23 = n24;
                                                                                            } while (n24 > n4);
                                                                                        }
                                                                                        stringArray[7] = new String(cArray21).intern();
                                                                                        var0 = null;
                                                                                        char[] cArray61 = "^[vX".toCharArray();
                                                                                        n4 = 0;
                                                                                        int n63 = cArray61.length;
                                                                                        cArray20 = cArray61;
                                                                                        n22 = n63;
                                                                                        if (n63 <= 1) break block178;
                                                                                        cArray19 = cArray20;
                                                                                        n21 = n22;
                                                                                        if (n22 <= n4) break block179;
                                                                                    }
                                                                                    do {
                                                                                        char[] cArray62 = cArray20;
                                                                                        char[] cArray63 = cArray20;
                                                                                        int n64 = n4;
                                                                                        while (true) {
                                                                                            int n65;
                                                                                            char c10 = cArray62[n64];
                                                                                            switch (n4 % 5) {
                                                                                                case 0: {
                                                                                                    n65 = 29;
                                                                                                    break;
                                                                                                }
                                                                                                case 1: {
                                                                                                    n65 = 22;
                                                                                                    break;
                                                                                                }
                                                                                                case 2: {
                                                                                                    n65 = 47;
                                                                                                    break;
                                                                                                }
                                                                                                case 3: {
                                                                                                    n65 = 19;
                                                                                                    break;
                                                                                                }
                                                                                                default: {
                                                                                                    n65 = 5;
                                                                                                }
                                                                                            }
                                                                                            cArray62[n64] = (char)(c10 ^ n65);
                                                                                            ++n4;
                                                                                            cArray20 = cArray63;
                                                                                            n22 = n22;
                                                                                            if (n22 != 0) break;
                                                                                            cArray63 = cArray20;
                                                                                            n21 = n22;
                                                                                            n64 = n22;
                                                                                            cArray62 = cArray20;
                                                                                        }
                                                                                        cArray19 = cArray20;
                                                                                        n21 = n22;
                                                                                    } while (n22 > n4);
                                                                                }
                                                                                stringArray[8] = new String(cArray19).intern();
                                                                                var0 = null;
                                                                                char[] cArray64 = "DUMPw\\".toCharArray();
                                                                                n4 = 0;
                                                                                int n66 = cArray64.length;
                                                                                cArray18 = cArray64;
                                                                                n20 = n66;
                                                                                if (n66 <= 1) break block180;
                                                                                cArray17 = cArray18;
                                                                                n19 = n20;
                                                                                if (n20 <= n4) break block181;
                                                                            }
                                                                            do {
                                                                                char[] cArray65 = cArray18;
                                                                                char[] cArray66 = cArray18;
                                                                                int n67 = n4;
                                                                                while (true) {
                                                                                    int n68;
                                                                                    char c11 = cArray65[n67];
                                                                                    switch (n4 % 5) {
                                                                                        case 0: {
                                                                                            n68 = 29;
                                                                                            break;
                                                                                        }
                                                                                        case 1: {
                                                                                            n68 = 22;
                                                                                            break;
                                                                                        }
                                                                                        case 2: {
                                                                                            n68 = 47;
                                                                                            break;
                                                                                        }
                                                                                        case 3: {
                                                                                            n68 = 19;
                                                                                            break;
                                                                                        }
                                                                                        default: {
                                                                                            n68 = 5;
                                                                                        }
                                                                                    }
                                                                                    cArray65[n67] = (char)(c11 ^ n68);
                                                                                    ++n4;
                                                                                    cArray18 = cArray66;
                                                                                    n20 = n20;
                                                                                    if (n20 != 0) break;
                                                                                    cArray66 = cArray18;
                                                                                    n19 = n20;
                                                                                    n67 = n20;
                                                                                    cArray65 = cArray18;
                                                                                }
                                                                                cArray17 = cArray18;
                                                                                n19 = n20;
                                                                            } while (n20 > n4);
                                                                        }
                                                                        stringArray[9] = new String(cArray17).intern();
                                                                        var0 = null;
                                                                        char[] cArray67 = "OQm".toCharArray();
                                                                        n4 = 0;
                                                                        int n69 = cArray67.length;
                                                                        cArray16 = cArray67;
                                                                        n18 = n69;
                                                                        if (n69 <= 1) break block182;
                                                                        cArray15 = cArray16;
                                                                        n17 = n18;
                                                                        if (n18 <= n4) break block183;
                                                                    }
                                                                    do {
                                                                        char[] cArray68 = cArray16;
                                                                        char[] cArray69 = cArray16;
                                                                        int n70 = n4;
                                                                        while (true) {
                                                                            int n71;
                                                                            char c12 = cArray68[n70];
                                                                            switch (n4 % 5) {
                                                                                case 0: {
                                                                                    n71 = 29;
                                                                                    break;
                                                                                }
                                                                                case 1: {
                                                                                    n71 = 22;
                                                                                    break;
                                                                                }
                                                                                case 2: {
                                                                                    n71 = 47;
                                                                                    break;
                                                                                }
                                                                                case 3: {
                                                                                    n71 = 19;
                                                                                    break;
                                                                                }
                                                                                default: {
                                                                                    n71 = 5;
                                                                                }
                                                                            }
                                                                            cArray68[n70] = (char)(c12 ^ n71);
                                                                            ++n4;
                                                                            cArray16 = cArray69;
                                                                            n18 = n18;
                                                                            if (n18 != 0) break;
                                                                            cArray69 = cArray16;
                                                                            n17 = n18;
                                                                            n70 = n18;
                                                                            cArray68 = cArray16;
                                                                        }
                                                                        cArray15 = cArray16;
                                                                        n17 = n18;
                                                                    } while (n18 > n4);
                                                                }
                                                                stringArray[10] = new String(cArray15).intern();
                                                                var0 = null;
                                                                char[] cArray70 = "hxKvctxJw".toCharArray();
                                                                n4 = 0;
                                                                int n72 = cArray70.length;
                                                                cArray14 = cArray70;
                                                                n16 = n72;
                                                                if (n72 <= 1) break block184;
                                                                cArray13 = cArray14;
                                                                n15 = n16;
                                                                if (n16 <= n4) break block185;
                                                            }
                                                            do {
                                                                char[] cArray71 = cArray14;
                                                                char[] cArray72 = cArray14;
                                                                int n73 = n4;
                                                                while (true) {
                                                                    int n74;
                                                                    char c13 = cArray71[n73];
                                                                    switch (n4 % 5) {
                                                                        case 0: {
                                                                            n74 = 29;
                                                                            break;
                                                                        }
                                                                        case 1: {
                                                                            n74 = 22;
                                                                            break;
                                                                        }
                                                                        case 2: {
                                                                            n74 = 47;
                                                                            break;
                                                                        }
                                                                        case 3: {
                                                                            n74 = 19;
                                                                            break;
                                                                        }
                                                                        default: {
                                                                            n74 = 5;
                                                                        }
                                                                    }
                                                                    cArray71[n73] = (char)(c13 ^ n74);
                                                                    ++n4;
                                                                    cArray14 = cArray72;
                                                                    n16 = n16;
                                                                    if (n16 != 0) break;
                                                                    cArray72 = cArray14;
                                                                    n15 = n16;
                                                                    n73 = n16;
                                                                    cArray71 = cArray14;
                                                                }
                                                                cArray13 = cArray14;
                                                                n15 = n16;
                                                            } while (n16 > n4);
                                                        }
                                                        stringArray[11] = new String(cArray13).intern();
                                                        var0 = null;
                                                        char[] cArray73 = "sy\u000ffktb".toCharArray();
                                                        n4 = 0;
                                                        int n75 = cArray73.length;
                                                        cArray12 = cArray73;
                                                        n14 = n75;
                                                        if (n75 <= 1) break block186;
                                                        cArray11 = cArray12;
                                                        n13 = n14;
                                                        if (n14 <= n4) break block187;
                                                    }
                                                    do {
                                                        char[] cArray74 = cArray12;
                                                        char[] cArray75 = cArray12;
                                                        int n76 = n4;
                                                        while (true) {
                                                            int n77;
                                                            char c14 = cArray74[n76];
                                                            switch (n4 % 5) {
                                                                case 0: {
                                                                    n77 = 29;
                                                                    break;
                                                                }
                                                                case 1: {
                                                                    n77 = 22;
                                                                    break;
                                                                }
                                                                case 2: {
                                                                    n77 = 47;
                                                                    break;
                                                                }
                                                                case 3: {
                                                                    n77 = 19;
                                                                    break;
                                                                }
                                                                default: {
                                                                    n77 = 5;
                                                                }
                                                            }
                                                            cArray74[n76] = (char)(c14 ^ n77);
                                                            ++n4;
                                                            cArray12 = cArray75;
                                                            n14 = n14;
                                                            if (n14 != 0) break;
                                                            cArray75 = cArray12;
                                                            n13 = n14;
                                                            n76 = n14;
                                                            cArray74 = cArray12;
                                                        }
                                                        cArray11 = cArray12;
                                                        n13 = n14;
                                                    } while (n14 > n4);
                                                }
                                                stringArray[12] = new String(cArray11).intern();
                                                var0 = null;
                                                char[] cArray76 = "~{".toCharArray();
                                                n4 = 0;
                                                int n78 = cArray76.length;
                                                cArray10 = cArray76;
                                                n12 = n78;
                                                if (n78 <= 1) break block188;
                                                cArray9 = cArray10;
                                                n11 = n12;
                                                if (n12 <= n4) break block189;
                                            }
                                            do {
                                                char[] cArray77 = cArray10;
                                                char[] cArray78 = cArray10;
                                                int n79 = n4;
                                                while (true) {
                                                    int n80;
                                                    char c15 = cArray77[n79];
                                                    switch (n4 % 5) {
                                                        case 0: {
                                                            n80 = 29;
                                                            break;
                                                        }
                                                        case 1: {
                                                            n80 = 22;
                                                            break;
                                                        }
                                                        case 2: {
                                                            n80 = 47;
                                                            break;
                                                        }
                                                        case 3: {
                                                            n80 = 19;
                                                            break;
                                                        }
                                                        default: {
                                                            n80 = 5;
                                                        }
                                                    }
                                                    cArray77[n79] = (char)(c15 ^ n80);
                                                    ++n4;
                                                    cArray10 = cArray78;
                                                    n12 = n12;
                                                    if (n12 != 0) break;
                                                    cArray78 = cArray10;
                                                    n11 = n12;
                                                    n79 = n12;
                                                    cArray77 = cArray10;
                                                }
                                                cArray9 = cArray10;
                                                n11 = n12;
                                            } while (n12 > n4);
                                        }
                                        stringArray[13] = new String(cArray9).intern();
                                        var0 = null;
                                        char[] cArray79 = "txL{".toCharArray();
                                        n4 = 0;
                                        int n81 = cArray79.length;
                                        cArray8 = cArray79;
                                        n10 = n81;
                                        if (n81 <= 1) break block190;
                                        cArray7 = cArray8;
                                        n9 = n10;
                                        if (n10 <= n4) break block191;
                                    }
                                    do {
                                        char[] cArray80 = cArray8;
                                        char[] cArray81 = cArray8;
                                        int n82 = n4;
                                        while (true) {
                                            int n83;
                                            char c16 = cArray80[n82];
                                            switch (n4 % 5) {
                                                case 0: {
                                                    n83 = 29;
                                                    break;
                                                }
                                                case 1: {
                                                    n83 = 22;
                                                    break;
                                                }
                                                case 2: {
                                                    n83 = 47;
                                                    break;
                                                }
                                                case 3: {
                                                    n83 = 19;
                                                    break;
                                                }
                                                default: {
                                                    n83 = 5;
                                                }
                                            }
                                            cArray80[n82] = (char)(c16 ^ n83);
                                            ++n4;
                                            cArray8 = cArray81;
                                            n10 = n10;
                                            if (n10 != 0) break;
                                            cArray81 = cArray8;
                                            n9 = n10;
                                            n82 = n10;
                                            cArray80 = cArray8;
                                        }
                                        cArray7 = cArray8;
                                        n9 = n10;
                                    } while (n10 > n4);
                                }
                                stringArray[14] = new String(cArray7).intern();
                                var0 = null;
                                char[] cArray82 = "YG{".toCharArray();
                                n4 = 0;
                                int n84 = cArray82.length;
                                cArray6 = cArray82;
                                n8 = n84;
                                if (n84 <= 1) break block192;
                                cArray5 = cArray6;
                                n7 = n8;
                                if (n8 <= n4) break block193;
                            }
                            do {
                                char[] cArray83 = cArray6;
                                char[] cArray84 = cArray6;
                                int n85 = n4;
                                while (true) {
                                    int n86;
                                    char c17 = cArray83[n85];
                                    switch (n4 % 5) {
                                        case 0: {
                                            n86 = 29;
                                            break;
                                        }
                                        case 1: {
                                            n86 = 22;
                                            break;
                                        }
                                        case 2: {
                                            n86 = 47;
                                            break;
                                        }
                                        case 3: {
                                            n86 = 19;
                                            break;
                                        }
                                        default: {
                                            n86 = 5;
                                        }
                                    }
                                    cArray83[n85] = (char)(c17 ^ n86);
                                    ++n4;
                                    cArray6 = cArray84;
                                    n8 = n8;
                                    if (n8 != 0) break;
                                    cArray84 = cArray6;
                                    n7 = n8;
                                    n85 = n8;
                                    cArray83 = cArray6;
                                }
                                cArray5 = cArray6;
                                n7 = n8;
                            } while (n8 > n4);
                        }
                        stringArray[15] = new String(cArray5).intern();
                        var0 = null;
                        char[] cArray85 = "MzJrvx6Z``=a]zq|tCv%nb]vdp6\u0007Adsr@~D~uJ`vTY\u00063rtbG3@E_i3`y\u007f[|w".toCharArray();
                        n4 = 0;
                        int n87 = cArray85.length;
                        cArray4 = cArray85;
                        n6 = n87;
                        if (n87 <= 1) break block194;
                        cArray3 = cArray4;
                        n5 = n6;
                        if (n6 <= n4) break block195;
                    }
                    do {
                        char[] cArray86 = cArray4;
                        char[] cArray87 = cArray4;
                        int n88 = n4;
                        while (true) {
                            int n89;
                            char c18 = cArray86[n88];
                            switch (n4 % 5) {
                                case 0: {
                                    n89 = 29;
                                    break;
                                }
                                case 1: {
                                    n89 = 22;
                                    break;
                                }
                                case 2: {
                                    n89 = 47;
                                    break;
                                }
                                case 3: {
                                    n89 = 19;
                                    break;
                                }
                                default: {
                                    n89 = 5;
                                }
                            }
                            cArray86[n88] = (char)(c18 ^ n89);
                            ++n4;
                            cArray4 = cArray87;
                            n6 = n6;
                            if (n6 != 0) break;
                            cArray87 = cArray4;
                            n5 = n6;
                            n88 = n6;
                            cArray86 = cArray4;
                        }
                        cArray3 = cArray4;
                        n5 = n6;
                    } while (n6 > n4);
                }
                stringArray[16] = new String(cArray3).intern();
                var0 = null;
                char[] cArray88 = "Y^{".toCharArray();
                n4 = 0;
                int n90 = cArray88.length;
                cArray2 = cArray88;
                n3 = n90;
                if (n90 <= 1) break block196;
                cArray = cArray2;
                n2 = n3;
                if (n3 <= n4) break block197;
            }
            do {
                char[] cArray89 = cArray2;
                char[] cArray90 = cArray2;
                int n91 = n4;
                while (true) {
                    int n92;
                    char c19 = cArray89[n91];
                    switch (n4 % 5) {
                        case 0: {
                            n92 = 29;
                            break;
                        }
                        case 1: {
                            n92 = 22;
                            break;
                        }
                        case 2: {
                            n92 = 47;
                            break;
                        }
                        case 3: {
                            n92 = 19;
                            break;
                        }
                        default: {
                            n92 = 5;
                        }
                    }
                    cArray89[n91] = (char)(c19 ^ n92);
                    ++n4;
                    cArray2 = cArray90;
                    n3 = n3;
                    if (n3 != 0) break;
                    cArray90 = cArray2;
                    n2 = n3;
                    n91 = n3;
                    cArray89 = cArray2;
                }
                cArray = cArray2;
                n2 = n3;
            } while (n3 > n4);
        }
        stringArray[17] = new String(cArray).intern();
        z = stringArray;
    }
}

