/*
 * Decompiled with CFR 0.152.
 */
package com.imagero.reader.jpeg;

import com.imagero.java.EventSource;
import com.imagero.reader.jpeg.QuantizationTable;

public final class ColorConverter {
    public static final float C_RED = 0.2989f;
    public static final float C_GREEN = 0.5866f;
    public static final float C_BLUE = 0.1145f;

    public static float[] rgb2ycc(int n2, int n3, int n4) {
        float f2 = 0.2989f * (float)n2 + 0.5866f * (float)n3 + 0.1145f * (float)n4;
        float f3 = ((float)n2 - f2) / 1.4022f;
        float f4 = ((float)n4 - f2) / 1.771f;
        return new float[]{f2, f3, f4};
    }

    public static float[] rgb2ycc(int n2) {
        int n3 = n2 >> 16 & 0xFF;
        int n4 = n2 >> 8 & 0xFF;
        int n5 = n2 & 0xFF;
        float f2 = 0.2989f * (float)n3 + 0.5866f * (float)n4 + 0.1145f * (float)n5;
        float f3 = ((float)n3 - f2) / 1.4022f;
        float f4 = ((float)n5 - f2) / 1.771f;
        return new float[]{f2, f3, f4};
    }

    public static float rgb2y(int n2, int n3, int n4) {
        return 0.2989f * (float)n2 + 0.5866f * (float)n3 + 0.1145f * (float)n4;
    }

    public static float rgb2y(int n2) {
        int n3 = n2 >> 16 & 0xFF;
        int n4 = n2 >> 8 & 0xFF;
        int n5 = n2 & 0xFF;
        return 0.2989f * (float)n3 + 0.5866f * (float)n4 + 0.1145f * (float)n5;
    }

    public static float[] rgb2ycc(float[] fArray, int n2, int n3, int n4) {
        float f2 = 0.2989f * (float)n2 + 0.5866f * (float)n3 + 0.1145f * (float)n4;
        float f3 = ((float)n2 - f2) / 1.4022f;
        float f4 = ((float)n4 - f2) / 1.771f;
        fArray[0] = f2;
        fArray[1] = f3;
        fArray[2] = f4;
        return fArray;
    }

    public static float[] rgb2ycc(float[] fArray, int n2) {
        int n3 = n2 >> 16 & 0xFF;
        int n4 = n2 >> 8 & 0xFF;
        int n5 = n2 & 0xFF;
        float f2 = 0.2989f * (float)n3 + 0.5866f * (float)n4 + 0.1145f * (float)n5;
        float f3 = ((float)n3 - f2) / 1.4022f;
        float f4 = ((float)n5 - f2) / 1.771f;
        fArray[0] = f2;
        fArray[1] = f3;
        fArray[2] = f4;
        return fArray;
    }

    public static int ycc2rgb(float f2, float f3, float f4) {
        int n2 = (int)(f2 + 1.4022f * f3);
        int n3 = (int)((double)f2 - 0.34414 * (double)f4 - 0.71414 * (double)f3);
        int n4 = (int)(f2 + 1.772f * f4);
        n2 = (n2 > 255 ? 255 : (n2 < 0 ? 0 : n2)) & 0xFF;
        n3 = (n3 > 255 ? 255 : (n3 < 0 ? 0 : n3)) & 0xFF;
        n4 = (n4 > 255 ? 255 : (n4 < 0 ? 0 : n4)) & 0xFF;
        return 0xFF000000 | n2 << 16 | n3 << 8 | n4;
    }

    public static int ycca2rgb(float f2, float f3, float f4, float f5) {
        int n2 = (int)(f2 + 1.4022f * f3);
        int n3 = (int)((double)f2 - 0.34414 * (double)f4 - 0.71414 * (double)f3);
        int n4 = (int)(f2 + 1.772f * f4);
        int n5 = (int)f5 & 0xFF;
        n2 = (n2 > 255 ? 255 : (n2 < 0 ? 0 : n2)) & 0xFF;
        n3 = (n3 > 255 ? 255 : (n3 < 0 ? 0 : n3)) & 0xFF;
        n4 = (n4 > 255 ? 255 : (n4 < 0 ? 0 : n4)) & 0xFF;
        return n5 << 24 | n2 << 16 | n3 << 8 | n4;
    }

    public static int cmyk2cmykI(float f2, float f3, float f4, int n2) {
        int n3 = 255 - (int)f2;
        int n4 = 255 - (int)f3;
        int n5 = 255 - (int)f4;
        int n6 = 255 - n2;
        int n7 = n3 > 255 ? 255 : (n3 = n3 < 0 ? 0 : n3);
        int n8 = n4 > 255 ? 255 : (n4 = n4 < 0 ? 0 : n4);
        int n9 = n5 > 255 ? 255 : (n5 = n5 < 0 ? 0 : n5);
        n6 = n6 > 255 ? 255 : (n6 < 0 ? 0 : n6);
        return n6 << 24 | n3 << 16 | n4 << 8 | n5;
    }

    public static int cmyk2cmyk(float f2, float f3, float f4, int n2) {
        int n3 = (int)f2;
        int n4 = (int)f3;
        int n5 = (int)f4;
        int n6 = n2;
        int n7 = n3 > 255 ? 255 : (n3 = n3 < 0 ? 0 : n3);
        int n8 = n4 > 255 ? 255 : (n4 = n4 < 0 ? 0 : n4);
        int n9 = n5 > 255 ? 255 : (n5 = n5 < 0 ? 0 : n5);
        n6 = n6 > 255 ? 255 : (n6 < 0 ? 0 : n6);
        return n6 << 24 | n3 << 16 | n4 << 8 | n5;
    }

    public static int cmyk2rgb(float f2, float f3, float f4, int n2) {
        int n3 = (int)f2;
        int n4 = (int)f3;
        int n5 = (int)f4;
        int n6 = n2;
        int n7 = n3 > 255 ? 255 : (n3 = n3 < 0 ? 0 : n3);
        int n8 = n4 > 255 ? 255 : (n4 = n4 < 0 ? 0 : n4);
        int n9 = n5 > 255 ? 255 : (n5 = n5 < 0 ? 0 : n5);
        n6 = n6 > 255 ? 255 : (n6 < 0 ? 0 : n6);
        int n10 = n6 + n3;
        int n11 = n6 + n4;
        int n12 = n6 + n5;
        int n13 = n10 > 255 ? 255 : (n10 = n10 < 0 ? 0 : n10);
        int n14 = n11 > 255 ? 255 : (n11 = n11 < 0 ? 0 : n11);
        n12 = n12 > 255 ? 255 : (n12 < 0 ? 0 : n12);
        n10 = 255 - n10;
        n11 = 255 - n11;
        n12 = 255 - n12;
        return 0xFF000000 | n10 << 16 | n11 << 8 | n12;
    }

    public static int ycck2cmyk(float f2, float f3, float f4, int n2) {
        int n3 = (int)(f2 + 1.4022f * (f4 - 128.0f));
        int n4 = (int)((double)f2 - 0.34414 * (double)(f3 - 128.0f) - 0.71414 * (double)(f4 - 128.0f));
        int n5 = (int)(f2 + 1.772f * (f3 - 128.0f));
        int n6 = 255 - n3;
        int n7 = 255 - n4;
        int n8 = 255 - n5;
        int n9 = n6 > 255 ? 255 : (n6 = n6 < 0 ? 0 : n6);
        int n10 = n7 > 255 ? 255 : (n7 = n7 < 0 ? 0 : n7);
        int n11 = n8 > 255 ? 255 : (n8 = n8 < 0 ? 0 : n8);
        n2 = n2 > 255 ? 255 : (n2 < 0 ? 0 : n2);
        return n2 << 24 | n6 << 16 | n7 << 8 | n8;
    }

    public static int ycck2rgb(float f2, float f3, float f4, int n2) {
        boolean bl = QuantizationTable.d;
        int n3 = (int)(f2 + 1.4022f * (f4 - 128.0f));
        int n4 = (int)((double)f2 - 0.34414 * (double)(f3 - 128.0f) - 0.71414 * (double)(f4 - 128.0f));
        int n5 = (int)(f2 + 1.772f * (f3 - 128.0f));
        int n6 = 255 - n3;
        int n7 = 255 - n4;
        int n8 = 255 - n5;
        int n9 = n6 > 255 ? 255 : (n6 = n6 < 0 ? 0 : n6);
        int n10 = n7 > 255 ? 255 : (n7 = n7 < 0 ? 0 : n7);
        int n11 = n8 > 255 ? 255 : (n8 = n8 < 0 ? 0 : n8);
        n2 = n2 > 255 ? 255 : (n2 < 0 ? 0 : n2);
        int n12 = n2 + n6;
        int n13 = n2 + n7;
        int n14 = n2 + n8;
        int n15 = n12 * n12 >> 10;
        int n16 = n13 * n13 >> 10;
        int n17 = n14 * n14 >> 10;
        int n18 = n15 > 255 ? 255 : (n15 = n15 < 0 ? 0 : n15);
        int n19 = n16 > 255 ? 255 : (n16 = n16 < 0 ? 0 : n16);
        int n20 = n17 > 255 ? 255 : (n17 = n17 < 0 ? 0 : n17);
        if (EventSource.c) {
            QuantizationTable.d = !bl;
        }
        return 0xFF000000 | n15 << 16 | n16 << 8 | n17;
    }

    public static int ycck2rgbA(float f2, float f3, float f4, int n2) {
        float f5 = f2 + 1.402f * (f4 - 128.0f);
        float f6 = f2 - 0.34414f * (f3 - 128.0f) - 0.71414f * (f4 - 128.0f);
        float f7 = f2 + 1.772f * (f3 - 128.0f);
        int n3 = (int)((double)f5 < 0.0 ? 0.0 : ((double)f5 > 255.0 ? 255.0 : (double)f5 + 0.5));
        int n4 = (int)((double)f6 < 0.0 ? 0.0 : ((double)f6 > 255.0 ? 255.0 : (double)f6 + 0.5));
        int n5 = (int)((double)f7 < 0.0 ? 0.0 : ((double)f7 > 255.0 ? 255.0 : (double)f7 + 0.5));
        return n2 << 24 | n3 << 16 | n4 << 8 | n5;
    }

    public static int ycck2rgbU(float f2, float f3, float f4, int n2) {
        int n3 = 127;
        int n4 = n2 - (int)(f2 + 1.4022f * (f4 - (float)n3));
        int n5 = n2 - (int)((double)f2 - 0.34414 * (double)(f3 - (float)n3) - 0.71414 * (double)(f4 - (float)n3));
        int n6 = n2 - (int)(f2 + 1.772f * (f3 - (float)n3));
        int n7 = n4 > 255 ? 255 : (n4 = n4 < 0 ? 0 : n4);
        int n8 = n5 > 255 ? 255 : (n5 = n5 < 0 ? 0 : n5);
        n6 = n6 > 255 ? 255 : (n6 < 0 ? 0 : n6);
        return 0xFF000000 | n4 << 16 | n5 << 8 | n6;
    }

    public static int ycck2rgbInt(int n2, int n3, int n4, int n5) {
        int n6 = 255 - (int)((float)n2 + 1.4022f * (float)n4);
        int n7 = 255 - (int)((double)n2 - 0.34414 * (double)n3 - 0.71414 * (double)n4);
        int n8 = 255 - (int)((float)n2 + 1.772f * (float)n3);
        int n9 = n6 > 255 ? 255 : (n6 = n6 < 0 ? 0 : n6);
        int n10 = n7 > 255 ? 255 : (n7 = n7 < 0 ? 0 : n7);
        n8 = n8 > 255 ? 255 : (n8 < 0 ? 0 : n8);
        return n5 << 24 | n6 << 16 | n7 << 8 | n8;
    }
}

