/*
 * Decompiled with CFR 0.152.
 */
package com.imagero.reader.jp2.box;

import com.imagero.reader.jp2.box.Box;
import com.imagero.reader.jp2.box.Signature;
import com.imagero.uio.RandomAccessInput;
import java.io.DataOutput;
import java.io.IOException;

public class OpacityBox
extends Box {
    byte j;
    byte k;
    byte[] l;

    public OpacityBox(int n2, int n3, byte[] byArray) {
        super(1 + (n2 != 2 ? 1 : 0) + (byArray != null ? byArray.length : 0), Signature.OPACITY);
        this.j = (byte)n2;
        this.k = (byte)n3;
        this.l = byArray;
    }

    public OpacityBox(RandomAccessInput randomAccessInput) throws IOException {
        super(randomAccessInput);
    }

    public OpacityBox(RandomAccessInput randomAccessInput, long l2) throws IOException {
        super(randomAccessInput, l2);
    }

    protected void readData() throws IOException {
        this.j = this.rai.readByte();
        switch (this.j) {
            case 0: 
            case 1: {
                this.k = this.rai.readByte();
                int n2 = (int)this.getDistance(this.rai.getFilePointer());
                this.l = new byte[n2];
                this.rai.readFully(this.l);
                break;
            }
        }
    }

    public void writeBox(DataOutput dataOutput) throws IOException {
        this.writeHeader(dataOutput);
        dataOutput.writeByte(this.j);
        if (this.j != 2) {
            dataOutput.writeByte(this.k);
            if (this.l != null && this.l.length > 0) {
                dataOutput.write(this.l);
            }
        }
    }

    protected void checkSignature() throws IOException {
        this.assertEquals(Signature.OPACITY);
    }
}

