/*
 * Decompiled with CFR 0.152.
 */
package com.imagero.reader.jp2.box;

import com.imagero.java.Dimension;
import com.imagero.java.Point;
import com.imagero.java.Rectangle;
import com.imagero.reader.jp2.box.Box;
import com.imagero.reader.jp2.box.Signature;
import com.imagero.uio.RandomAccessInput;
import com.imagero.util.Vector;
import java.io.DataOutput;
import java.io.IOException;

public class InstructionSetBox
extends Box {
    public static final int INSTR_NONE = 0;
    public static final int INSTR_LOCATION = 1;
    public static final int INSTR_DIMENSION = 2;
    public static final int INSTR_ANIMATION = 8;
    public static final int INSTR_CROP = 32;
    short j;
    short k;
    int l;
    InstructionParameter[] m;

    public InstructionSetBox(short s2, int n2, InstructionParameter[] instructionParameterArray) {
        super(8L + InstructionSetBox.a(instructionParameterArray), Signature.INSTRUCTION_SET);
        this.j = instructionParameterArray != null ? instructionParameterArray[0].a : (short)0;
        this.k = s2;
        this.l = n2;
        this.m = instructionParameterArray;
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    private static long a(InstructionParameter[] instructionParameterArray) {
        long l2 = 0L;
        if (instructionParameterArray != null) {
            int n2 = 0;
            boolean bl = true;
            do {
                if (bl && !(bl = false) && !Box.i) continue;
                l2 += (long)instructionParameterArray[n2].length();
                ++n2;
            } while (n2 < instructionParameterArray.length);
        }
        return l2;
    }

    public InstructionSetBox(RandomAccessInput randomAccessInput) throws IOException {
        super(randomAccessInput);
    }

    public InstructionSetBox(RandomAccessInput randomAccessInput, long l2) throws IOException {
        super(randomAccessInput, l2);
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    protected void readData() throws IOException {
        this.j = this.rai.readShort();
        this.k = this.rai.readShort();
        this.l = this.rai.readInt();
        int n2 = (int)this.getDistance(this.rai.getFilePointer());
        Vector vector = new Vector();
        boolean bl = true;
        do {
            if (bl && !(bl = false) && !Box.i) continue;
            InstructionParameter instructionParameter = new InstructionParameter(this.j, this.rai);
            n2 -= instructionParameter.length();
            vector.add(instructionParameter);
        } while (n2 > 0);
        this.m = new InstructionParameter[vector.size()];
        vector.toArray(this.m);
    }

    /*
     * Unable to fully structure code
     */
    public void writeBox(DataOutput var1_1) throws IOException {
        var3_2 = Box.i;
        this.writeHeader(var1_1);
        var1_1.writeByte(this.j);
        var1_1.writeShort(this.k);
        var1_1.writeInt(this.l);
        var2_3 = 0;
        if (!var3_2) ** GOTO lbl12
        block0: while (true) {
            this.m[var2_3].a(var1_1);
            do {
                ++var2_3;
lbl12:
                // 2 sources

                if (var2_3 < this.m.length) continue block0;
            } while (var3_2);
            break;
        }
    }

    protected void checkSignature() throws IOException {
        this.assertEquals(Signature.INSTRUCTION_SET);
    }

    public static final class InstructionParameter {
        short a;
        int b;
        int c;
        int d;
        int e;
        boolean f;
        int g;
        int h;
        int i;
        int j;
        int k;
        int l;

        public InstructionParameter(Point point, Dimension dimension, AnimationParameter animationParameter, Rectangle rectangle) {
            if (point != null) {
                this.a = (short)(this.a | 1);
                this.b = point.x;
                this.c = point.y;
            }
            if (dimension != null) {
                this.a = (short)(this.a | 2);
                this.d = dimension.width;
                this.e = dimension.height;
            }
            if (animationParameter != null) {
                this.a = (short)(this.a | 8);
                this.f = animationParameter.a;
                this.g = animationParameter.b;
                this.h = animationParameter.c;
            }
            if (rectangle != null) {
                this.a = (short)(this.a | 0x20);
                this.i = rectangle.x;
                this.j = rectangle.y;
                this.k = rectangle.width;
                this.l = rectangle.height;
            }
        }

        InstructionParameter(short s2, RandomAccessInput randomAccessInput) throws IOException {
            this.a = s2;
            if ((this.a & 1) != 0) {
                this.b = randomAccessInput.readInt();
                this.c = randomAccessInput.readInt();
            }
            if ((this.a & 2) != 0) {
                this.d = randomAccessInput.readInt();
                this.e = randomAccessInput.readInt();
            }
            if ((this.a & 8) != 0) {
                this.g = randomAccessInput.readInt();
                this.f = (this.g & Integer.MIN_VALUE) != 0;
                this.g &= Integer.MAX_VALUE;
                this.h = randomAccessInput.readInt();
            }
            if ((this.a & 0x20) != 0) {
                this.i = randomAccessInput.readInt();
                this.j = randomAccessInput.readInt();
                this.k = randomAccessInput.readInt();
                this.l = randomAccessInput.readInt();
            }
        }

        void a(DataOutput dataOutput) throws IOException {
            block6: {
                block8: {
                    block7: {
                        if ((this.a & 1) != 0) {
                            dataOutput.writeInt(this.b);
                            dataOutput.writeInt(this.c);
                        }
                        if ((this.a & 2) != 0) {
                            dataOutput.writeInt(this.d);
                            dataOutput.writeInt(this.e);
                        }
                        if ((this.a & 8) == 0) break block6;
                        if (!this.f) break block7;
                        dataOutput.writeInt(this.g | Integer.MIN_VALUE);
                        if (!Box.i) break block8;
                    }
                    dataOutput.writeInt(this.g & Integer.MAX_VALUE);
                }
                dataOutput.writeInt(this.h);
            }
            if ((this.a & 0x20) != 0) {
                dataOutput.writeInt(this.i);
                dataOutput.writeInt(this.j);
                dataOutput.writeInt(this.k);
                dataOutput.writeInt(this.l);
            }
        }

        public int length() {
            int n2 = 0;
            if ((this.a & 1) != 0) {
                n2 += 8;
            }
            if ((this.a & 2) != 0) {
                n2 += 8;
            }
            if ((this.a & 8) != 0) {
                n2 += 8;
            }
            if ((this.a & 0x20) != 0) {
                n2 += 16;
            }
            return n2;
        }

        public int getXO() {
            return (this.a & 1) != 0 ? this.b : -1;
        }

        public int getYO() {
            return (this.a & 1) != 0 ? this.c : -1;
        }

        public int getWIDTH() {
            return (this.a & 2) != 0 ? this.d : -1;
        }

        public int getHEIGHT() {
            return (this.a & 2) != 0 ? this.e : -1;
        }

        public boolean isPERSIST() {
            return this.f;
        }

        public int getLIFE() {
            return (this.a & 8) != 0 ? this.g : -1;
        }

        public int getNEXT_USE() {
            return (this.a & 8) != 0 ? this.h : -1;
        }

        public int getXC() {
            return (this.a & 0x20) != 0 ? this.i : -1;
        }

        public int getYC() {
            return (this.a & 0x20) != 0 ? this.j : -1;
        }

        public int getWC() {
            return (this.a & 0x20) != 0 ? this.k : -1;
        }

        public int getHC() {
            return (this.a & 0x20) != 0 ? this.l : -1;
        }
    }

    public static class AnimationParameter {
        boolean a;
        int b;
        int c;

        public AnimationParameter(boolean bl, int n2, int n3) {
            this.a = bl;
            this.b = n2;
            this.c = n3;
        }
    }
}

