/*
 * Decompiled with CFR 0.152.
 */
package com.imagero.reader.jp2.box;

import com.imagero.reader.jp2.box.Box;
import com.imagero.reader.jp2.box.Signature;
import com.imagero.uio.RandomAccessInput;
import java.io.DataOutput;
import java.io.IOException;

public class DigitalSignatureBox
extends Box {
    public static final int SIGNATURE_TYPE_MD5 = 0;
    public static final int SIGNATURE_TYPE_SHA_1 = 1;
    public static final int SIGNATURE_TYPE_DSA = 2;
    public static final int SIGNATURE_TYPE_RSA_MD5 = 3;
    public static final int SIGNATURE_TYPE_RSA_SHA_1 = 4;
    public static final int SIGNATURE_TYPE_CMS = 5;
    public static final int SOURCE_POINTER_TYPE_FILE = 0;
    public static final int SOURCE_POINTER_TYPE_BOX = 1;
    byte j;
    byte k;
    long l;
    long m;
    byte[] n;

    public DigitalSignatureBox(byte by, long l2, long l3, byte[] byArray) {
        super(18 + byArray.length, Signature.DIGITAL_SIGNATURE);
        this.j = by;
        this.k = 1;
        this.l = l2;
        this.m = l3;
        this.n = byArray;
    }

    public DigitalSignatureBox(byte by, byte[] byArray) {
        super(1 + byArray.length, Signature.DIGITAL_SIGNATURE);
        this.j = by;
        this.n = byArray;
    }

    public DigitalSignatureBox(RandomAccessInput randomAccessInput) throws IOException {
        super(randomAccessInput);
    }

    public DigitalSignatureBox(RandomAccessInput randomAccessInput, long l2) throws IOException {
        super(randomAccessInput, l2);
    }

    protected void readData() throws IOException {
        this.j = this.rai.readByte();
        this.k = this.rai.readByte();
        if (this.k == 1) {
            this.l = this.rai.readLong();
            this.m = this.rai.readLong();
        }
        int n2 = (int)this.getDistance(this.rai.getFilePointer());
        this.n = new byte[n2];
        this.rai.readFully(this.n);
    }

    public void writeBox(DataOutput dataOutput) throws IOException {
        this.writeHeader(dataOutput);
        dataOutput.writeByte(this.j);
        dataOutput.writeByte(this.k);
        if (this.k == 1) {
            dataOutput.writeLong(this.l);
            dataOutput.writeLong(this.m);
        }
        dataOutput.write(this.n);
    }

    protected void checkSignature() throws IOException {
        this.assertEquals(Signature.DIGITAL_SIGNATURE);
    }

    public byte getSignatureType() {
        return this.j;
    }

    public byte getSourcePointerType() {
        return this.k;
    }

    public long getSourceDataOffset() {
        return this.k == 1 ? this.l : -1L;
    }

    public long getSourceDataLength() {
        return this.k == 1 ? this.m : -1L;
    }

    public byte[] getSignatureData() {
        return this.n;
    }
}

