/*
 * Decompiled with CFR 0.152.
 */
package com.imagero.reader.jp2.box;

import com.imagero.reader.jp2.box.Box;
import com.imagero.reader.jp2.box.FragmentListBox;
import com.imagero.reader.jp2.box.Signature;
import com.imagero.uio.RandomAccessInput;
import java.io.DataOutput;
import java.io.IOException;

public class CrossReferenceBox
extends Box {
    int j;
    FragmentListBox k;

    public CrossReferenceBox(int n2, FragmentListBox fragmentListBox) {
        super(4L + fragmentListBox.getLength(), Signature.CROSS_REFERENCE);
        this.j = n2;
        this.k = fragmentListBox;
    }

    public CrossReferenceBox(RandomAccessInput randomAccessInput) throws IOException {
        super(randomAccessInput);
    }

    public CrossReferenceBox(RandomAccessInput randomAccessInput, long l2) throws IOException {
        super(randomAccessInput, l2);
    }

    protected void checkSignature() throws IOException {
        this.assertEquals(Signature.CROSS_REFERENCE);
    }

    protected void readData() throws IOException {
        this.j = this.rai.readInt();
        this.k = new FragmentListBox(this.rai);
    }

    public void writeBox(DataOutput dataOutput) throws IOException {
        this.writeHeader(dataOutput);
        dataOutput.writeInt(this.j);
        this.k.writeBox(dataOutput);
    }

    public int getReferencedBoxType() {
        return this.j;
    }

    public FragmentListBox getFragmentListBox() {
        return this.k;
    }
}

