/*
 * Decompiled with CFR 0.152.
 */
package com.imagero.reader;

import com.imagero.reader.AbstractImageReader;
import com.imagero.reader.IOParameterBlock;
import com.imagero.reader.ImageReader;
import com.imagero.reader.bmp.BmpReader;
import com.imagero.reader.eps.EPSReader;
import com.imagero.reader.gif.GIFReader;
import com.imagero.reader.jng.JNGReader;
import com.imagero.reader.jpeg.JpegReader;
import com.imagero.reader.l;
import com.imagero.reader.mng.MNGReader;
import com.imagero.reader.n;
import com.imagero.reader.o;
import com.imagero.reader.png.PngReader;
import com.imagero.reader.ppm.PPMReader;
import com.imagero.reader.ps6.PSDReader;
import com.imagero.reader.q;
import com.imagero.reader.raw.crw.CR2Reader;
import com.imagero.reader.raw.crw.CRWReader;
import com.imagero.reader.raw.mrw.MRWReader;
import com.imagero.reader.tga.TargaReader;
import com.imagero.reader.tiff.TiffReader;
import com.imagero.uio.RandomAccessIO;
import com.imagero.uio.RandomAccessInput;
import com.imagero.uio.Sys;
import com.imagero.uio.UIOStreamBuilder;
import com.imagero.uio.bio.FixedSizeByteBuffer;
import com.imagero.uio.io.IOutils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.MalformedURLException;
import java.net.URL;

public class ReaderFactory {
    static final o a;
    public static final String BMP;
    public static final String PNG;
    public static final String JPEG;
    public static final String TIFF;
    public static final String GIF;
    public static final String JNG;
    public static final String MNG;
    public static final String CRW;
    public static final String PSD;
    public static final String PPM;
    public static final String MRW;
    public static final String EPS;
    public static final String TGA;
    private static String[] z;

    public static final o getLicenseType() {
        return a;
    }

    private static final o a() {
        o o2 = n.a();
        AbstractImageReader.putProperty(o2.toString(), o2);
        return o2;
    }

    public static final String getVersion() {
        return z[1];
    }

    public static final boolean isValidCodebase(URL uRL) {
        l l2 = l.m;
        if (z[18].equals(l2.g)) {
            return true;
        }
        String string = uRL.getHost();
        if (string == null || string.toLowerCase().indexOf(z[17]) >= 0) {
            return true;
        }
        String string2 = uRL.getProtocol();
        if (string2 == null || string2.indexOf(z[16]) < 0) {
            return true;
        }
        String string3 = l.b(l2.g);
        URL uRL2 = null;
        try {
            uRL2 = new URL(string3);
        }
        catch (MalformedURLException malformedURLException) {
            return false;
        }
        String string4 = uRL2.getHost();
        return string4 != null && string4.toLowerCase().equalsIgnoreCase(string);
    }

    public static ImageReader createReader(IOParameterBlock iOParameterBlock) throws IOException {
        Object object = iOParameterBlock.getSource();
        if (object == null) {
            throw new NullPointerException();
        }
        if (object instanceof String) {
            return ReaderFactory.createReader((String)object);
        }
        if (object instanceof File) {
            return ReaderFactory.createReader((File)object);
        }
        if (object instanceof URL) {
            return ReaderFactory.createReader((URL)object);
        }
        if (object instanceof InputStream) {
            return ReaderFactory.createReader((InputStream)object);
        }
        if (object instanceof byte[]) {
            return ReaderFactory.createReader((byte[])object);
        }
        if (object instanceof RandomAccessFile) {
            RandomAccessFile randomAccessFile = (RandomAccessFile)object;
            RandomAccessInput randomAccessInput = new UIOStreamBuilder(randomAccessFile).setBuffered(true).create();
            return ReaderFactory.createReader(randomAccessInput);
        }
        if (object instanceof RandomAccessInput) {
            return ReaderFactory.createReader((RandomAccessInput)object);
        }
        throw new IllegalArgumentException(z[0] + object.getClass().getName());
    }

    public static ImageReader createReader(String string) throws IOException {
        return ReaderFactory.createReader(new File(string));
    }

    public static ImageReader createReader(String string, boolean bl) throws IOException {
        return ReaderFactory.createReader(new File(string), bl);
    }

    public static ImageReader createReader(File file) throws IOException {
        return ReaderFactory.createReader(file, false);
    }

    public static ImageReader createReader(File file, boolean bl) throws IOException {
        Object object;
        String string = file.getName();
        String string2 = null;
        try {
            string2 = string.substring(string.lastIndexOf(".") + 1).toUpperCase();
        }
        catch (Exception exception) {}
        if (string2 != null && string2.length() >= 2) {
            object = ReaderFactory.a(file);
            if (string2.equals(BMP)) {
                if (BmpReader.canRead((byte[])object)) {
                    return new BmpReader(file, bl);
                }
            } else if (string2.equals(PNG)) {
                if (PngReader.canRead((byte[])object)) {
                    return new PngReader(file, bl);
                }
            } else if (string2.equals(z[10]) || string2.equals(TIFF) || string2.equals(z[4]) || string2.equals(z[8]) || string2.equals(z[7])) {
                if (TiffReader.canRead((byte[])object)) {
                    return new TiffReader(file, bl);
                }
            } else if (string2.equals(z[5]) || string2.equals(z[2]) || string2.equals(JPEG) || string2.equals(z[3])) {
                if (JpegReader.canRead((byte[])object)) {
                    return new JpegReader(file, bl, 1);
                }
            } else if (string2.equals(JNG)) {
                if (JNGReader.canRead((byte[])object)) {
                    return new JNGReader(file, bl);
                }
            } else if (string2.equals(GIF)) {
                if (GIFReader.canRead((byte[])object)) {
                    return new GIFReader(file, bl);
                }
            } else if (string2.equals(MNG)) {
                if (MNGReader.canRead((byte[])object)) {
                    return new MNGReader(file);
                }
            } else if (string2.equals(CRW)) {
                if (CRWReader.canRead((byte[])object)) {
                    return new CRWReader(file);
                }
            } else if (string2.equals(PSD)) {
                if (PSDReader.canRead((byte[])object)) {
                    return new PSDReader(file, bl);
                }
            } else if (string2.equals(z[9]) || string2.equals(z[14]) || string2.equals(PPM)) {
                if (PPMReader.canRead((byte[])object)) {
                    return new PPMReader(file, bl);
                }
            } else if (string2.equals(MRW)) {
                if (MRWReader.canRead((byte[])object)) {
                    return new MRWReader(file);
                }
            } else if (string2.equals(z[11])) {
                if (CR2Reader.canRead((byte[])object)) {
                    return new CR2Reader(file);
                }
            } else if (string2.equals(EPS) || string2.equals(z[13]) || string2.equals(z[15]) || string2.equals(z[6]) || string2.equals(z[12])) {
                if (EPSReader.canRead((byte[])object)) {
                    return new EPSReader(file, bl);
                }
            } else if (string2.equals(TGA)) {
                byte[] byArray = ReaderFactory.b(file);
                byte[] byArray2 = new byte[((Object)object).length + byArray.length];
                System.arraycopy(object, 0, byArray2, 0, ((Object)object).length);
                System.arraycopy(byArray, 0, byArray2, ((Object)object).length, byArray.length);
                if (TargaReader.canRead(byArray2)) {
                    return new TargaReader(file, bl);
                }
            }
        }
        if ((object = ReaderFactory.identify(file)) != null) {
            if (object == BMP) {
                return new BmpReader(file, bl);
            }
            if (object == CRW) {
                return new CRWReader(file);
            }
            if (object == EPS) {
                return new EPSReader(file, bl);
            }
            if (object == JNG) {
                return new JNGReader(file, bl);
            }
            if (object == JPEG) {
                return new JpegReader(file, bl, 1);
            }
            if (object == GIF) {
                return new GIFReader(file, bl);
            }
            if (object == MNG) {
                return new MNGReader(file, bl);
            }
            if (((String)object).equals(MRW)) {
                return new MRWReader(file);
            }
            if (object == PNG) {
                return new PngReader(file, bl);
            }
            if (object == PPM) {
                return new PPMReader(file, bl);
            }
            if (object == PSD) {
                return new PSDReader(file, bl);
            }
            if (object == TGA) {
                return new TargaReader(file, bl);
            }
            if (object == TIFF) {
                return new TiffReader(file, bl);
            }
        } else if (TGA.equals(string2)) {
            return new TargaReader(file, bl);
        }
        return null;
    }

    public static ImageReader createReader(byte[] byArray) throws IOException {
        if (BmpReader.canRead(byArray)) {
            return new BmpReader(byArray);
        }
        if (PngReader.canRead(byArray)) {
            return new PngReader(byArray);
        }
        if (JpegReader.canRead(byArray)) {
            return new JpegReader(byArray);
        }
        if (TiffReader.canRead(byArray)) {
            return new TiffReader(byArray);
        }
        if (GIFReader.canRead(byArray)) {
            return new GIFReader(byArray);
        }
        if (JNGReader.canRead(byArray)) {
            return new JNGReader(byArray);
        }
        if (MNGReader.canRead(byArray)) {
            return new MNGReader(byArray);
        }
        if (CRWReader.canRead(byArray)) {
            return new CRWReader(byArray);
        }
        if (PSDReader.canRead(byArray)) {
            return new PSDReader(byArray);
        }
        if (PPMReader.canRead(byArray)) {
            return new PPMReader(byArray);
        }
        if (MRWReader.canRead(byArray)) {
            return new MRWReader(byArray);
        }
        if (EPSReader.canRead(byArray)) {
            return new EPSReader(byArray);
        }
        if (TargaReader.canRead(byArray)) {
            return new TargaReader(byArray);
        }
        return null;
    }

    public static ImageReader createReader(byte[] byArray, int n2, int n3) throws IOException {
        FixedSizeByteBuffer fixedSizeByteBuffer = FixedSizeByteBuffer.createBuffer(byArray);
        RandomAccessIO randomAccessIO = fixedSizeByteBuffer.create(n2, n3);
        return ReaderFactory.createReader(randomAccessIO);
    }

    public static ImageReader createReader(InputStream inputStream) throws IOException {
        RandomAccessInput randomAccessInput = new UIOStreamBuilder(inputStream).create();
        return ReaderFactory.createReader(randomAccessInput);
    }

    public static ImageReader createReader(InputStream inputStream, File file) throws IOException {
        RandomAccessInput randomAccessInput = new UIOStreamBuilder(inputStream).setCacheFile(file).create();
        return ReaderFactory.createReader(randomAccessInput);
    }

    public static ImageReader createReader(URL uRL) throws IOException {
        RandomAccessInput randomAccessInput = new UIOStreamBuilder(uRL).create();
        return ReaderFactory.createReader(randomAccessInput);
    }

    public static ImageReader createReader(URL uRL, File file) throws IOException {
        RandomAccessInput randomAccessInput = new UIOStreamBuilder(uRL).setCacheFile(file).create();
        return ReaderFactory.createReader(randomAccessInput);
    }

    public static ImageReader createReader(RandomAccessInput randomAccessInput) throws IOException {
        byte[] byArray = new byte[(int)Math.min(50L, randomAccessInput.length())];
        randomAccessInput.readFully(byArray);
        randomAccessInput.seek(0L);
        if (BmpReader.canRead(byArray)) {
            randomAccessInput.setByteOrder(18761);
            return new BmpReader(randomAccessInput);
        }
        if (PngReader.canRead(byArray)) {
            return new PngReader(randomAccessInput);
        }
        if (JpegReader.canRead(byArray)) {
            return new JpegReader(randomAccessInput);
        }
        if (TiffReader.canRead(byArray)) {
            return new TiffReader(randomAccessInput);
        }
        if (GIFReader.canRead(byArray)) {
            randomAccessInput.setByteOrder(18761);
            return new GIFReader(randomAccessInput);
        }
        if (JNGReader.canRead(byArray)) {
            return new JNGReader(randomAccessInput);
        }
        if (MNGReader.canRead(byArray)) {
            return new MNGReader(randomAccessInput);
        }
        if (CRWReader.canRead(byArray)) {
            return new CRWReader(randomAccessInput);
        }
        if (PSDReader.canRead(byArray)) {
            return new PSDReader(randomAccessInput);
        }
        if (PPMReader.canRead(byArray)) {
            return new PPMReader(randomAccessInput);
        }
        if (MRWReader.canRead(byArray)) {
            return new MRWReader(randomAccessInput);
        }
        if (EPSReader.canRead(byArray)) {
            return new EPSReader(randomAccessInput);
        }
        long l2 = randomAccessInput.length() - 50L;
        randomAccessInput.seek(l2);
        randomAccessInput.readFully(byArray);
        randomAccessInput.seek(0L);
        if (TargaReader.canRead(byArray)) {
            return new TargaReader(randomAccessInput);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String identify(File file) {
        String string;
        RandomAccessInput randomAccessInput = null;
        try {
            try {
                randomAccessInput = new UIOStreamBuilder(file).create();
                string = ReaderFactory.identify(randomAccessInput);
                Object var4_3 = null;
            }
            catch (IOException iOException) {
                Sys.err.println(iOException.getMessage());
                Object var4_4 = null;
                IOutils.closeStream(randomAccessInput);
                return null;
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            IOutils.closeStream(randomAccessInput);
            throw throwable;
        }
        IOutils.closeStream(randomAccessInput);
        return string;
    }

    public static String identify(RandomAccessInput randomAccessInput) {
        try {
            byte[] byArray = new byte[(int)Math.min(50L, randomAccessInput.length())];
            randomAccessInput.seek(0L);
            randomAccessInput.readFully(byArray);
            String string = ReaderFactory.identify(byArray);
            if (string != null) {
                return string;
            }
            long l2 = randomAccessInput.length() - 50L;
            if (l2 >= 0L) {
                randomAccessInput.seek(l2);
                randomAccessInput.readFully(byArray);
                if (TargaReader.canRead(byArray)) {
                    return TGA;
                }
            }
        }
        catch (IOException iOException) {
            Sys.err.println(iOException.getMessage());
        }
        return null;
    }

    public static String identify(byte[] byArray) {
        if (byArray == null || byArray.length < 2) {
            return null;
        }
        if (BmpReader.canRead(byArray)) {
            return BMP;
        }
        if (PngReader.canRead(byArray)) {
            return PNG;
        }
        if (JpegReader.canRead(byArray)) {
            return JPEG;
        }
        if (TiffReader.canRead(byArray)) {
            return TIFF;
        }
        if (GIFReader.canRead(byArray)) {
            return GIF;
        }
        if (JNGReader.canRead(byArray)) {
            return JNG;
        }
        if (MNGReader.canRead(byArray)) {
            return MNG;
        }
        if (CRWReader.canRead(byArray)) {
            return CRW;
        }
        if (PSDReader.canRead(byArray)) {
            return PSD;
        }
        if (PPMReader.canRead(byArray)) {
            return PPM;
        }
        if (MRWReader.canRead(byArray)) {
            return MRW;
        }
        if (EPSReader.canRead(byArray)) {
            return EPS;
        }
        if (TargaReader.canRead(byArray)) {
            return TGA;
        }
        return null;
    }

    private static final byte[] a(File file) {
        byte[] byArray = new byte[50];
        FileInputStream fileInputStream = null;
        try {
            try {
                fileInputStream = new FileInputStream(file);
                IOutils.readFully(fileInputStream, byArray);
            }
            catch (IOException iOException) {
            }
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            IOutils.closeStream(fileInputStream);
            throw throwable;
        }
        IOutils.closeStream(fileInputStream);
        return byArray;
    }

    private static final byte[] b(File file) {
        byte[] byArray = new byte[50];
        RandomAccessFile randomAccessFile = null;
        try {
            try {
                randomAccessFile = new RandomAccessFile(file, "r");
                randomAccessFile.seek(file.length() - (long)byArray.length);
                randomAccessFile.readFully(byArray);
            }
            catch (IOException iOException) {
            }
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            IOutils.closeStream(randomAccessFile);
            throw throwable;
        }
        IOutils.closeStream(randomAccessFile);
        return byArray;
    }

    static {
        String[] stringArray = new String[19];
        Object var0 = null;
        CRW = ReaderFactory.z(ReaderFactory.z("\u00130Q"));
        var0 = null;
        PPM = ReaderFactory.z(ReaderFactory.z("\u00002K"));
        var0 = null;
        TGA = ReaderFactory.z(ReaderFactory.z("\u0004%G"));
        var0 = null;
        GIF = ReaderFactory.z(ReaderFactory.z("\u0017+@"));
        var0 = null;
        EPS = ReaderFactory.z(ReaderFactory.z("\u00152U"));
        var0 = null;
        PNG = ReaderFactory.z(ReaderFactory.z("\u0000,A"));
        var0 = null;
        JNG = ReaderFactory.z(ReaderFactory.z("\u001a,A"));
        var0 = null;
        JPEG = ReaderFactory.z(ReaderFactory.z("\u001a2C\u0014"));
        var0 = null;
        TIFF = ReaderFactory.z(ReaderFactory.z("\u0004+@\u0015"));
        var0 = null;
        BMP = ReaderFactory.z(ReaderFactory.z("\u0012/V"));
        var0 = null;
        PSD = ReaderFactory.z(ReaderFactory.z("\u00001B"));
        var0 = null;
        MRW = ReaderFactory.z(ReaderFactory.z("\u001d0Q"));
        var0 = null;
        MNG = ReaderFactory.z(ReaderFactory.z("\u001d,A"));
        var0 = null;
        stringArray[0] = ReaderFactory.z(ReaderFactory.z("\u0005\fm=\u001f'\f& \u001f%\u0010e6J"));
        var0 = null;
        stringArray[1] = ReaderFactory.z(ReaderFactory.z("bL6s\"\u0013W"));
        var0 = null;
        stringArray[2] = ReaderFactory.z(ReaderFactory.z("\u001a2C"));
        var0 = null;
        stringArray[3] = ReaderFactory.z(ReaderFactory.z("\u0004*K"));
        var0 = null;
        stringArray[4] = ReaderFactory.z(ReaderFactory.z("\u0014!T"));
        var0 = null;
        stringArray[5] = ReaderFactory.z(ReaderFactory.z("\u001a2A"));
        var0 = null;
        stringArray[6] = ReaderFactory.z(ReaderFactory.z("\u00152U\u0015"));
        var0 = null;
        stringArray[7] = ReaderFactory.z(ReaderFactory.z("\u0014,A"));
        var0 = null;
        stringArray[8] = ReaderFactory.z(ReaderFactory.z("\u001e'@"));
        var0 = null;
        stringArray[9] = ReaderFactory.z(ReaderFactory.z("\u0000 K"));
        var0 = null;
        stringArray[10] = ReaderFactory.z(ReaderFactory.z("\u0004+@"));
        var0 = null;
        stringArray[11] = ReaderFactory.z(ReaderFactory.z("\u001304"));
        var0 = null;
        stringArray[12] = ReaderFactory.z(ReaderFactory.z("\u0011+"));
        var0 = null;
        stringArray[13] = ReaderFactory.z(ReaderFactory.z("\u00152O"));
        var0 = null;
        stringArray[14] = ReaderFactory.z(ReaderFactory.z("\u0000%K"));
        var0 = null;
        stringArray[15] = ReaderFactory.z(ReaderFactory.z("\u00152U\u001a"));
        var0 = null;
        stringArray[16] = ReaderFactory.z(ReaderFactory.z("8\u0016r#"));
        var0 = null;
        stringArray[17] = ReaderFactory.z(ReaderFactory.z("<\re2\u001c8\ru'"));
        var0 = null;
        stringArray[18] = ReaderFactory.z(ReaderFactory.z("\u000173\t&\u0006(K"));
        z = stringArray;
        var0 = null;
        if (System.getProperty(ReaderFactory.z(ReaderFactory.z("9\u000fg4\u0015\"\r(?\u00193\u0007h \u0015~\u0001j2\u0003#"))) == null) {
            AbstractImageReader.install(new q().getClass());
        }
        a = ReaderFactory.a();
    }

    private static char[] z(String string) {
        char[] cArray;
        block1: {
            int n2;
            char[] cArray2 = string.toCharArray();
            char[] cArray3 = cArray2;
            char[] cArray4 = cArray2;
            do {
                int n3 = cArray3.length;
                cArray = cArray4;
                n2 = n3;
                if (n3 >= 2) break block1;
                cArray4 = cArray;
                cArray3 = cArray;
            } while (n2 == 0);
            cArray = cArray4;
            n2 = 0;
            cArray3[0] = (char)(cArray3[0] ^ 0x70);
        }
        return cArray;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    private static String z(char[] cArray) {
        char[] cArray2;
        block10: {
            int n2;
            int n3;
            char[] cArray3;
            int n4;
            block9: {
                n4 = 0;
                int n5 = cArray.length;
                cArray3 = cArray;
                n3 = n5;
                if (n5 <= 1) break block9;
                cArray2 = cArray3;
                n2 = n3;
                if (n3 <= n4) break block10;
            }
            do {
                char[] cArray4 = cArray3;
                char[] cArray5 = cArray3;
                int n6 = n4;
                while (true) {
                    int n7;
                    char c2 = cArray4[n6];
                    switch (n4 % 5) {
                        case 0: {
                            n7 = 80;
                            break;
                        }
                        case 1: {
                            n7 = 98;
                            break;
                        }
                        case 2: {
                            n7 = 6;
                            break;
                        }
                        case 3: {
                            n7 = 83;
                            break;
                        }
                        default: {
                            n7 = 112;
                        }
                    }
                    cArray4[n6] = (char)(c2 ^ n7);
                    ++n4;
                    cArray3 = cArray5;
                    n3 = n3;
                    if (n3 != 0) break;
                    cArray5 = cArray3;
                    n2 = n3;
                    n6 = n3;
                    cArray4 = cArray3;
                }
                cArray2 = cArray3;
                n2 = n3;
            } while (n3 > n4);
        }
        return new String(cArray2).intern();
    }
}

