/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xmp.impl;

import com.adobe.xmp.XMPException;
import com.adobe.xmp.XMPMeta;
import com.adobe.xmp.impl.ByteBuffer;
import com.adobe.xmp.impl.FixASCIIControlsReader;
import com.adobe.xmp.impl.Latin1Converter;
import com.adobe.xmp.impl.ParameterAsserts;
import com.adobe.xmp.impl.ParseRDF;
import com.adobe.xmp.impl.XMPMetaImpl;
import com.adobe.xmp.impl.XMPNormalizer;
import com.adobe.xmp.options.ParseOptions;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMPMetaParser {
    private static final Object XMP_RDF = new Object();
    private static DocumentBuilderFactory factory = XMPMetaParser.createDocumentBuilderFactory();

    private XMPMetaParser() {
    }

    public static XMPMeta parse(Object input, ParseOptions options) throws XMPException {
        ParameterAsserts.assertNotNull(input);
        options = options != null ? options : new ParseOptions();
        Document document = XMPMetaParser.parseXml(input, options);
        boolean xmpmetaRequired = options.getRequireXMPMeta();
        Object[] result = XMPMetaParser.findRootNode(document, xmpmetaRequired);
        if (result != null && result[1] == XMP_RDF) {
            XMPMetaImpl xmp = ParseRDF.parse((Node)result[0]);
            return XMPNormalizer.process(xmp, options);
        }
        return new XMPMetaImpl();
    }

    private static Document parseXml(Object input, ParseOptions options) throws XMPException {
        if (input instanceof InputStream) {
            return XMPMetaParser.parseXmlFromInputStream((InputStream)input, options);
        }
        if (input instanceof byte[]) {
            return XMPMetaParser.parseXmlFromBytebuffer(new ByteBuffer((byte[])input), options);
        }
        return XMPMetaParser.parseXmlFromString((String)input, options);
    }

    private static Document parseXmlFromInputStream(InputStream stream, ParseOptions options) throws XMPException {
        if (!options.getAcceptLatin1() && !options.getFixControlChars()) {
            return XMPMetaParser.parseInputSource(new InputSource(stream));
        }
        try {
            ByteBuffer buffer = new ByteBuffer(stream);
            return XMPMetaParser.parseXmlFromBytebuffer(buffer, options);
        }
        catch (IOException e2) {
            throw new XMPException("Error reading the XML-file", 204, e2);
        }
    }

    private static Document parseXmlFromBytebuffer(ByteBuffer buffer, ParseOptions options) throws XMPException {
        InputSource source = new InputSource(buffer.getByteStream());
        try {
            return XMPMetaParser.parseInputSource(source);
        }
        catch (XMPException e2) {
            if (e2.getErrorCode() == 201) {
                if (options.getAcceptLatin1()) {
                    buffer = Latin1Converter.convert(buffer);
                }
                if (options.getFixControlChars()) {
                    try {
                        String encoding = buffer.getEncoding();
                        FixASCIIControlsReader fixReader = new FixASCIIControlsReader(new InputStreamReader(buffer.getByteStream(), encoding));
                        return XMPMetaParser.parseInputSource(new InputSource(fixReader));
                    }
                    catch (UnsupportedEncodingException e1) {
                        throw new XMPException("Unsupported Encoding", 9, e2);
                    }
                }
                source = new InputSource(buffer.getByteStream());
                return XMPMetaParser.parseInputSource(source);
            }
            throw e2;
        }
    }

    private static Document parseXmlFromString(String input, ParseOptions options) throws XMPException {
        InputSource source = new InputSource(new StringReader(input));
        try {
            return XMPMetaParser.parseInputSource(source);
        }
        catch (XMPException e2) {
            if (e2.getErrorCode() == 201 && options.getFixControlChars()) {
                source = new InputSource(new FixASCIIControlsReader(new StringReader(input)));
                return XMPMetaParser.parseInputSource(source);
            }
            throw e2;
        }
    }

    private static Document parseInputSource(InputSource source) throws XMPException {
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setErrorHandler(null);
            return builder.parse(source);
        }
        catch (SAXException e2) {
            throw new XMPException("XML parsing failure", 201, e2);
        }
        catch (ParserConfigurationException e3) {
            throw new XMPException("XML Parser not correctly configured", 0, e3);
        }
        catch (IOException e4) {
            throw new XMPException("Error reading the XML-file", 204, e4);
        }
    }

    private static Object[] findRootNode(Node root, boolean xmpmetaRequired) {
        NodeList children = root.getChildNodes();
        for (int i2 = 0; i2 < children.getLength(); ++i2) {
            root = children.item(i2);
            if (3 == root.getNodeType() || 7 == root.getNodeType()) continue;
            String rootNS = root.getNamespaceURI();
            String rootLocal = root.getLocalName();
            if (("xmpmeta".equals(rootLocal) || "xapmeta".equals(rootLocal)) && "adobe:ns:meta/".equals(rootNS)) {
                return XMPMetaParser.findRootNode(root, false);
            }
            if (!xmpmetaRequired && "RDF".equals(rootLocal) && "http://www.w3.org/1999/02/22-rdf-syntax-ns#".equals(rootNS)) {
                return new Object[]{root, XMP_RDF};
            }
            Object[] result = XMPMetaParser.findRootNode(root, xmpmetaRequired);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private static DocumentBuilderFactory createDocumentBuilderFactory() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setIgnoringComments(true);
        factory.setExpandEntityReferences(true);
        return factory;
    }
}

