/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xmp.impl;

import com.adobe.xmp.XMPDateTime;
import com.adobe.xmp.XMPException;
import com.adobe.xmp.impl.ISO8601Converter;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class XMPDateTimeImpl
implements XMPDateTime {
    private int year = 0;
    private int month = 0;
    private int day = 0;
    private int hour = 0;
    private int minute = 0;
    private int second = 0;
    private TimeZone timeZone = TimeZone.getTimeZone("UTC");
    private int nanoSeconds;

    public XMPDateTimeImpl() {
    }

    public XMPDateTimeImpl(Calendar calendar) {
        this.year = calendar.get(1);
        this.month = calendar.get(2) + 1;
        this.day = calendar.get(5);
        this.hour = calendar.get(11);
        this.minute = calendar.get(12);
        this.second = calendar.get(13);
        this.nanoSeconds = calendar.get(14) * 1000000;
        this.timeZone = calendar.getTimeZone();
    }

    public XMPDateTimeImpl(String strValue) throws XMPException {
        ISO8601Converter.parse(strValue, this);
    }

    public int getYear() {
        return this.year;
    }

    public void setYear(int year) {
        this.year = Math.min(Math.abs(year), 9999);
    }

    public int getMonth() {
        return this.month;
    }

    public void setMonth(int month) {
        this.month = month < 1 ? 1 : (month > 12 ? 12 : month);
    }

    public int getDay() {
        return this.day;
    }

    public void setDay(int day) {
        this.day = day < 1 ? 1 : (day > 31 ? 31 : day);
    }

    public int getHour() {
        return this.hour;
    }

    public void setHour(int hour) {
        this.hour = Math.min(Math.abs(hour), 23);
    }

    public int getMinute() {
        return this.minute;
    }

    public void setMinute(int minute) {
        this.minute = Math.min(Math.abs(minute), 59);
    }

    public int getSecond() {
        return this.second;
    }

    public void setSecond(int second) {
        this.second = Math.min(Math.abs(second), 59);
    }

    public int getNanoSecond() {
        return this.nanoSeconds;
    }

    public void setNanoSecond(int nanoSecond) {
        this.nanoSeconds = nanoSecond;
    }

    public int compareTo(Object dt) {
        long d2 = this.getCalendar().getTimeInMillis() - ((XMPDateTime)dt).getCalendar().getTimeInMillis();
        if (d2 != 0L) {
            return (int)(d2 % 2L);
        }
        d2 = this.nanoSeconds - ((XMPDateTime)dt).getNanoSecond();
        return (int)(d2 % 2L);
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public Calendar getCalendar() {
        GregorianCalendar calendar = new GregorianCalendar(this.year, this.month - 1, this.day, this.hour, this.minute, this.second);
        calendar.set(14, this.nanoSeconds / 1000000);
        ((Calendar)calendar).setTimeZone(this.timeZone);
        return calendar;
    }

    public String getISO8601String() {
        return ISO8601Converter.render(this);
    }

    public String toString() {
        return this.getISO8601String();
    }
}

