/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xmp;

import com.adobe.xmp.XMPException;
import com.adobe.xmp.XMPMeta;
import com.adobe.xmp.XMPSchemaRegistry;
import com.adobe.xmp.XMPVersionInfo;
import com.adobe.xmp.impl.XMPMetaImpl;
import com.adobe.xmp.impl.XMPMetaParser;
import com.adobe.xmp.impl.XMPSchemaRegistryImpl;
import com.adobe.xmp.impl.XMPSerializerHelper;
import com.adobe.xmp.options.ParseOptions;
import com.adobe.xmp.options.SerializeOptions;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;

public final class XMPMetaFactory {
    private static XMPSchemaRegistry schema = new XMPSchemaRegistryImpl();
    private static XMPVersionInfo versionInfo = null;
    static /* synthetic */ Class class$com$adobe$xmp$XMPMetaFactory;

    private XMPMetaFactory() {
    }

    public static XMPSchemaRegistry getSchemaRegistry() {
        return schema;
    }

    public static XMPMeta create() {
        return new XMPMetaImpl();
    }

    public static XMPMeta parse(InputStream in) throws XMPException {
        return XMPMetaFactory.parse(in, null);
    }

    public static XMPMeta parse(InputStream in, ParseOptions options) throws XMPException {
        return XMPMetaParser.parse(in, options);
    }

    public static XMPMeta parseFromString(String packet) throws XMPException {
        return XMPMetaFactory.parseFromString(packet, null);
    }

    public static XMPMeta parseFromString(String packet, ParseOptions options) throws XMPException {
        return XMPMetaParser.parse(packet, options);
    }

    public static XMPMeta parseFromBuffer(byte[] buffer) throws XMPException {
        return XMPMetaFactory.parseFromBuffer(buffer, null);
    }

    public static XMPMeta parseFromBuffer(byte[] buffer, ParseOptions options) throws XMPException {
        return XMPMetaParser.parse(buffer, options);
    }

    public static void serialize(XMPMeta xmp, OutputStream out) throws XMPException {
        XMPMetaFactory.serialize(xmp, out, null);
    }

    public static void serialize(XMPMeta xmp, OutputStream out, SerializeOptions options) throws XMPException {
        XMPMetaFactory.assertImplementation(xmp);
        XMPSerializerHelper.serialize((XMPMetaImpl)xmp, out, options);
    }

    public static byte[] serializeToBuffer(XMPMeta xmp, SerializeOptions options) throws XMPException {
        XMPMetaFactory.assertImplementation(xmp);
        return XMPSerializerHelper.serializeToBuffer((XMPMetaImpl)xmp, options);
    }

    public static String serializeToString(XMPMeta xmp, SerializeOptions options) throws XMPException {
        XMPMetaFactory.assertImplementation(xmp);
        return XMPSerializerHelper.serializeToString((XMPMetaImpl)xmp, options);
    }

    private static void assertImplementation(XMPMeta xmp) {
        if (!(xmp instanceof XMPMetaImpl)) {
            throw new UnsupportedOperationException("The serializing service works onlywith the XMPMeta implementation of this library");
        }
    }

    public static void reset() {
        schema = new XMPSchemaRegistryImpl();
    }

    public static XMPVersionInfo getVersionInfo() {
        if (versionInfo == null) {
            try {
                Properties versProperties = new Properties();
                versProperties.load((class$com$adobe$xmp$XMPMetaFactory == null ? (class$com$adobe$xmp$XMPMetaFactory = XMPMetaFactory.class$("com.adobe.xmp.XMPMetaFactory")) : class$com$adobe$xmp$XMPMetaFactory).getResourceAsStream("version.properties"));
                final int major = Integer.parseInt(versProperties.getProperty("implementation.version.major"));
                final int minor = Integer.parseInt(versProperties.getProperty("implementation.version.minor"));
                final int micro = Integer.parseInt(versProperties.getProperty("implementation.version.micro"));
                final boolean debug = Boolean.valueOf(versProperties.getProperty("implementation.version.debug"));
                final String message = versProperties.getProperty("implementation.version");
                final int engBuild = Integer.parseInt(versProperties.getProperty("implementation.version.engbuild"));
                versionInfo = new XMPVersionInfo(){

                    public int getMajor() {
                        return major;
                    }

                    public int getMinor() {
                        return minor;
                    }

                    public int getMicro() {
                        return micro;
                    }

                    public boolean isDebug() {
                        return debug;
                    }

                    public int getBuild() {
                        return engBuild;
                    }

                    public String getMessage() {
                        return message;
                    }

                    public String toString() {
                        return message;
                    }
                };
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return versionInfo;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

