/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xmp;

import com.adobe.xmp.XMPDateTime;
import com.adobe.xmp.XMPException;
import com.adobe.xmp.impl.XMPDateTimeImpl;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public final class XMPDateTimeFactory {
    private XMPDateTimeFactory() {
    }

    public static XMPDateTime createFromCalendar(Calendar calendar) {
        return new XMPDateTimeImpl(calendar);
    }

    public static XMPDateTime create(int year, int month, int day, int hour, int minute, int second, int nanoSecond) {
        XMPDateTimeImpl dt = new XMPDateTimeImpl();
        dt.setYear(year);
        dt.setMonth(month);
        dt.setDay(day);
        dt.setHour(hour);
        dt.setMinute(minute);
        dt.setSecond(second);
        dt.setNanoSecond(nanoSecond);
        return dt;
    }

    public static XMPDateTime createFromISO8601(String strValue) throws XMPException {
        return new XMPDateTimeImpl(strValue);
    }

    public static XMPDateTime getCurrentDateTime() {
        return new XMPDateTimeImpl(new GregorianCalendar());
    }

    public static XMPDateTime setLocalTimeZone(XMPDateTime dateTime) {
        Calendar cal = dateTime.getCalendar();
        cal.setTimeZone(TimeZone.getDefault());
        return new XMPDateTimeImpl(cal);
    }

    public static XMPDateTime convertToUTCTime(XMPDateTime dateTime) {
        Calendar cal = dateTime.getCalendar();
        cal.setTimeZone(TimeZone.getTimeZone("UTC"));
        return new XMPDateTimeImpl(cal);
    }

    public static XMPDateTime convertToLocalTime(XMPDateTime dateTime) {
        Calendar cal = dateTime.getCalendar();
        cal.setTimeZone(TimeZone.getDefault());
        return new XMPDateTimeImpl(cal);
    }
}

