/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.domain.wordsets;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.jphototagger.lib.util.ObjectUtil;
import org.jphototagger.lib.util.StringUtil;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public final class Wordset {
    private long id = Integer.MIN_VALUE;
    private String name;
    @XmlElementWrapper(name="words")
    @XmlElement(type=String.class, name="word")
    private final List<String> words = new ArrayList<String>();
    @XmlTransient
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public Wordset() {
        this("Invalid Wordset");
    }

    public Wordset(String name) {
        if (!StringUtil.hasContent((String)name)) {
            throw new IllegalArgumentException("Name must be defined and not empty: " + name);
        }
        this.name = name;
    }

    public void setName(String name) {
        String old = this.name;
        this.name = name;
        this.propertyChangeSupport.firePropertyChange("name", old, this.name);
    }

    public String getName() {
        return this.name;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        Long old = this.id;
        this.id = id;
        this.propertyChangeSupport.firePropertyChange("id", old, this.id);
    }

    public void setWords(List<? extends String> words) {
        this.words.clear();
        if (words != null) {
            this.words.addAll(words);
            this.propertyChangeSupport.firePropertyChange("words", null, this.words);
        }
    }

    public List<String> getWords() {
        LinkedList<String> sortedWords = new LinkedList<String>(this.words);
        Collections.sort(sortedWords);
        return sortedWords;
    }

    public boolean addToWords(String word) {
        boolean added;
        if (StringUtil.hasContent((String)word) && !this.words.contains(word) && (added = this.words.add(word))) {
            this.propertyChangeSupport.firePropertyChange("words", null, this.words);
            return true;
        }
        return false;
    }

    public boolean addToWords(Collection<? extends String> words) {
        if (words == null) {
            throw new NullPointerException("words == null");
        }
        boolean added = this.words.addAll(words);
        if (added) {
            this.propertyChangeSupport.firePropertyChange("words", null, this.words);
        }
        return added;
    }

    public boolean removeFromWords(String word) {
        if (word == null) {
            throw new NullPointerException("word == null");
        }
        boolean removed = this.words.remove(word);
        if (removed) {
            this.propertyChangeSupport.firePropertyChange("words", null, this.words);
        }
        return removed;
    }

    public boolean removeFromWords(Collection<? extends String> words) {
        if (words == null) {
            throw new NullPointerException("words == null");
        }
        boolean removed = this.words.removeAll(words);
        if (removed) {
            this.propertyChangeSupport.firePropertyChange("words", null, this.words);
        }
        return removed;
    }

    public boolean updateWord(String oldWord, String newWord) {
        boolean set;
        if (oldWord == null) {
            throw new NullPointerException("oldWord == null");
        }
        if (newWord == null) {
            throw new NullPointerException("newWord == null");
        }
        if (newWord.equals(oldWord)) {
            return false;
        }
        int oldWordIndex = this.words.indexOf(oldWord);
        if (oldWordIndex >= 0 && (set = this.words.set(oldWordIndex, newWord).equals(oldWord))) {
            this.propertyChangeSupport.firePropertyChange("words", null, this.words);
            return true;
        }
        return false;
    }

    public void clear() {
        this.words.clear();
        this.propertyChangeSupport.firePropertyChange("words", null, this.words);
    }

    public boolean containsWord(String word) {
        if (word == null) {
            throw new NullPointerException("word == null");
        }
        return this.words.contains(word);
    }

    public int getWordCount() {
        return this.words.size();
    }

    public boolean isEmpty() {
        return this.words.isEmpty();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public String toString() {
        return this.name == null ? "Wordset ?" : this.name;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Wordset)) {
            return false;
        }
        Wordset other = (Wordset)obj;
        return ObjectUtil.equals((Object)this.name, (Object)other.name) && ObjectUtil.equals(this.words, other.words);
    }

    public int hashCode() {
        int hash = 7;
        hash = 61 * hash + (this.name != null ? this.name.hashCode() : 0);
        hash = 61 * hash + (this.words != null ? this.words.hashCode() : 0);
        return hash;
    }
}

