/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.domain.timeline;

import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jphototagger.lib.swing.SortedChildrenTreeNode;
import org.jphototagger.lib.swing.UpdateInfoTreeModel;
import org.jphototagger.lib.util.Bundle;

public final class Timeline {
    private final DefaultMutableTreeNode ROOT_NODE = new SortedChildrenTreeNode((Object)Bundle.getString(Timeline.class, (String)"Timeline.RootNode.DisplayName", (Object[])new Object[0]));
    private static final DefaultMutableTreeNode UNKNOWN_NODE = new SortedChildrenTreeNode((Object)Bundle.getString(Timeline.class, (String)"Timeline.UnknownNode.DisplayName", (Object[])new Object[0]));
    private boolean unknownNode;

    public DefaultMutableTreeNode getRoot() {
        return this.ROOT_NODE;
    }

    public static DefaultMutableTreeNode getUnknownNode() {
        return UNKNOWN_NODE;
    }

    public synchronized UpdateInfoTreeModel.NodesAndChildIndices add(Calendar cal) {
        if (cal == null) {
            throw new NullPointerException("cal == null");
        }
        UpdateInfoTreeModel.NodesAndChildIndices info = new UpdateInfoTreeModel.NodesAndChildIndices();
        Date date = new Date(cal);
        this.insertDayNode(this.insertMonthNode(this.insertYearNode(date, info), date, info), date, info);
        return info;
    }

    public synchronized UpdateInfoTreeModel.NodesAndChildIndices add(Date date) {
        if (date == null) {
            throw new NullPointerException("date == null");
        }
        if (!date.isValid()) {
            throw new IllegalArgumentException("Illegal date: " + date);
        }
        UpdateInfoTreeModel.NodesAndChildIndices info = new UpdateInfoTreeModel.NodesAndChildIndices();
        DefaultMutableTreeNode yearNode = this.insertYearNode(date, info);
        if (date.hasMonth()) {
            DefaultMutableTreeNode monthNode = this.insertMonthNode(yearNode, date, info);
            if (date.hasDay()) {
                this.insertDayNode(monthNode, date, info);
            }
        }
        return info;
    }

    public synchronized UpdateInfoTreeModel.NodeAndChild removeDay(Date date) {
        DefaultMutableTreeNode parent;
        if (date == null) {
            throw new NullPointerException("date == null");
        }
        UpdateInfoTreeModel.NodeAndChild info = new UpdateInfoTreeModel.NodeAndChild();
        DefaultMutableTreeNode dayNode = this.getNodeOfDay(date);
        if (dayNode != null && (parent = (DefaultMutableTreeNode)dayNode.getParent()) != null) {
            info.setNode((TreeNode)parent);
            info.setUpdatedChild((Object)dayNode, parent.getIndex(dayNode));
            parent.remove(dayNode);
            this.removeIfEmpty(parent, info);
        }
        return info;
    }

    private void removeIfEmpty(DefaultMutableTreeNode node, UpdateInfoTreeModel.NodeAndChild info) {
        DefaultMutableTreeNode parent;
        if (node.getChildCount() <= 0 && (parent = (DefaultMutableTreeNode)node.getParent()) != null) {
            info.setNode((TreeNode)parent);
            info.setUpdatedChild((Object)node, parent.getIndex(node));
            parent.remove(node);
            this.removeIfEmpty(parent, info);
        }
    }

    public synchronized void addUnknownNode() {
        if (!this.unknownNode) {
            this.unknownNode = true;
            this.ROOT_NODE.add(UNKNOWN_NODE);
        }
    }

    public synchronized boolean existsDate(Date date) {
        if (date == null) {
            throw new NullPointerException("date == null");
        }
        return this.getNodeOfDay(date) != null;
    }

    private DefaultMutableTreeNode getNodeOfDay(Date date) {
        DefaultMutableTreeNode monthNodeOfCal = this.getNodeOfMonth(date);
        if (monthNodeOfCal == null) {
            return null;
        }
        Enumeration<TreeNode> days = monthNodeOfCal.children();
        DefaultMutableTreeNode dayNodeOfCal = null;
        while (dayNodeOfCal == null && days.hasMoreElements()) {
            DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)days.nextElement();
            Object userObject = childNode.getUserObject();
            if (!(userObject instanceof Date)) continue;
            Date dateOfNode = (Date)userObject;
            if (dateOfNode.day != date.day) continue;
            dayNodeOfCal = childNode;
        }
        return dayNodeOfCal;
    }

    private DefaultMutableTreeNode getNodeOfMonth(Date date) {
        DefaultMutableTreeNode yearNodeOfCal = this.getNodeOfYear(date);
        if (yearNodeOfCal == null) {
            return null;
        }
        Enumeration<TreeNode> months = yearNodeOfCal.children();
        DefaultMutableTreeNode monthNodeOfCal = null;
        while (monthNodeOfCal == null && months.hasMoreElements()) {
            DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)months.nextElement();
            Object userObject = childNode.getUserObject();
            if (!(userObject instanceof Date)) continue;
            Date dateOfNode = (Date)userObject;
            if (dateOfNode.month != date.month) continue;
            monthNodeOfCal = childNode;
        }
        return monthNodeOfCal;
    }

    private DefaultMutableTreeNode getNodeOfYear(Date date) {
        Enumeration<TreeNode> years = this.ROOT_NODE.children();
        DefaultMutableTreeNode yearNodeOfCal = null;
        while (yearNodeOfCal == null && years.hasMoreElements()) {
            DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)years.nextElement();
            Object userObject = childNode.getUserObject();
            if (!(userObject instanceof Date)) continue;
            Date dateOfNode = (Date)userObject;
            if (dateOfNode.year != date.year) continue;
            yearNodeOfCal = childNode;
        }
        return yearNodeOfCal;
    }

    private DefaultMutableTreeNode insertYearNode(Date date, UpdateInfoTreeModel.NodesAndChildIndices info) {
        DefaultMutableTreeNode yearNode;
        int indexYearNode = this.indexOfYearNode(date);
        if (indexYearNode >= 0) {
            yearNode = (DefaultMutableTreeNode)this.ROOT_NODE.getChildAt(indexYearNode);
        } else {
            yearNode = new SortedChildrenTreeNode((Object)new Date(date.year, 0, 0));
            this.insertYearNode(yearNode, info);
        }
        return yearNode;
    }

    private void insertYearNode(DefaultMutableTreeNode yearNode, UpdateInfoTreeModel.NodesAndChildIndices info) {
        int childCount = this.ROOT_NODE.getChildCount();
        boolean inserted = false;
        int index = 0;
        int year = this.getYear(yearNode);
        while (!inserted && index < childCount) {
            DefaultMutableTreeNode childNode;
            if ((childNode = (DefaultMutableTreeNode)this.ROOT_NODE.getChildAt(index++)) == UNKNOWN_NODE) continue;
            Object userObject = childNode.getUserObject();
            assert (userObject instanceof Date);
            inserted = ((Date)userObject).year == year;
        }
        if (!inserted) {
            this.ROOT_NODE.add(yearNode);
            info.addNode((TreeNode)this.ROOT_NODE, this.ROOT_NODE.getIndex(yearNode));
        }
    }

    private DefaultMutableTreeNode insertMonthNode(DefaultMutableTreeNode yearNode, Date date, UpdateInfoTreeModel.NodesAndChildIndices info) {
        DefaultMutableTreeNode monthNode = null;
        int childCount = yearNode.getChildCount();
        boolean inserted = false;
        int index = 0;
        while (!inserted && index < childCount) {
            Object userObject;
            boolean userObjectIsDate;
            if (!(userObjectIsDate = (userObject = (monthNode = (DefaultMutableTreeNode)yearNode.getChildAt(index++)).getUserObject()) instanceof Date)) {
                return null;
            }
            int monthValue = ((Date)userObject).month;
            inserted = monthValue == date.month;
        }
        if (!inserted) {
            monthNode = new SortedChildrenTreeNode((Object)new Date(date.year, date.month, 0));
            yearNode.add(monthNode);
            info.addNode((TreeNode)yearNode, yearNode.getIndex(monthNode));
        }
        return monthNode;
    }

    private void insertDayNode(DefaultMutableTreeNode monthNode, Date date, UpdateInfoTreeModel.NodesAndChildIndices info) {
        if (monthNode == null) {
            return;
        }
        Object dayNode = null;
        int childCount = monthNode.getChildCount();
        boolean inserted = false;
        int index = 0;
        while (!inserted && index < childCount) {
            Object userObject;
            boolean userObjectIsDate;
            if (!(userObjectIsDate = (userObject = ((DefaultMutableTreeNode)(dayNode = (DefaultMutableTreeNode)monthNode.getChildAt(index++))).getUserObject()) instanceof Date)) {
                return;
            }
            int dayValue = ((Date)userObject).day;
            inserted = dayValue == date.day;
        }
        if (!inserted) {
            dayNode = new SortedChildrenTreeNode((Object)date);
            monthNode.add((MutableTreeNode)dayNode);
            info.addNode((TreeNode)monthNode, monthNode.getIndex((TreeNode)dayNode));
        }
    }

    private int indexOfYearNode(Date date) {
        int index = 0;
        int childCount = this.ROOT_NODE.getChildCount();
        boolean yearExists = false;
        while (!yearExists && index < childCount) {
            Object userObject;
            if (!((userObject = ((DefaultMutableTreeNode)this.ROOT_NODE.getChildAt(index++)).getUserObject()) instanceof Date)) continue;
            yearExists = ((Date)userObject).year == date.year;
        }
        return yearExists ? index - 1 : -1;
    }

    private int getYear(DefaultMutableTreeNode node) {
        Object userObject = node.getUserObject();
        if (userObject instanceof Date) {
            return ((Date)userObject).year;
        }
        return -1;
    }

    private int getMonth(DefaultMutableTreeNode node) {
        Object userObject = node.getUserObject();
        if (userObject instanceof Date) {
            return ((Date)userObject).month;
        }
        return -1;
    }

    private int getDay(DefaultMutableTreeNode node) {
        Object userObject = node.getUserObject();
        if (userObject instanceof Date) {
            return ((Date)userObject).day;
        }
        return -1;
    }

    public static final class Date
    implements Comparable<Date> {
        public int year;
        public int month;
        public int day;

        public Date(int year, int month, int date) {
            this.year = year;
            this.month = month;
            this.day = date;
        }

        public Date(Calendar cal) {
            this.set(cal);
        }

        public Date(java.sql.Date date) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            this.set(cal);
        }

        public void reset() {
            this.year = -1;
            this.month = -1;
            this.day = -1;
        }

        public void set(Calendar cal) {
            this.year = cal.get(1);
            this.month = cal.get(2) + 1;
            this.day = cal.get(5);
        }

        public boolean setXmpDateCreated(String date) {
            int length = date.length();
            try {
                if (length >= 4) {
                    this.year = Integer.parseInt(date.substring(0, 4));
                }
                if (length >= 7) {
                    this.month = Integer.parseInt(date.substring(5, 7));
                }
                if (length == 10) {
                    this.day = Integer.parseInt(date.substring(8));
                }
                return true;
            }
            catch (Throwable t) {
                Logger.getLogger(Date.class.getName()).log(Level.SEVERE, null, t);
                this.reset();
                return false;
            }
        }

        public boolean isValid() {
            return this.year > 0;
        }

        public boolean hasDay() {
            return this.day > 0;
        }

        public boolean hasMonth() {
            return this.month > 0;
        }

        public boolean hasYear() {
            return this.year > 0;
        }

        public boolean isComplete() {
            return this.day > 0 && this.month > 0 && this.year > 0;
        }

        public String getMonthDisplayName() {
            try {
                if (!this.hasMonth()) {
                    return Bundle.getString(Date.class, (String)"Timeline.DisplayName.NoMonth", (Object[])new Object[0]);
                }
                SimpleDateFormat df = new SimpleDateFormat("M");
                java.util.Date date = df.parse(Integer.toString(this.month));
                SimpleDateFormat dfLong = new SimpleDateFormat("MMMM");
                return dfLong.format(date);
            }
            catch (Throwable t) {
                Logger.getLogger(Date.class.getName()).log(Level.SEVERE, null, t);
                return Bundle.getString(Date.class, (String)"Timeline.DisplayName.NoMonth", (Object[])new Object[0]);
            }
        }

        public String toString() {
            DecimalFormat dfY = new DecimalFormat("0000");
            DecimalFormat dfMD = new DecimalFormat("00");
            return MessageFormat.format("{0}-{1}-{2}", dfY.format(this.year), dfMD.format(this.month), dfMD.format(this.day));
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Date other = (Date)obj;
            if (this.year != other.year) {
                return false;
            }
            if (this.month != other.month) {
                return false;
            }
            return this.day == other.day;
        }

        public int hashCode() {
            int hash = 3;
            hash = 31 * hash + this.year;
            hash = 31 * hash + this.month;
            hash = 31 * hash + this.day;
            return hash;
        }

        @Override
        public int compareTo(Date o) {
            if (this.year == o.year && this.month == o.month && this.day == o.day) {
                return 0;
            }
            boolean greater = this.year > o.year || this.year == o.year && this.month > o.month || this.year == o.year && this.month == o.month && this.day > o.day;
            return greater ? 1 : -1;
        }
    }
}

