/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.domain.thumbnails.event;

import java.io.File;
import java.util.Collections;
import java.util.List;
import org.jphototagger.domain.thumbnails.OriginOfDisplayedThumbnails;

public final class ThumbnailsChangedEvent {
    private final Object source;
    private final OriginOfDisplayedThumbnails originOfDisplayedThumbnails;
    private final List<File> imageFiles;

    public ThumbnailsChangedEvent(Object source, OriginOfDisplayedThumbnails originOfDisplayedThumbnails, List<File> imageFiles) {
        if (originOfDisplayedThumbnails == null) {
            throw new NullPointerException("typeOfDisplayedImages == null");
        }
        if (imageFiles == null) {
            throw new NullPointerException("imageFiles == null");
        }
        this.source = source;
        this.originOfDisplayedThumbnails = originOfDisplayedThumbnails;
        this.imageFiles = imageFiles;
    }

    public List<File> getImageFiles() {
        return Collections.unmodifiableList(this.imageFiles);
    }

    public Object getSource() {
        return this.source;
    }

    public boolean isEmpty() {
        return this.imageFiles.isEmpty();
    }

    public int getThumbnailCount() {
        return this.imageFiles.size();
    }

    public OriginOfDisplayedThumbnails getOriginOfDisplayedThumbnails() {
        return this.originOfDisplayedThumbnails;
    }
}

