/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.domain.thumbnails;

import java.awt.Point;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ThumbnailsPanelSettings {
    private final List<Integer> selectedIndices;
    private final Point viewPosition;
    private final List<File> selectedFiles = new ArrayList<File>();

    public ThumbnailsPanelSettings(Point viewPosition, List<Integer> selectedIndices) {
        if (viewPosition == null) {
            throw new NullPointerException("viewPosition == null");
        }
        if (selectedIndices == null) {
            throw new NullPointerException("selectedIndices == null");
        }
        this.viewPosition = viewPosition;
        this.selectedIndices = new ArrayList<Integer>(selectedIndices);
    }

    public Point getViewPosition() {
        return this.viewPosition;
    }

    public List<File> getSelectedFiles() {
        return Collections.unmodifiableList(this.selectedFiles);
    }

    public void setSelectedFiles(List<File> files) {
        if (files == null) {
            throw new NullPointerException("files == null");
        }
        this.selectedFiles.clear();
        this.selectedFiles.addAll(files);
    }

    public boolean hasSelectedFiles() {
        return !this.selectedFiles.isEmpty();
    }

    public List<Integer> getSelectedIndices() {
        return Collections.unmodifiableList(this.selectedIndices);
    }

    public boolean hasSelectedIndices() {
        return !this.selectedIndices.isEmpty();
    }
}

