/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.domain.thumbnails;

import java.awt.Color;
import java.io.File;
import org.jphototagger.api.collections.PositionProvider;
import org.jphototagger.domain.metadata.xmp.XmpSidecarFileResolver;
import org.jphototagger.lib.util.Bundle;
import org.openide.util.Lookup;

public enum ThumbnailFlag implements PositionProvider
{
    HAS_SIDECAR_FILE(new Color(98, 98, 98), Color.WHITE, 0, "ThumbnailFlag.HasSidecarFile"),
    ERROR_FILE_NOT_FOUND(Color.RED, Color.WHITE, 1, "ThumbnailFlag.FileNotFound");

    private final Color fillColor;
    private final Color borderColor;
    private final String displayName;
    private final int position;
    private final XmpSidecarFileResolver sidecarFileResolver = (XmpSidecarFileResolver)Lookup.getDefault().lookup(XmpSidecarFileResolver.class);

    private ThumbnailFlag(Color fillColor, Color borderColor, int position, String bundleKey) {
        this.fillColor = fillColor;
        this.borderColor = borderColor;
        this.position = position;
        this.displayName = Bundle.getString(ThumbnailFlag.class, (String)bundleKey, (Object[])new Object[0]);
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String toString() {
        return this.displayName;
    }

    public int getPosition() {
        return this.position;
    }

    public boolean matches(File file) {
        if (file == null) {
            return false;
        }
        switch (this) {
            case ERROR_FILE_NOT_FOUND: {
                return !file.exists();
            }
            case HAS_SIDECAR_FILE: {
                return this.sidecarFileResolver != null && this.sidecarFileResolver.hasXmpSidecarFile(file);
            }
        }
        throw new IllegalStateException("Not handled: " + (Object)((Object)this));
    }
}

