/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.domain.thumbnails;

import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public final class FileType {
    private final Set<String> filenameSuffixes;
    private final String displayName;

    public FileType(String displayName, String ... filenameSuffixes) {
        this(displayName, Arrays.asList(filenameSuffixes));
    }

    public FileType(String displayName, Collection<? extends String> filenameSuffixes) {
        if (displayName == null) {
            throw new NullPointerException("displayName == null");
        }
        if (filenameSuffixes == null) {
            throw new NullPointerException("filenameSuffixes == null");
        }
        if (filenameSuffixes.size() < 1) {
            throw new IllegalStateException("At least one suffix has to be defined");
        }
        this.filenameSuffixes = new HashSet<String>(filenameSuffixes.size());
        for (String string : filenameSuffixes) {
            this.filenameSuffixes.add(string.toLowerCase());
        }
        this.displayName = displayName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Set<String> getFilenameSuffixes() {
        return Collections.unmodifiableSet(this.filenameSuffixes);
    }

    public FileFilter createFileFilter() {
        return new FileFilter(){

            @Override
            public boolean accept(File file) {
                return FileType.this.isAccept(file);
            }
        };
    }

    public javax.swing.filechooser.FileFilter createFileChooserFilter() {
        return new javax.swing.filechooser.FileFilter(){

            @Override
            public boolean accept(File file) {
                return FileType.this.isAccept(file);
            }

            @Override
            public String getDescription() {
                return FileType.this.displayName;
            }
        };
    }

    private boolean isAccept(File file) {
        String name = file.getName().toLowerCase();
        for (String filenameSuffix : this.filenameSuffixes) {
            if (!name.endsWith("." + filenameSuffix)) continue;
            return true;
        }
        return false;
    }
}

