/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.domain.templates;

import java.util.HashMap;
import java.util.Set;
import org.jphototagger.domain.metadata.MetaDataValue;
import org.jphototagger.domain.metadata.xmp.Xmp;
import org.jphototagger.domain.metadata.xmp.XmpMetaDataValues;

public final class MetadataTemplate {
    private String name;
    private final HashMap<MetaDataValue, Object> fieldOfMetaDataValue = new HashMap();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean hasName() {
        return this.name != null && !this.name.trim().isEmpty();
    }

    public Object getMetaDataValue(MetaDataValue value) {
        if (value == null) {
            throw new NullPointerException("value == null");
        }
        return this.fieldOfMetaDataValue.get(value);
    }

    public void setMetaDataValue(MetaDataValue value, Object data) {
        if (value == null) {
            throw new NullPointerException("value == null");
        }
        if (data == null) {
            this.fieldOfMetaDataValue.remove(value);
        } else {
            this.fieldOfMetaDataValue.put(value, data);
        }
    }

    public String toString() {
        return this.name == null ? "" : this.name;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MetadataTemplate other = (MetadataTemplate)obj;
        return this.name != null && this.name.equals(other.name);
    }

    public int hashCode() {
        int hash = 7;
        hash = 67 * hash + (this.name != null ? this.name.hashCode() : 0);
        return hash;
    }

    public void setXmp(Xmp xmp) {
        if (xmp == null) {
            throw new NullPointerException("xmp == null");
        }
        for (MetaDataValue value : XmpMetaDataValues.get()) {
            this.fieldOfMetaDataValue.put(value, xmp.getValue(value));
        }
    }

    public Set<MetaDataValue> getMetaDataValues() {
        return this.fieldOfMetaDataValue.keySet();
    }

    public void updateValuesWithTemplate(MetadataTemplate template) {
        Set<MetaDataValue> metaDataValues = template.getMetaDataValues();
        for (MetaDataValue metaDataValue : metaDataValues) {
            this.fieldOfMetaDataValue.put(metaDataValue, template.getMetaDataValue(metaDataValue));
        }
    }
}

