/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.domain.repository.xmp;

import java.util.HashSet;
import java.util.Set;

public final class XmpToSaveInRepository {
    private static final Set<String> STORED_PATHS_PREFIXES = new HashSet<String>();

    public static boolean isSaveInRepository(String path) {
        if (path == null) {
            throw new NullPointerException("path == null");
        }
        for (String storedPathStartsWith : STORED_PATHS_PREFIXES) {
            if (!path.startsWith(storedPathStartsWith)) continue;
            return true;
        }
        return false;
    }

    public static Set<String> getPathPrefixes() {
        return new HashSet<String>(STORED_PATHS_PREFIXES);
    }

    private XmpToSaveInRepository() {
    }

    static {
        STORED_PATHS_PREFIXES.add("dc:creator");
        STORED_PATHS_PREFIXES.add("dc:description");
        STORED_PATHS_PREFIXES.add("dc:rights");
        STORED_PATHS_PREFIXES.add("dc:subject");
        STORED_PATHS_PREFIXES.add("dc:title");
        STORED_PATHS_PREFIXES.add("Iptc4xmpCore:CountryCode");
        STORED_PATHS_PREFIXES.add("Iptc4xmpCore:DateCreated");
        STORED_PATHS_PREFIXES.add("Iptc4xmpCore:Location");
        STORED_PATHS_PREFIXES.add("photoshop:AuthorsPosition");
        STORED_PATHS_PREFIXES.add("photoshop:CaptionWriter");
        STORED_PATHS_PREFIXES.add("photoshop:City");
        STORED_PATHS_PREFIXES.add("photoshop:Country");
        STORED_PATHS_PREFIXES.add("photoshop:Credit");
        STORED_PATHS_PREFIXES.add("photoshop:Headline");
        STORED_PATHS_PREFIXES.add("photoshop:Instructions");
        STORED_PATHS_PREFIXES.add("photoshop:Source");
        STORED_PATHS_PREFIXES.add("photoshop:State");
        STORED_PATHS_PREFIXES.add("photoshop:TransmissionReference");
        STORED_PATHS_PREFIXES.add("xap:Rating");
    }
}

