/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.domain.repository.event.wordsets;

import org.jphototagger.lib.util.StringUtil;

public final class WordsetWordRenamedEvent {
    private final Object source;
    private final String wordsetName;
    private final String oldWord;
    private final String newWord;

    public WordsetWordRenamedEvent(Object source, String wordsetName, String oldWord, String newWord) {
        if (source == null) {
            throw new NullPointerException("source == null");
        }
        if (!StringUtil.hasContent((String)wordsetName)) {
            throw new IllegalArgumentException("Wordset name must have content: " + wordsetName);
        }
        if (!StringUtil.hasContent((String)oldWord)) {
            throw new IllegalArgumentException("Old word must have content: " + oldWord);
        }
        if (!StringUtil.hasContent((String)newWord)) {
            throw new IllegalArgumentException("New word name must have content: " + newWord);
        }
        this.source = source;
        this.wordsetName = wordsetName;
        this.oldWord = oldWord;
        this.newWord = newWord;
    }

    public String getNewWord() {
        return this.newWord;
    }

    public String getOldWord() {
        return this.oldWord;
    }

    public Object getSource() {
        return this.source;
    }

    public String getWordsetName() {
        return this.wordsetName;
    }
}

