/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.domain.repository.event.wordsets;

import org.jphototagger.lib.util.StringUtil;

public final class WordsetWordAddedEvent {
    private final Object source;
    private final String wordsetName;
    private final String word;

    public WordsetWordAddedEvent(Object source, String wordsetName, String word) {
        if (source == null) {
            throw new NullPointerException("source == null");
        }
        if (!StringUtil.hasContent((String)wordsetName)) {
            throw new IllegalArgumentException("Wordset name must have content: " + wordsetName);
        }
        if (!StringUtil.hasContent((String)word)) {
            throw new IllegalArgumentException("Word must have content: " + word);
        }
        this.source = source;
        this.wordsetName = wordsetName;
        this.word = word;
    }

    public Object getSource() {
        return this.source;
    }

    public String getWord() {
        return this.word;
    }

    public String getWordsetName() {
        return this.wordsetName;
    }
}

