/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.domain.repository.event.imagecollections;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class ImageCollectionInsertedEvent {
    private final Object source;
    private final String collectionName;
    private final List<File> insertedImageFiles;

    public ImageCollectionInsertedEvent(Object source, String collectionName, List<File> insertedImageFiles) {
        if (collectionName == null) {
            throw new NullPointerException("collectionName == null");
        }
        if (insertedImageFiles == null) {
            throw new NullPointerException("insertedImageFiles == null");
        }
        this.source = source;
        this.collectionName = collectionName;
        this.insertedImageFiles = new ArrayList<File>(insertedImageFiles);
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public List<File> getInsertedImageFiles() {
        return Collections.unmodifiableList(this.insertedImageFiles);
    }

    public Object getSource() {
        return this.source;
    }
}

