/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.domain.repository;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.jphototagger.domain.repository.Repository;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.InitializationError;
import org.openide.util.Lookup;

public class RepositoryConnectedTestClassRunner
extends BlockJUnit4ClassRunner {
    private static int startUpRequests;
    private static boolean repoInit;

    public RepositoryConnectedTestClassRunner(Class<?> klass) throws InitializationError {
        super(klass);
        ++startUpRequests;
    }

    public void run(RunNotifier notifier) {
        try {
            RepositoryConnectedTestClassRunner.initResourceIfNecessary();
            super.run(notifier);
            --startUpRequests;
            RepositoryConnectedTestClassRunner.disposeResourceIfNecessary();
        }
        catch (Throwable t) {
            Logger.getLogger(RepositoryConnectedTestClassRunner.class.getName()).log(Level.SEVERE, null, t);
        }
    }

    private static void disposeResourceIfNecessary() {
        if (startUpRequests == 0) {
            Repository repository = (Repository)Lookup.getDefault().lookup(Repository.class);
            repository.shutdown();
        }
    }

    private static void initResourceIfNecessary() throws Exception {
        if (!repoInit) {
            Repository repository = (Repository)Lookup.getDefault().lookup(Repository.class);
            repository.init();
            repoInit = true;
        }
    }
}

