/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.domain.programs;

import java.io.File;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.jphototagger.lib.runtime.RuntimeUtil;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public final class Program {
    @XmlTransient
    private static final String EMPTY = "";
    private long id = Long.MIN_VALUE;
    private boolean action = false;
    private File file;
    private String alias;
    private String parametersBeforeFilename;
    private String parametersAfterFilename;
    private String pattern;
    private boolean usePattern;
    private boolean inputBeforeExecute;
    private boolean inputBeforeExecutePerFile;
    private boolean singleFileProcessing;
    private boolean changeFile;
    private int sequenceNumber = Integer.MIN_VALUE;

    public Program() {
    }

    public Program(File file, String alias) {
        this.file = file;
        this.alias = alias;
    }

    public Program(Program program) {
        if (program == null) {
            throw new NullPointerException("program == null");
        }
        this.set(program);
    }

    public void set(Program other) {
        if (other == null) {
            throw new NullPointerException("program == null");
        }
        if (other != this) {
            this.id = other.id;
            this.action = other.action;
            this.alias = other.alias;
            this.changeFile = other.changeFile;
            this.file = other.file;
            this.inputBeforeExecute = other.inputBeforeExecute;
            this.inputBeforeExecutePerFile = other.inputBeforeExecutePerFile;
            this.parametersAfterFilename = other.parametersAfterFilename;
            this.parametersBeforeFilename = other.parametersBeforeFilename;
            this.pattern = other.pattern;
            this.sequenceNumber = other.sequenceNumber;
            this.singleFileProcessing = other.singleFileProcessing;
            this.usePattern = other.usePattern;
        }
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public String getParametersAfterFilename() {
        return this.parametersAfterFilename;
    }

    public void setParametersAfterFilename(String parametersAfterFilename) {
        this.parametersAfterFilename = parametersAfterFilename;
    }

    public int getSequenceNumber() {
        return this.sequenceNumber;
    }

    public void setSequenceNumber(int sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }

    public boolean isAction() {
        return this.action;
    }

    public void setAction(boolean action) {
        this.action = action;
    }

    public boolean isInputBeforeExecute() {
        return this.inputBeforeExecute;
    }

    public void setInputBeforeExecute(boolean inputBeforeExecute) {
        this.inputBeforeExecute = inputBeforeExecute;
    }

    public boolean isInputBeforeExecutePerFile() {
        return this.inputBeforeExecutePerFile;
    }

    public void setInputBeforeExecutePerFile(boolean inputBeforeExecutePerFile) {
        this.inputBeforeExecutePerFile = inputBeforeExecutePerFile;
    }

    public String getParametersBeforeFilename() {
        return this.parametersBeforeFilename;
    }

    public void setParametersBeforeFilename(String parametersBeforeFilename) {
        this.parametersBeforeFilename = parametersBeforeFilename;
    }

    public boolean isSingleFileProcessing() {
        return this.singleFileProcessing;
    }

    public void setSingleFileProcessing(boolean singleFileProcessing) {
        this.singleFileProcessing = singleFileProcessing;
    }

    public boolean isChangeFile() {
        return this.changeFile;
    }

    public void setChangeFile(boolean changeFile) {
        this.changeFile = changeFile;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public boolean isUsePattern() {
        return this.usePattern;
    }

    public void setUsePattern(boolean usePattern) {
        this.usePattern = usePattern;
    }

    public String getCommandlineParameters(List<File> files, String additionalParameters, boolean additionalParametersBeforeFilenames) {
        if (files == null) {
            throw new NullPointerException("files == null");
        }
        if (additionalParameters == null) {
            throw new NullPointerException("additionalParameters == null");
        }
        String sep = RuntimeUtil.getDefaultCommandLineSeparator();
        String parametersBefore = (this.parametersBeforeFilename == null ? EMPTY : this.parametersBeforeFilename) + (additionalParametersBeforeFilenames ? sep + additionalParameters : EMPTY);
        String parametersAfter = (this.parametersAfterFilename == null ? EMPTY : this.parametersAfterFilename) + (additionalParametersBeforeFilenames ? EMPTY : sep + additionalParameters);
        return parametersBefore + sep + RuntimeUtil.quoteForCommandLine(files) + sep + parametersAfter;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Program other = (Program)obj;
        return this.id == other.id;
    }

    public int hashCode() {
        int hash = 5;
        hash = 53 * hash + (int)(this.id ^ this.id >>> 32);
        return hash;
    }

    public String toString() {
        return this.alias == null ? EMPTY : this.alias;
    }
}

