/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.domain.metadata.xmp;

import java.util.Calendar;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import org.jphototagger.domain.metadata.MetaDataValue;
import org.jphototagger.lib.swing.inputverifier.EmptyInputVerifier;
import org.jphototagger.lib.swing.inputverifier.InputVerifiersOr;
import org.jphototagger.lib.swing.inputverifier.StringPatternInputVerifier;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.lib.util.DateUtil;
import org.jphototagger.lib.util.NumberUtil;
import org.jphototagger.lib.util.StringUtil;

public final class XmpIptc4XmpCoreDateCreatedMetaDataValue
extends MetaDataValue {
    public static final XmpIptc4XmpCoreDateCreatedMetaDataValue INSTANCE = new XmpIptc4XmpCoreDateCreatedMetaDataValue();
    private static final InputVerifierDateCreated INPUT_VERIFIER = new InputVerifierDateCreated();

    private XmpIptc4XmpCoreDateCreatedMetaDataValue() {
        super("iptc4xmpcore_datecreated", "xmp", MetaDataValue.ValueType.STRING);
        this.setValueLength(10);
        this.setDescription(Bundle.getString(XmpIptc4XmpCoreDateCreatedMetaDataValue.class, (String)"XmpIptc4XmpCoreDateCreatedMetaDataValue.Description", (Object[])new Object[0]));
        this.setLongerDescription(Bundle.getString(XmpIptc4XmpCoreDateCreatedMetaDataValue.class, (String)"XmpIptc4XmpCoreDateCreatedMetaDataValue.LongerDescription", (Object[])new Object[0]));
    }

    @Override
    public InputVerifier getInputVerifier() {
        return INPUT_VERIFIER;
    }

    public static Long createTimestamp(String dateCreated) {
        int day;
        if (!StringUtil.hasContent((String)dateCreated)) {
            return null;
        }
        String[] dateParts = dateCreated.split("-");
        if (dateParts == null || dateParts.length > 3) {
            return null;
        }
        for (String datePart : dateParts) {
            if (NumberUtil.isInteger((String)datePart)) continue;
            return null;
        }
        int year = Integer.parseInt(dateParts[0]);
        int month = dateParts.length >= 2 ? Integer.parseInt(dateParts[1]) : 6;
        int n = day = dateParts.length == 3 ? Integer.parseInt(dateParts[2]) : 15;
        if (!DateUtil.isValidGregorianDate((int)year, (int)month, (int)day)) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, month);
        cal.set(5, day);
        cal.set(11, 12);
        return cal.getTime().getTime();
    }

    private static class InputVerifierDateCreated
    extends InputVerifier {
        private final InputVerifiersOr inputVerifiersOr = new InputVerifiersOr();

        InputVerifierDateCreated() {
            EmptyInputVerifier inputVerifierEmpty = new EmptyInputVerifier(true);
            StringPatternInputVerifier inputVerifierY = new StringPatternInputVerifier("[0-9][0-9][0-9][0-9]");
            StringPatternInputVerifier inputVerifierYM = new StringPatternInputVerifier("[0-9][0-9][0-9][0-9]-[0-1][0-9]");
            StringPatternInputVerifier inputVerifierYMD = new StringPatternInputVerifier("[0-9][0-9][0-9][0-9]-[0-1][0-9]-[0-3][0-9]");
            this.inputVerifiersOr.addVerifier((InputVerifier)inputVerifierEmpty);
            this.inputVerifiersOr.addVerifier((InputVerifier)inputVerifierY);
            this.inputVerifiersOr.addVerifier((InputVerifier)inputVerifierYM);
            this.inputVerifiersOr.addVerifier((InputVerifier)inputVerifierYMD);
        }

        @Override
        public boolean verify(JComponent input) {
            boolean valid = this.inputVerifiersOr.verify(input);
            if (!valid) {
                this.errorMessage(input);
            }
            return valid;
        }

        private void errorMessage(JComponent input) {
            String message = Bundle.getString(XmpIptc4XmpCoreDateCreatedMetaDataValue.class, (String)"XmpIptc4XmpCoreDateCreatedMetaDataValue.Rules", (Object[])new Object[0]);
            String title = Bundle.getString(XmpIptc4XmpCoreDateCreatedMetaDataValue.class, (String)"XmpIptc4XmpCoreDateCreatedMetaDataValue.Title.ErrorInput", (Object[])new Object[0]);
            int messageType = 0;
            JOptionPane.showMessageDialog(input, message, title, messageType);
        }
    }
}

