/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.domain.metadata.xmp;

import com.imagero.reader.iptc.IPTCEntryMeta;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jphototagger.domain.event.listener.TextEntryListener;
import org.jphototagger.domain.metadata.MetaDataValue;
import org.jphototagger.domain.metadata.iptc.Iptc;
import org.jphototagger.domain.metadata.mapping.IPTCEntryMetaDataValue;
import org.jphototagger.domain.metadata.mapping.IptcXmpMapping;
import org.jphototagger.domain.metadata.mapping.XmpRepeatableValues;
import org.jphototagger.domain.metadata.xmp.XmpIptc4XmpCoreDateCreatedMetaDataValue;
import org.jphototagger.domain.metadata.xmp.XmpMetaDataValues;
import org.jphototagger.domain.templates.MetadataTemplate;
import org.jphototagger.lib.awt.EventQueueUtil;

public final class Xmp
implements TextEntryListener {
    private final Map<MetaDataValue, Object> metaDataValue = new HashMap<MetaDataValue, Object>();

    public Xmp() {
    }

    public Xmp(Xmp other) {
        if (other == null) {
            throw new NullPointerException("other == null");
        }
        this.set(other);
    }

    public boolean contains(MetaDataValue value) {
        if (value == null) {
            throw new NullPointerException("value == null");
        }
        return this.metaDataValue.get(value) != null;
    }

    public Object remove(MetaDataValue mdValue) {
        if (mdValue == null) {
            throw new NullPointerException("mdValue == null");
        }
        return this.metaDataValue.remove(mdValue);
    }

    @Override
    public void textRemoved(final MetaDataValue mdValue, final String removedText) {
        EventQueueUtil.invokeInDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                Xmp.this.removeValue(mdValue, removedText);
            }
        });
    }

    @Override
    public void textAdded(final MetaDataValue mdValue, final String addedText) {
        EventQueueUtil.invokeInDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                Xmp.this.setValue(mdValue, addedText);
            }
        });
    }

    @Override
    public void textChanged(final MetaDataValue mdValue, final String oldText, final String newText) {
        EventQueueUtil.invokeInDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                Xmp.this.changeText(mdValue, newText, oldText);
            }
        });
    }

    private void changeText(MetaDataValue mdValue, String newText, String oldText) {
        if (XmpRepeatableValues.isRepeatable(mdValue)) {
            Object o = this.metaDataValue.get(mdValue);
            if (o == null) {
                ArrayList<String> collection = new ArrayList<String>();
                collection.add(newText);
                this.metaDataValue.put(mdValue, collection);
            } else if (o instanceof Collection) {
                Collection collection = (Collection)o;
                collection.remove(oldText);
                collection.add(newText);
            }
        } else {
            this.setValue(mdValue, newText);
        }
    }

    public void setMetaDataTemplate(MetadataTemplate template) {
        if (template == null) {
            throw new NullPointerException("template == null");
        }
        for (MetaDataValue value : XmpMetaDataValues.get()) {
            this.metaDataValue.put(value, template.getMetaDataValue(value));
        }
    }

    public boolean containsValue(MetaDataValue mdValue, Object value) {
        if (mdValue == null) {
            throw new NullPointerException("mdValue == null");
        }
        if (value == null) {
            throw new NullPointerException("value == null");
        }
        Object o = this.metaDataValue.get(mdValue);
        if (o == null) {
            return false;
        }
        if (o instanceof Collection) {
            return ((Collection)o).contains(value);
        }
        return o.equals(value);
    }

    public boolean containsOneOf(MetaDataValue mdValue, Collection<?> values) {
        for (Object value : values) {
            if (!this.containsValue(mdValue, value)) continue;
            return true;
        }
        return false;
    }

    public static boolean valueInserted(Xmp oldXmp, Xmp updatedXmp, MetaDataValue mdValue, Collection<?> values) {
        for (Object value : values) {
            if (oldXmp.containsValue(mdValue, value) || !updatedXmp.containsValue(mdValue, value)) continue;
            return true;
        }
        return false;
    }

    public static boolean valueDeleted(Xmp oldXmp, Xmp updatedXmp, MetaDataValue mdValue, Collection<?> values) {
        for (Object value : values) {
            if (!oldXmp.containsValue(mdValue, value) || updatedXmp.containsValue(mdValue, value)) continue;
            return true;
        }
        return false;
    }

    public void setIptc(Iptc iptc, SetIptc options) {
        if (iptc == null) {
            throw new NullPointerException("iptc == null");
        }
        if (options == null) {
            throw new NullPointerException("options == null");
        }
        if (options.equals((Object)SetIptc.REPLACE_EXISTING_VALUES)) {
            this.clear();
        }
        List<IPTCEntryMetaDataValue> mappings = IptcXmpMapping.getAllMappings();
        for (IPTCEntryMetaDataValue mapping : mappings) {
            boolean isSet;
            MetaDataValue xmpMetaDataValue = mapping.getMetaDataValue();
            IPTCEntryMeta iptcEntryMeta = IptcXmpMapping.getIptcEntryMetaOfXmpMetaDataValue(xmpMetaDataValue);
            Object iptcValue = iptc.getValue(iptcEntryMeta);
            if (iptcValue == null) continue;
            if (iptcValue instanceof String) {
                String iptcString = (String)iptcValue;
                isSet = options.equals((Object)SetIptc.REPLACE_EXISTING_VALUES) || this.getValue(xmpMetaDataValue) == null;
                if (!isSet) continue;
                iptcString = this.formatIptcDate(xmpMetaDataValue, iptcString);
                this.setValue(xmpMetaDataValue, iptcString);
                continue;
            }
            if (iptcValue instanceof Collection) {
                Collection collection = (Collection)iptcValue;
                if (XmpRepeatableValues.isRepeatable(xmpMetaDataValue)) {
                    for (Object o : collection) {
                        this.setValue(xmpMetaDataValue, o);
                    }
                    continue;
                }
                if (collection.isEmpty() || !(isSet = options.equals((Object)SetIptc.REPLACE_EXISTING_VALUES) || this.getValue(xmpMetaDataValue) == null)) continue;
                int i = 0;
                for (Object value : collection) {
                    if (i++ != 0) continue;
                    this.setValue(xmpMetaDataValue, value);
                }
                continue;
            }
            Logger.getLogger(Xmp.class.getName()).log(Level.WARNING, "Error setting iptc{0} for {1}", new Object[]{iptcValue, xmpMetaDataValue});
        }
    }

    private String formatIptcDate(MetaDataValue xmpMetaDataValue, String iptcString) {
        if (iptcString == null) {
            return null;
        }
        if (xmpMetaDataValue.equals(XmpIptc4XmpCoreDateCreatedMetaDataValue.INSTANCE) && iptcString.length() == 8) {
            if (iptcString.contains("-")) {
                return iptcString;
            }
            return iptcString.substring(0, 4) + "-" + iptcString.substring(4, 6) + "-" + iptcString.substring(6);
        }
        return iptcString;
    }

    public Object getValue(MetaDataValue xmpMetaDataValue) {
        if (xmpMetaDataValue == null) {
            throw new NullPointerException("xmpMetaDataValue == null");
        }
        Object o = this.metaDataValue.get(xmpMetaDataValue);
        return o instanceof Collection ? new ArrayList((Collection)o) : o;
    }

    public void setValue(MetaDataValue xmpMetaDataValue, Object value) {
        if (xmpMetaDataValue == null) {
            throw new NullPointerException("xmpMetaDataValue == null");
        }
        if (value == null) {
            this.metaDataValue.remove(xmpMetaDataValue);
            return;
        }
        if (XmpRepeatableValues.isRepeatable(xmpMetaDataValue)) {
            this.addToCollection(xmpMetaDataValue, value);
        } else {
            this.metaDataValue.put(xmpMetaDataValue, value);
        }
    }

    public void removeValue(MetaDataValue xmpMetaDataValue, Object value) {
        if (xmpMetaDataValue == null) {
            throw new NullPointerException("xmpMetaDataValue == null");
        }
        if (value == null) {
            throw new NullPointerException("value == null");
        }
        Object o = this.metaDataValue.get(xmpMetaDataValue);
        boolean remove = true;
        if (o instanceof Collection) {
            Collection collection = (Collection)o;
            collection.remove(value);
            remove = collection.isEmpty();
        }
        if (remove) {
            this.metaDataValue.remove(xmpMetaDataValue);
        }
    }

    public void clear() {
        this.metaDataValue.clear();
    }

    public boolean isEmpty() {
        for (MetaDataValue value : this.metaDataValue.keySet()) {
            List list;
            String string;
            Object o = this.metaDataValue.get(value);
            if (!(o instanceof String ? !(string = (String)o).trim().isEmpty() : (o instanceof List ? !(list = (List)o).isEmpty() : o != null))) continue;
            return false;
        }
        return true;
    }

    private Collection<? super Object> collectionReferenceOf(MetaDataValue value) {
        Object o = this.metaDataValue.get(value);
        return o instanceof Collection ? (Collection)o : null;
    }

    private void addToCollection(MetaDataValue mdValue, Object value) {
        Collection<? super Object> collection = this.collectionReferenceOf(mdValue);
        if (collection == null) {
            collection = new ArrayList<Object>();
            this.metaDataValue.put(mdValue, collection);
        }
        List<Object> values = value instanceof Collection ? (List<Object>)value : Arrays.asList(value);
        for (Object e : values) {
            if (collection.contains(e)) continue;
            collection.add(e);
        }
    }

    public void set(Xmp xmp) {
        if (xmp == null) {
            throw new NullPointerException("xmp == null");
        }
        if (xmp == this) {
            return;
        }
        this.metaDataValue.clear();
        for (MetaDataValue value : xmp.metaDataValue.keySet()) {
            Object o = xmp.metaDataValue.get(value);
            if (o instanceof Collection) {
                this.metaDataValue.put(value, new ArrayList((List)o));
                continue;
            }
            if (o == null) continue;
            this.metaDataValue.put(value, o);
        }
    }

    public String toString() {
        return this.metaDataValue.toString();
    }

    public static enum SetIptc {
        REPLACE_EXISTING_VALUES,
        DONT_CHANGE_EXISTING_VALUES;

    }
}

