/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.domain.metadata.selections;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.jphototagger.api.preferences.Preferences;
import org.jphototagger.domain.metadata.MetaDataValue;
import org.jphototagger.domain.metadata.selections.AutocompleteMetaDataValues;
import org.jphototagger.domain.repository.MetaDataValuesRepository;
import org.jphototagger.lib.util.CollectionUtil;
import org.openide.util.Lookup;

public final class AutoCompleteData {
    private final LinkedList<String> words = new LinkedList();
    private final Set<MetaDataValue> metaDataValues;
    private final MetaDataValuesRepository repo = (MetaDataValuesRepository)Lookup.getDefault().lookup(MetaDataValuesRepository.class);

    AutoCompleteData(Collection<? extends MetaDataValue> values) {
        this.metaDataValues = new LinkedHashSet<MetaDataValue>(this.getAutocompleteMetaDataValuesOf(values));
        this.words.addAll(this.repo.findDistinctMetaDataValues(this.metaDataValues));
        Collections.sort(this.words);
    }

    AutoCompleteData(MetaDataValue value) {
        this.metaDataValues = new LinkedHashSet<MetaDataValue>(this.getAutocompleteMetaDataValuesOf(Collections.singleton(value)));
        this.words.addAll(this.repo.findDistinctMetaDataValues(value));
    }

    private Set<MetaDataValue> getAutocompleteMetaDataValuesOf(Collection<? extends MetaDataValue> values) {
        HashSet<MetaDataValue> cols = new HashSet<MetaDataValue>(values.size());
        for (MetaDataValue metaDataValue : values) {
            if (!AutocompleteMetaDataValues.contains(metaDataValue)) continue;
            cols.add(metaDataValue);
        }
        return cols;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(String word) {
        if (word == null) {
            throw new NullPointerException("word == null");
        }
        if (this.isUpdateAutocomplete()) {
            String lcWord = this.isAutocompleteFastSearchIgnoreCase() ? word.toLowerCase() : word;
            LinkedList<String> linkedList = this.words;
            synchronized (linkedList) {
                if (Collections.binarySearch(this.words, lcWord) < 0) {
                    CollectionUtil.binaryInsert(this.words, (Object)lcWord);
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isAutocompleteFastSearchIgnoreCase() {
        Preferences prefs = (Preferences)Lookup.getDefault().lookup(Preferences.class);
        return prefs.containsKey("UserSettings.Autocomplete.IgnoreCase") ? prefs.getBoolean("UserSettings.Autocomplete.IgnoreCase") : false;
    }

    private boolean isUpdateAutocomplete() {
        Preferences prefs = (Preferences)Lookup.getDefault().lookup(Preferences.class);
        return prefs.containsKey("UserSettings.UpdateAutocomplete") ? prefs.getBoolean("UserSettings.UpdateAutocomplete") : true;
    }

    public List<String> get() {
        return this.words;
    }
}

