/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.domain.metadata.search;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.jphototagger.domain.metadata.MetaDataValue;
import org.jphototagger.domain.metadata.MetaDataValueIds;
import org.jphototagger.domain.metadata.search.Comparator;
import org.jphototagger.domain.metadata.search.Operator;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public final class SavedSearchPanel {
    private int columnId = -1;
    private int comparatorId = -1;
    private int operatorId = -1;
    private int panelIndex = Integer.MIN_VALUE;
    private boolean bracketLeft1Selected;
    private boolean bracketLeft2Selected;
    private boolean bracketRightSelected;
    private String value;

    public SavedSearchPanel() {
    }

    public SavedSearchPanel(SavedSearchPanel other) {
        if (other == null) {
            throw new NullPointerException("other == null");
        }
        this.set(other);
    }

    public void set(SavedSearchPanel other) {
        if (other == null) {
            throw new NullPointerException("other == null");
        }
        this.panelIndex = other.panelIndex;
        this.bracketLeft1Selected = other.bracketLeft1Selected;
        this.bracketLeft2Selected = other.bracketLeft2Selected;
        this.bracketRightSelected = other.bracketRightSelected;
        this.operatorId = other.operatorId;
        this.columnId = other.columnId;
        this.comparatorId = other.comparatorId;
        this.value = other.value;
    }

    public int getPanelIndex() {
        return this.panelIndex;
    }

    public void setPanelIndex(int index) {
        this.panelIndex = index;
    }

    public boolean isBracketRightSelected() {
        return this.bracketRightSelected;
    }

    public void setBracketRightSelected(boolean selected) {
        this.bracketRightSelected = selected;
    }

    public int getColumnId() {
        return this.columnId;
    }

    public MetaDataValue getColumn() {
        return MetaDataValueIds.getMetaDataValue(this.columnId);
    }

    public void setColumnId(int id) {
        this.columnId = id;
    }

    public int getComparatorId() {
        return this.comparatorId;
    }

    public Comparator getComparator() {
        return Comparator.get(this.comparatorId);
    }

    public void setComparatorId(int id) {
        this.comparatorId = id;
    }

    public void setComparator(Comparator comparator) {
        this.comparatorId = comparator.getId();
    }

    public boolean isBracketLeft1Selected() {
        return this.bracketLeft1Selected;
    }

    public void setBracketLeft1Selected(boolean selected) {
        this.bracketLeft1Selected = selected;
    }

    public boolean isBracketLeft2Selected() {
        return this.bracketLeft2Selected;
    }

    public void setBracketLeft2Selected(boolean leftBracket2Selected) {
        this.bracketLeft2Selected = leftBracket2Selected;
    }

    public int getOperatorId() {
        return this.operatorId;
    }

    public Operator getOperator() {
        return Operator.get(this.operatorId);
    }

    public void setOperatorId(int id) {
        this.operatorId = id;
    }

    public boolean hasValue() {
        return this.value != null && !this.value.isEmpty();
    }

    public boolean isTrimmedValueEmpty() {
        return this.value == null || this.value.trim().isEmpty();
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value == null ? null : value.trim();
    }

    public String getSqlString(boolean isFirst) {
        if (this.hasSql(isFirst)) {
            Operator operator = this.getOperator();
            MetaDataValue column = this.getColumn();
            Comparator comparator = this.getComparator();
            StringBuilder sb = new StringBuilder();
            if (!isFirst) {
                sb.append(this.bracketLeft1Selected ? " (" : "");
                sb.append(" ").append(operator.toSqlString());
            }
            sb.append(this.bracketLeft2Selected ? " (" : "");
            sb.append(" ").append(column.getCategory()).append(".").append(column.getValueName());
            sb.append(" ").append(comparator.toSqlString());
            sb.append(" ?");
            sb.append(this.bracketRightSelected ? ")" : "");
            return sb.toString();
        }
        return null;
    }

    public boolean hasOperator() {
        return this.getOperator() != null;
    }

    public boolean hasComperator() {
        return this.getComparator() != null;
    }

    public boolean hasColumn() {
        return this.getColumn() != null;
    }

    public boolean hasSql(boolean isFirst) {
        return (isFirst || this.hasOperator()) && this.hasColumn() && this.hasComperator() && this.value != null && !this.value.isEmpty();
    }

    public String toString() {
        String sql = this.getSqlString(false);
        return sql == null ? "" : sql;
    }
}

