/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.domain.metadata.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.jphototagger.domain.metadata.MetaDataValue;
import org.jphototagger.domain.metadata.file.FilesFilenameMetaDataValue;
import org.jphototagger.domain.metadata.search.Join;
import org.jphototagger.domain.metadata.search.ParamStatement;
import org.jphototagger.domain.metadata.search.SavedSearchPanel;
import org.jphototagger.domain.metadata.xmp.XmpDcSubjectsSubjectMetaDataValue;
import org.jphototagger.lib.util.ObjectUtil;
import org.jphototagger.lib.util.StringUtil;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public final class SavedSearch {
    @XmlElementWrapper(name="Keywords")
    @XmlElement(type=String.class)
    private List<String> keywords = new ArrayList<String>();
    @XmlElementWrapper(name="Panels")
    @XmlElement(type=SavedSearchPanel.class)
    private List<SavedSearchPanel> panels = new ArrayList<SavedSearchPanel>();
    private String customSql;
    private Type type;
    private String name;

    public SavedSearch() {
    }

    public SavedSearch(SavedSearch other) {
        if (other == null) {
            throw new NullPointerException("other == null");
        }
        this.set(other);
    }

    public void set(SavedSearch other) {
        if (other == null) {
            throw new NullPointerException("other == null");
        }
        if (other != this) {
            this.panels = other.getDeepCopyPanels();
            this.type = other.type;
        }
    }

    public boolean hasPanels() {
        return this.panels != null && !this.panels.isEmpty();
    }

    public List<SavedSearchPanel> getPanels() {
        return this.getDeepCopyPanels();
    }

    public void setPanels(List<SavedSearchPanel> panels) {
        this.setDeepCopyPanels(panels);
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public boolean isValid() {
        if (this.name == null || this.type == null || !StringUtil.hasContent((String)this.name)) {
            return false;
        }
        if (this.type == Type.CUSTOM_SQL) {
            return StringUtil.hasContent((String)this.customSql);
        }
        if (this.type == Type.KEYWORDS_AND_PANELS) {
            return this.hasKeywords() || this.hasPanels();
        }
        return false;
    }

    public ParamStatement createParamStatement() {
        return this.isCustomSql() ? this.createParamStmtFromCustomSql() : this.createParamStmtFromPanels();
    }

    public boolean isCustomSql() {
        return this.type == Type.CUSTOM_SQL;
    }

    public boolean hasKeywords() {
        return !this.keywords.isEmpty();
    }

    public List<String> getKeywords() {
        return new ArrayList<String>(this.keywords);
    }

    public void setKeywords(List<String> keywords) {
        this.setNotEmptyKeywords(keywords);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name == null ? null : name.trim();
    }

    public String getCustomSql() {
        return this.customSql;
    }

    public void setCustomSql(String customSql) {
        this.customSql = customSql == null ? null : customSql.trim();
    }

    public String toString() {
        return this.name == null ? "" : this.name;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SavedSearch)) {
            return false;
        }
        SavedSearch other = (SavedSearch)obj;
        return ObjectUtil.equals((Object)this.name, (Object)other.name);
    }

    public int hashCode() {
        int hash = 5;
        hash = 73 * hash + (this.name != null ? this.name.hashCode() : 0);
        return hash;
    }

    private List<SavedSearchPanel> getDeepCopyPanels() {
        ArrayList<SavedSearchPanel> copy = new ArrayList<SavedSearchPanel>(this.panels.size());
        for (SavedSearchPanel panel : this.panels) {
            copy.add(new SavedSearchPanel(panel));
        }
        return copy;
    }

    private void setNotEmptyKeywords(List<String> keywords) {
        if (keywords == null) {
            this.keywords = new ArrayList<String>();
            return;
        }
        this.keywords = new ArrayList<String>(keywords.size());
        for (String keyword : keywords) {
            String trimmedKeyword = keyword.trim();
            if (trimmedKeyword.isEmpty()) continue;
            this.keywords.add(trimmedKeyword);
        }
    }

    private void setDeepCopyPanels(List<SavedSearchPanel> panels) {
        if (panels == null) {
            this.panels = new ArrayList<SavedSearchPanel>();
            return;
        }
        this.panels = new ArrayList<SavedSearchPanel>(panels.size());
        for (SavedSearchPanel panel : panels) {
            if (!panel.hasValue()) continue;
            this.panels.add(new SavedSearchPanel(panel));
        }
    }

    private ParamStatement createParamStmtFromCustomSql() {
        ParamStatement stmt = new ParamStatement();
        this.setType(Type.CUSTOM_SQL);
        stmt.setSql(this.customSql);
        stmt.setQuery(true);
        return stmt;
    }

    private ParamStatement createParamStmtFromPanels() {
        ParamStatement stmt = new ParamStatement();
        this.setType(Type.KEYWORDS_AND_PANELS);
        StringBuilder sb = this.getStartSelectFrom();
        this.appendToFrom(sb);
        this.appendWhere(sb);
        this.setStmt(stmt, sb);
        return stmt;
    }

    private StringBuilder getStartSelectFrom() {
        FilesFilenameMetaDataValue filesFilenameMetaDataValue = FilesFilenameMetaDataValue.INSTANCE;
        String filesColumnName = filesFilenameMetaDataValue.getValueName();
        String filesTableName = filesFilenameMetaDataValue.getCategory();
        return new StringBuilder("SELECT DISTINCT " + filesTableName + "." + filesColumnName + " FROM " + filesTableName);
    }

    private void appendToFrom(StringBuilder statement) {
        for (String tablename : SavedSearch.getDistinctTablenamesOfColumns(this.getColumns())) {
            statement.append(Join.getJoinToFiles(tablename, Join.Type.INNER));
        }
        String sql = Join.removeMultipleJoinsToFiles(statement.toString(), Join.Type.INNER);
        statement.replace(0, statement.length(), sql);
    }

    private static Set<String> getDistinctTablenamesOfColumns(Collection<? extends MetaDataValue> columns) {
        if (columns == null) {
            throw new NullPointerException("columns == null");
        }
        HashSet<String> tablenames = new HashSet<String>();
        for (MetaDataValue metaDataValue : columns) {
            tablenames.add(metaDataValue.getCategory());
        }
        return tablenames;
    }

    private void appendWhere(StringBuilder statement) {
        statement.append(" WHERE");
        int index = 0;
        for (SavedSearchPanel panel : this.panels) {
            boolean isFirstPanel;
            if (!panel.hasSql(isFirstPanel = index == 0)) continue;
            statement.append(panel.getSqlString(isFirstPanel));
            ++index;
        }
        this.appendKeywordStmt(statement, index > 0);
    }

    private void appendKeywordStmt(StringBuilder statement, boolean and) {
        int count = this.keywords.size();
        if (count == 0) {
            return;
        }
        String paramsInParentheses = this.getParamsInParentheses(count);
        statement.append(and ? " AND" : "").append(" dc_subjects.subject IN ").append(paramsInParentheses).append(" GROUP BY files.filename").append(" HAVING COUNT(*) = ").append(Integer.toString(count));
    }

    private void setStmt(ParamStatement stmt, StringBuilder sb) {
        stmt.setSql(sb.toString());
        this.setValues(stmt);
        stmt.setQuery(true);
    }

    private void setValues(ParamStatement stmt) {
        ArrayList<String> values = new ArrayList<String>(this.panels.size() + this.keywords.size());
        for (SavedSearchPanel panel : this.panels) {
            values.add(panel.getValue());
        }
        values.addAll(this.keywords);
        stmt.setValues(values);
    }

    private List<MetaDataValue> getColumns() {
        ArrayList<MetaDataValue> columns = new ArrayList<MetaDataValue>();
        int index = 0;
        if (this.panels != null) {
            for (SavedSearchPanel panel : this.panels) {
                if (panel.hasSql(index == 0)) {
                    columns.add(panel.getColumn());
                }
                ++index;
            }
        }
        if (!this.keywords.isEmpty()) {
            columns.add(XmpDcSubjectsSubjectMetaDataValue.INSTANCE);
        }
        return columns;
    }

    private String getParamsInParentheses(int count) {
        if (count < 1) {
            throw new IllegalArgumentException("Count < 1: " + count);
        }
        StringBuilder sb = new StringBuilder(count * 2);
        sb.append("(");
        for (int i = 0; i < count; ++i) {
            sb.append(i == 0 ? "" : ",").append("?");
        }
        sb.append(")");
        return sb.toString();
    }

    public static enum Type {
        KEYWORDS_AND_PANELS(0),
        CUSTOM_SQL(1);

        private final short value;

        private Type(short value) {
            this.value = value;
        }

        public short getValue() {
            return this.value;
        }

        public static Type fromValue(short value) {
            for (Type t : Type.values()) {
                if (t.getValue() != value) continue;
                return t;
            }
            return null;
        }
    }
}

